/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.corelib.death;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.death.DeathManager;
import de.maxhenkel.corpse.corelib.death.PlayerDeathEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class DeathEvents {
    private Map<ServerPlayer, Death> deathMap = new HashMap<ServerPlayer, Death>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    void playerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        this.deathMap.put(player, Death.fromPlayer((Player)player));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    void playerDeath(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        try {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Death death = this.deathMap.remove(player);
            if (death == null) {
                death = Death.fromPlayer((Player)player);
            }
            Collection drops = event.getDrops();
            death.processDrops(new ArrayList<ItemEntity>(drops));
            PlayerDeathEvent playerDeathEvent = new PlayerDeathEvent(death, player, event.getSource());
            MinecraftForge.EVENT_BUS.post((Event)playerDeathEvent);
            if (playerDeathEvent.isStoreDeath()) {
                DeathManager.addDeath(player, death);
            }
            if (playerDeathEvent.isRemoveDrops()) {
                drops.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
    }
}

