/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.api.data;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.data.PartialGuiTitle;
import io.github.edwinmindcraft.origins.api.origin.ConditionedOrigin;
import io.github.edwinmindcraft.origins.api.origin.GuiTitle;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import io.github.edwinmindcraft.origins.api.util.JsonUtils;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PartialLayer(@Nullable Integer order, @NotNull Set<ConditionedOrigin> origins, @Nullable Boolean enabled, boolean replace, @Nullable String name, @Nullable String missingName, @Nullable String missingDescription, @Nullable Boolean allowRandom, @Nullable Boolean allowRandomUnchoosable, @NotNull Set<ResourceLocation> excludeRandom, boolean replaceExcludeRandom, @Nullable ResourceLocation defaultOrigin, @Nullable Boolean autoChoose, int loadingPriority, @Nullable Boolean hidden, @Nullable PartialGuiTitle title) {
    public static final Comparator<PartialLayer> LOADING_COMPARATOR = Comparator.comparingInt(PartialLayer::loadingPriority);

    public PartialLayer merge(PartialLayer other) {
        Builder builder = PartialLayer.builder().replace(false).replaceExcludeRandom(false).loadingPriority(0).order(other.order() != null ? other.order() : this.order()).enabled(other.enabled() != null ? other.enabled() : this.enabled()).name(other.name() != null ? other.name() : this.name()).missingName(other.missingName() != null ? other.missingName() : this.missingName()).missingDescription(other.missingDescription() != null ? other.missingDescription() : this.missingDescription()).allowRandom(other.allowRandom() != null ? other.allowRandom() : this.allowRandom()).allowRandomUnchoosable(other.allowRandomUnchoosable() != null ? other.allowRandomUnchoosable() : this.allowRandomUnchoosable()).origins(other.origins()).excludeRandom(other.excludeRandom()).defaultOrigin(other.defaultOrigin() != null ? other.defaultOrigin() : this.defaultOrigin()).autoChoose(other.autoChoose() != null ? other.autoChoose() : this.autoChoose()).hidden(other.hidden() != null ? other.hidden() : this.hidden()).title(PartialGuiTitle.merge(this.title(), other.title()));
        if (!other.replace()) {
            builder.origins(this.origins());
        }
        if (!other.replaceExcludeRandom()) {
            builder.excludeRandom(this.excludeRandom());
        }
        return builder.build();
    }

    public OriginLayer create(ResourceLocation registryName) {
        return new OriginLayer(this.order() != null ? this.order() : 0, (Set<ConditionedOrigin>)ImmutableSet.copyOf(this.origins()), this.enabled() != null ? this.enabled() : true, (Component)Component.m_237115_((String)(this.name() != null ? this.name() : "layer.%s.%s.name".formatted(registryName.m_135827_(), registryName.m_135815_()))), (Component)Component.m_237115_((String)(this.missingName() != null ? this.missingName() : "layer.%s.%s.missing_origin.name".formatted(registryName.m_135827_(), registryName.m_135815_()))), (Component)Component.m_237115_((String)(this.missingDescription() != null ? this.missingDescription() : "layer.%s.%s.missing_origin.description".formatted(registryName.m_135827_(), registryName.m_135815_()))), this.allowRandom() != null ? this.allowRandom() : false, this.allowRandomUnchoosable() != null ? this.allowRandomUnchoosable() : false, (Set<ResourceLocation>)ImmutableSet.copyOf(this.excludeRandom()), (Holder<Origin>)OriginsAPI.getOriginsRegistry().m_246971_(this.defaultOrigin() == null ? Objects.requireNonNull(OriginRegisters.EMPTY.getKey()) : ResourceKey.m_135785_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)this.defaultOrigin())), this.autoChoose() != null ? this.autoChoose() : false, this.hidden() != null ? this.hidden() : false, this.title() != null ? this.title().create(registryName) : GuiTitle.DEFAULT);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer order;
        private final Set<ConditionedOrigin> origins = new HashSet<ConditionedOrigin>();
        private Boolean enabled;
        private boolean replace = false;
        private String name;
        private String missingName;
        private String missingDescription;
        private Boolean allowRandom;
        private Boolean allowRandomUnchoosable;
        private final Set<ResourceLocation> excludeRandom = new HashSet<ResourceLocation>();
        private boolean replaceExcludeRandom = false;
        private ResourceLocation defaultOrigin;
        private Boolean autoChoose;
        private Boolean hidden;
        private int loadingPriority;
        private PartialGuiTitle title;

        private Builder() {
        }

        @Contract(value="_ -> this")
        public Builder order(@Nullable Integer order) {
            this.order = order;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder origins(Collection<ConditionedOrigin> origins) {
            this.origins.addAll(origins);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder missingName(@Nullable String missingName) {
            this.missingName = missingName;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder missingDescription(@Nullable String missingDescription) {
            this.missingDescription = missingDescription;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder allowRandom(@Nullable Boolean allowRandom) {
            this.allowRandom = allowRandom;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder allowRandomUnchoosable(@Nullable Boolean allowRandomUnchoosable) {
            this.allowRandomUnchoosable = allowRandomUnchoosable;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder excludeRandom(Collection<ResourceLocation> excludeRandom) {
            this.excludeRandom.addAll(excludeRandom);
            return this;
        }

        @Deprecated(forRemoval=true, since="2.3.3.1")
        @Contract(value="_ -> this")
        public Builder replaceExcludeRandom(Boolean replaceExcludeRandom) {
            return this.replaceExcludeRandom((boolean)replaceExcludeRandom);
        }

        @Contract(value="_ -> this")
        public Builder replaceExcludeRandom(boolean replaceExcludeRandom) {
            this.replaceExcludeRandom = replaceExcludeRandom;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder defaultOrigin(@Nullable ResourceLocation defaultOrigin) {
            this.defaultOrigin = defaultOrigin;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder autoChoose(@Nullable Boolean autoChoose) {
            this.autoChoose = autoChoose;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder hidden(@Nullable Boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder loadingPriority(int loadingPriority) {
            this.loadingPriority = loadingPriority;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder title(@Nullable PartialGuiTitle title) {
            this.title = title;
            return this;
        }

        public PartialLayer build() {
            return new PartialLayer(this.order, this.origins, this.enabled, this.replace, this.name, this.missingName, this.missingDescription, this.allowRandom, this.allowRandomUnchoosable, this.excludeRandom, this.replaceExcludeRandom, this.defaultOrigin, this.autoChoose, this.loadingPriority, this.hidden, this.title);
        }
    }

    public static enum Serializer implements JsonSerializer<PartialLayer>,
    JsonDeserializer<PartialLayer>
    {
        INSTANCE;


        public PartialLayer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Builder builder = PartialLayer.builder();
            JsonObject root = GsonHelper.m_13918_((JsonElement)json, (String)"root element");
            JsonUtils.getOptional(root, "order", GsonHelper::m_13927_).ifPresent(builder::order);
            JsonUtils.getOptional(root, "enabled", GsonHelper::m_13912_).ifPresent(builder::enabled);
            JsonUtils.getOptional(root, "replace", GsonHelper::m_13912_).ifPresent(builder::replace);
            JsonUtils.getOptional(root, "name", GsonHelper::m_13906_).ifPresent(builder::name);
            JsonUtils.getOptional(root, "missing_name", GsonHelper::m_13906_).ifPresent(builder::missingName);
            JsonUtils.getOptional(root, "missing_description", GsonHelper::m_13906_).ifPresent(builder::missingDescription);
            JsonUtils.getOptional(root, "allow_random", GsonHelper::m_13912_).ifPresent(builder::allowRandom);
            JsonUtils.getOptional(root, "allow_random_unchoosable", GsonHelper::m_13912_).ifPresent(builder::allowRandomUnchoosable);
            JsonUtils.getOptional(root, "default_origin", GsonHelper::m_13906_).map(JsonUtils.rethrow(ResourceLocation::new, "\"default_origin\" isn't a valid identifier")).ifPresent(builder::defaultOrigin);
            JsonUtils.getOptional(root, "auto_choose", GsonHelper::m_13912_).ifPresent(builder::autoChoose);
            JsonUtils.getOptional(root, "replace_exclude_random", GsonHelper::m_13912_).ifPresent(x -> builder.replaceExcludeRandom((boolean)x));
            JsonUtils.getOptional(root, "hidden", GsonHelper::m_13912_).ifPresent(builder::hidden);
            JsonUtils.getOptional(root, "loading_priority", GsonHelper::m_13927_).ifPresent(builder::loadingPriority);
            JsonUtils.getOptional(root, "gui_title", (jsonObject, s) -> (PartialGuiTitle)context.deserialize(jsonObject.get(s), PartialGuiTitle.class)).ifPresent(builder::title);
            builder.origins(JsonUtils.getOptionalList(root, "origins", (jsonElement, s) -> (ConditionedOrigin)context.deserialize(jsonElement, ConditionedOrigin.class)));
            builder.excludeRandom(JsonUtils.getIdentifierList(root, "exclude_random"));
            return builder.build();
        }

        public JsonElement serialize(PartialLayer src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray excludeRandom;
            JsonArray origins;
            JsonObject root = new JsonObject();
            if (src.order() != null) {
                root.addProperty("order", (Number)src.order());
            }
            if (src.enabled() != null) {
                root.addProperty("enabled", src.enabled());
            }
            root.addProperty("replace", Boolean.valueOf(src.replace()));
            if (src.name() != null) {
                root.addProperty("name", src.name());
            }
            if (src.missingName() != null) {
                root.addProperty("missing_name", src.missingName());
            }
            if (src.allowRandom() != null) {
                root.addProperty("allow_random", src.allowRandom());
            }
            if (src.allowRandomUnchoosable() != null) {
                root.addProperty("allow_random_unchoosable", src.allowRandomUnchoosable());
            }
            if (src.defaultOrigin() != null) {
                root.addProperty("default_origin", src.defaultOrigin().toString());
            }
            if (src.autoChoose() != null) {
                root.addProperty("auto_choose", src.autoChoose());
            }
            root.addProperty("replace_exclude_random", Boolean.valueOf(src.replaceExcludeRandom()));
            if (src.hidden() != null) {
                root.addProperty("hidden", src.hidden());
            }
            if ((origins = src.origins().stream().map(x -> context.serialize(x, ConditionedOrigin.class)).collect(JsonUtils.toJsonArray())).size() > 0) {
                root.add("origins", (JsonElement)origins);
            }
            if ((excludeRandom = src.excludeRandom().stream().map(x -> new JsonPrimitive(x.toString())).collect(JsonUtils.toJsonArray())).size() > 0) {
                root.add("exclude_random", (JsonElement)excludeRandom);
            }
            if (src.loadingPriority() != 0) {
                root.addProperty("loading_priority", (Number)src.loadingPriority());
            }
            root.add("gui_title", context.serialize((Object)src.title(), PartialGuiTitle.class));
            return root;
        }
    }
}

