/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record TooltipBadge(ResourceLocation spriteId, Component text) implements Badge
{
    public TooltipBadge(SerializableData.Instance instance) {
        this(instance.getId("sprite"), (Component)instance.get("text"));
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLines(List<ClientTooltipComponent> tooltips, Component text, Font textRenderer, int widthLimit) {
        if (textRenderer.m_92852_((FormattedText)text) > widthLimit) {
            for (FormattedCharSequence orderedText : textRenderer.m_92923_((FormattedText)text, widthLimit)) {
                tooltips.add((ClientTooltipComponent)new ClientTextTooltip(orderedText));
            }
        } else {
            tooltips.add((ClientTooltipComponent)new ClientTextTooltip(text.m_7532_()));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ClientTooltipComponent> getTooltipComponents(ConfiguredPower<?, ?> powerType, int widthLimit, float time, Font textRenderer) {
        LinkedList<ClientTooltipComponent> tooltips = new LinkedList<ClientTooltipComponent>();
        TooltipBadge.addLines(tooltips, this.text, textRenderer, widthLimit);
        return tooltips;
    }

    @Override
    public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", (Object)this.spriteId);
        instance.set("text", (Object)this.text);
        return instance;
    }

    @Override
    public BadgeFactory getBadgeFactory() {
        return (BadgeFactory)BadgeFactories.TOOLTIP.get();
    }
}

