/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Base.TileEntityReactorPiping;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.Thorium.TileEntityThoriumCore;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCrystallizer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityWastePipe
extends TileEntityReactorPiping
implements NeutronTile {
    @Override
    public int getIndex() {
        return ReactorTiles.WASTEPIPE.ordinal();
    }

    public IIcon getBlockIcon() {
        return MatBlocks.CONCRETE.getIcon();
    }

    public IIcon getGlassIcon() {
        return Blocks.field_150362_t.func_149691_a(0, 1);
    }

    public boolean isConnectedToNonSelf(ForgeDirection dir) {
        if (!this.isConnectionValidForSide(dir)) {
            return false;
        }
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        World world = this.field_145850_b;
        Block id = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        return id != this.getMachine().getBlock() || meta != this.getMachine().getBlockMetadata();
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return f == FluidRegistry.getFluid((String)"rc nuclear waste");
    }

    @Override
    protected void onIntake(TileEntity te) {
    }

    public Block getPipeBlockType() {
        return ReactorBlocks.MATS.getBlockInstance();
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }

    @Override
    protected boolean isInteractableTile(TileEntity te) {
        return te instanceof WorldRift || this.isWasteAcceptingBlock(te);
    }

    private boolean isWasteAcceptingBlock(TileEntity te) {
        return te instanceof TileEntityWastePipe || te instanceof TileEntityThoriumCore || te instanceof TileEntityCrystallizer;
    }
}

