/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.MathSci.ReikaNuclearHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaThermoHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.Feedable;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.Base.TileEntityWasteUnit;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWasteContainer
extends TileEntityWasteUnit
implements TemperatureTE,
Feedable,
NeutronTile {
    public static final int WIDTH = 9;
    public static final int HEIGHT = 3;

    @Override
    public int getIndex() {
        return ReactorTiles.WASTECONTAINER.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap()) {
            int waste = this.countWaste();
            this.temperature = (int)((double)this.temperature + (double)waste * ReikaNuclearHelper.getWasteDecayHeat());
            this.updateTemperature(world, x, y, z, meta);
        }
        if (!world.field_72995_K) {
            this.decayWaste();
        }
        if (!world.field_72995_K) {
            this.feed();
        }
    }

    @Override
    protected boolean accountForOutGameTime() {
        return false;
    }

    private void distributeHeat(World world, int x, int y, int z) {
        ForgeDirection side;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature > Tamb && (side = ReikaWorldHelper.checkForAdjSourceBlock((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h)) != null) {
            this.temperature = (int)((double)this.temperature - ReikaThermoHelper.getTemperatureIncrease((double)1.0, (double)15000.0, (double)4180000.0));
            if (this.temperature > 100) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            } else {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)6);
            }
        }
        if (this.temperature < Tamb) {
            this.temperature = Tamb;
        }
        if (this.temperature > this.getMaxTemperature()) {
            this.overheat(world, x, y, z);
        } else if (this.temperature > this.getMaxTemperature() / 2 && rand.nextInt(6) == 0) {
            world.func_72869_a("smoke", (double)x + rand.nextDouble(), (double)(y + 1), (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
        } else if (this.temperature > this.getMaxTemperature() / 4 && rand.nextInt(20) == 0) {
            world.func_72869_a("smoke", (double)x + rand.nextDouble(), (double)(y + 1), (double)z + rand.nextDouble(), 0.0, 0.0, 0.0);
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return this.isLongLivedWaste(itemstack);
    }

    public int func_70302_i_() {
        return 27;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void addTemperature(int T) {
        this.temperature += T;
    }

    public int getMaxTemperature() {
        return 600;
    }

    public void onMeltdown(World world, int x, int y, int z) {
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 9.0f, true);
        RadiationEffects.instance.contaminateArea(world, x, y, z, 9, 4.0f, 1.5, true, RadiationEffects.RadiationIntensity.LETHAL);
        ReactorAchievements.WASTELEAK.triggerAchievement(this.getPlacer());
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        this.distributeHeat(world, x, y, z);
    }

    public int getThermalDamage() {
        return this.temperature / 100;
    }

    public void overheat(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.onMeltdown(world, x, y, z);
        }
    }

    @Override
    public boolean leaksRadiation() {
        return true;
    }

    @Override
    public boolean isValidIsotope(Isotopes i) {
        return !this.isLongLivedWaste(i);
    }

    @Override
    public boolean feed() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block id = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof TileEntityWasteContainer && ((Feedable)tile).feedIn(this.inv[this.inv.length - 1])) {
            for (int i = this.inv.length - 1; i > 0; --i) {
                this.inv[i] = this.inv[i - 1];
            }
            id = world.func_147439_a(x, y + 1, z);
            meta = world.func_72805_g(x, y + 1, z);
            tile = this.getAdjacentTileEntity(ForgeDirection.UP);
            this.inv[0] = tile instanceof TileEntityWasteContainer ? ((Feedable)tile).feedOut() : null;
        }
        this.collapseInventory();
        return false;
    }

    private void collapseInventory() {
        for (int i = 0; i < this.inv.length; ++i) {
            for (int k = this.inv.length - 1; k > 0; --k) {
                if (this.inv[k] != null) continue;
                this.inv[k] = this.inv[k - 1];
                this.inv[k - 1] = null;
            }
        }
    }

    @Override
    public boolean feedIn(ItemStack is) {
        if (is == null) {
            return true;
        }
        if (!this.func_94041_b(0, is)) {
            return false;
        }
        if (this.inv[0] == null) {
            this.inv[0] = is.func_77946_l();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack feedOut() {
        if (this.inv[this.inv.length - 1] == null) {
            return null;
        }
        ItemStack is = this.inv[this.inv.length - 1].func_77946_l();
        this.inv[this.inv.length - 1] = null;
        return is;
    }

    public boolean canBeCooledWithFins() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }
}

