/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorBlock;
import Reika.ReactorCraft.Auxiliary.Temperatured;
import Reika.ReactorCraft.Base.TileEntityLine;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatPipe
extends TileEntityLine {
    private int temperature;

    @Override
    public IIcon getTexture() {
        return Blocks.field_150433_aE.func_149691_a(0, 0);
    }

    @Override
    public int getIndex() {
        return ReactorTiles.HEATPIPE.ordinal();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.balanceHeat(world, x, y, z);
        if (this.getTicksExisted() % 32 == 0) {
            int tdiff = (int)Math.signum(this.temperature - ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z));
            this.temperature -= tdiff;
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (this.temperature == 0) {
            this.temperature = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        }
    }

    private void balanceHeat(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            Temperatured ts;
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (te instanceof TileEntityHeatPipe) {
                TileEntityHeatPipe tile = (TileEntityHeatPipe)te;
                this.balanceWith(tile);
                continue;
            }
            if (te instanceof WorldRift) {
                WorldRift wr = (WorldRift)te;
                TileEntity tile = wr.getTileEntityFrom(this.dirs[i]);
                if (!(tile instanceof TileEntityHeatPipe)) continue;
                TileEntityHeatPipe ts2 = (TileEntityHeatPipe)tile;
                this.balanceWith(ts2);
                continue;
            }
            if (te == null || !this.canConnectToMachine(te.func_145838_q(), te.func_145832_p(), this.dirs[i], te)) continue;
            if (te instanceof Temperatured) {
                ts = (Temperatured)te;
                int diff = this.temperature - ts.getTemperature();
                if (diff <= 0 && !(te instanceof ReactorBlock)) {
                    return;
                }
                int diff2 = diff /= 4;
                ts.setTemperature(ts.getTemperature() + diff2);
                this.temperature -= diff;
                continue;
            }
            if (!(te instanceof TemperatureTE)) continue;
            ts = (TemperatureTE)te;
            int diff = this.temperature - ts.getTemperature();
            if (diff <= 0) {
                return;
            }
            diff = Math.max(1, diff / 4);
            ts.addTemperature(diff);
            this.temperature -= diff;
        }
    }

    private void balanceWith(TileEntityHeatPipe ts) {
        int diff = ts.temperature - this.temperature;
        if (diff <= 0) {
            return;
        }
        diff = Math.max(1, diff / 2);
        ts.temperature -= diff;
        this.temperature += diff;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    protected boolean canConnectToMachine(Block id, int meta, ForgeDirection dir, TileEntity te) {
        return !(!(te instanceof TemperatureTE) && !(te instanceof Temperatured) || te instanceof TileEntityReactorBase && ((TileEntityReactorBase)te).getMachine().getReactorType() == ReactorType.HTGR);
    }

    @Override
    public void onEntityCollided(Entity e) {
        if (this.temperature >= 100) {
            e.func_70097_a(DamageSource.field_76372_a, (float)(this.temperature / 100));
        }
    }
}

