/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.Auxiliary.Trackers.ItemMaterialController;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.ItemMaterial;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityGasCollector
extends TileEntityReactorBase
implements IFluidHandler {
    private final HybridTank tank = new HybridTank("co2collector", 1000);
    private ForgeDirection readDir = ForgeDirection.DOWN;
    public int ticks = 512;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        ItemMaterial mat;
        TileEntityFurnace te;
        ItemStack fuel;
        if (this.ticks > 0) {
            this.ticks -= 8;
        }
        this.readDir = this.dirs[meta].getOpposite();
        Block id = this.getAdjacentLocation(this.readDir).getBlock();
        if (id == Blocks.field_150470_am && (fuel = (te = (TileEntityFurnace)this.getAdjacentTileEntity(this.readDir)).func_70301_a(1)) != null && te.func_145950_i() && te.field_145963_i > 0 && ((mat = ItemMaterialController.instance.getMaterial(fuel)) == ItemMaterial.COAL || mat == ItemMaterial.WOOD)) {
            this.tank.addLiquid(10, FluidRegistry.getFluid((String)"rc co2"));
        }
    }

    public ForgeDirection getReadDirection() {
        return this.readDir;
    }

    public boolean hasFurnace() {
        Block id = this.getAdjacentLocation(this.readDir).getBlock();
        return id == Blocks.field_150460_al || id == Blocks.field_150470_am;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == this.readDir.getOpposite() && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getIndex() {
        return ReactorTiles.COLLECTOR.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(0.5, 0.5, 0.5);
    }
}

