/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySynthesizer
extends TileEntityInventoriedReactorBase
implements IFluidHandler,
ThermalMachine,
PipeConnector {
    private static final int WATER_PER_AMMONIA = 250;
    private static final int AMMONIA_PER_STEP = 1000;
    public static final int AMMONIATEMP = 220;
    private static final int MAXTEMP = 1000;
    public int timer;
    private final HybridTank tank = new HybridTank("synthout", 24000);
    private final HybridTank water = new HybridTank("synthwater", 24000);
    private StepTimer steptimer = new StepTimer(1800);
    private StepTimer tempTimer = new StepTimer(20);

    @Override
    public int getIndex() {
        return ReactorTiles.SYNTHESIZER.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.steptimer.setCap(50);
        this.getWaterBuckets();
        if (this.getWater() > 0 && this.hasAmmonium() && this.hasQuicklime() && this.canMakeAmmonia(1000)) {
            this.steptimer.update();
            if (this.steptimer.checkCap()) {
                this.makeAmmonia();
            }
        } else {
            this.steptimer.reset();
        }
        this.timer = this.steptimer.getTick();
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection lavaside;
        ForgeDirection fireside;
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (waterside != null) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        if ((fireside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab)) != null) {
            Tamb += 200;
        }
        if ((lavaside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i)) != null) {
            Tamb += 600;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1000) {
            this.temperature = 1000;
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    private boolean canMakeAmmonia(int amt) {
        return this.temperature >= 220 && (this.tank.isEmpty() || this.tank.getLevel() + amt < this.tank.getCapacity());
    }

    private void makeAmmonia() {
        ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
        ReikaInventoryHelper.decrStack((int)2, (ItemStack[])this.inv);
        this.water.removeLiquid(250);
        this.tank.addLiquid(1000, FluidRegistry.getFluid((String)"rc ammonia"));
    }

    private boolean hasQuicklime() {
        if (this.inv[1] == null) {
            return false;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[1], (ItemStack)ReactorStacks.lime)) {
            return true;
        }
        ArrayList lime = OreDictionary.getOres((String)"dustQuicklime");
        return ReikaItemHelper.collectionContainsItemStack((Collection)lime, (ItemStack)this.inv[1]);
    }

    private boolean hasAmmonium() {
        if (this.inv[2] == null) {
            return false;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[2], (ItemStack)ReactorStacks.ammonium)) {
            return true;
        }
        ArrayList dust = OreDictionary.getOres((String)"dustAmmonium");
        return ReikaItemHelper.collectionContainsItemStack((Collection)dust, (ItemStack)this.inv[2]);
    }

    private int getWater() {
        return this.water.getLevel();
    }

    public int getWaterScaled(int px) {
        return this.getWater() * px / this.water.getCapacity();
    }

    public int getAmmoniaScaled(int px) {
        return this.tank.getLevel() * px / this.tank.getCapacity();
    }

    public int getTimerScaled(int px) {
        return this.steptimer.getTick() * px / this.steptimer.getCap();
    }

    private void getWaterBuckets() {
        if (this.inv[0] != null && this.inv[0].func_77973_b() == Items.field_151131_as && this.canAcceptMoreWater(1000)) {
            this.water.fill(FluidRegistry.getFluidStack((String)"water", (int)1000), true);
            this.inv[0] = new ItemStack(Items.field_151133_ar);
        }
    }

    public boolean canAcceptMoreWater(int amt) {
        return this.water.getFluid() == null || this.water.getFluid().amount + amt <= this.water.getCapacity();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid.equals(FluidRegistry.getFluid((String)"rc ammonia"));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.water.fill(resource, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.equals(FluidRegistry.WATER);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.tank.getInfo()};
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        if (i == 0) {
            return is.func_77973_b() == Items.field_151131_as;
        }
        if (i == 1) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ReactorStacks.lime);
        }
        if (i == 2) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ReactorStacks.ammonium);
        }
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.timer = NBT.func_74762_e("time");
        this.water.readFromNBT(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.timer);
        this.water.writeToNBT(NBT);
        this.tank.writeToNBT(NBT);
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int T) {
        this.temperature = T;
    }

    public void addTemperature(int T) {
        this.temperature += T;
    }

    public int getMaxTemperature() {
        return 1000;
    }

    public void onOverheat(World world, int x, int y, int z) {
    }

    public boolean canBeFrictionHeated() {
        return true;
    }

    public static boolean isAmmoniaIngredient(ItemStack is) {
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ReactorStacks.ammonium)) {
            return true;
        }
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ReactorStacks.lime);
    }

    public boolean addWater(int amt) {
        if (this.water.canTakeIn(amt)) {
            this.water.addLiquid(amt, FluidRegistry.WATER);
            return true;
        }
        return false;
    }

    @Override
    public boolean canEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean canExitToSide(ForgeDirection dir) {
        return true;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry m, ForgeDirection side) {
        return this.canConnectToPipe(m);
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.OUTPUT;
    }

    public float getMultiplier() {
        return 1.0f;
    }

    public void resetAmbientTemperatureTimer() {
        this.tempTimer.reset();
    }
}

