/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Interfaces.Shockable;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityElectrolyzer
extends TileEntityInventoriedReactorBase
implements ReactorPowerReceiver,
IFluidHandler,
PipeConnector,
TemperatureTE,
ThermalMachine,
Shockable {
    public static final int SODIUM_MELT = 98;
    public static final int SALT_MELT = 801;
    public static final int CAPACITY = 6000;
    public static final int MAXTEMP = 1200;
    private final HybridTank tankL = new HybridTank("lighttank", this.getCapacity());
    private final HybridTank tankH = new HybridTank("heavytank", this.getCapacity());
    private final HybridTank input = new HybridTank("input", this.getCapacity() * 2);
    private StepTimer timer = new StepTimer(50);
    private StepTimer tempTimer = new StepTimer(20);
    public int time;
    private int temperature;
    private int omega;
    private int torque;
    private long power;
    private int iotick = 512;
    public static final int SALTPOWER = 131072;

    @Override
    public int getIndex() {
        return ReactorTiles.ELECTROLYZER.ordinal();
    }

    public int getCapacity() {
        return 6000;
    }

    public int getHLevel() {
        return this.tankH.getLevel();
    }

    public int getLLevel() {
        return this.tankL.getLevel();
    }

    public int getTime() {
        return this.timer.getTick();
    }

    public int getTimerScaled(int d) {
        return d * this.timer.getTick() / this.timer.getCap();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.iotick > 0) {
            this.iotick -= 8;
        }
        if (!PowerTransferHelper.checkPowerFromAllSides((TileEntity)this, (boolean)true)) {
            this.noInputMachine();
        }
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (this.canMakeSodium()) {
            if (this.timer.checkCap()) {
                this.makeSodium();
            }
        } else if (this.canMakeHydrogen()) {
            if (this.timer.checkCap()) {
                this.makeHydrogen();
            }
        } else {
            this.timer.reset();
        }
        this.time = this.timer.getTick();
    }

    private boolean hasSalt() {
        return TileEntityElectrolyzer.isSalt(this.inv[0]);
    }

    private boolean canMakeSodium() {
        if (this.tankL.isFull() || this.tankH.isFull()) {
            return false;
        }
        return this.power >= 131072L && this.temperature >= 801 && this.hasSalt();
    }

    private boolean canMakeHydrogen() {
        if (this.tankL.isFull() || this.tankH.isFull()) {
            return false;
        }
        return this.hasHeavyWater();
    }

    private boolean hasHeavyWater() {
        return !this.input.isEmpty() && this.input.getLevel() > 100 && this.input.getActualFluid().equals(FluidRegistry.getFluid((String)"rc heavy water"));
    }

    private void makeSodium() {
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        this.tankH.addLiquid(100, FluidRegistry.getFluid((String)"rc sodium"));
        this.tankL.addLiquid(100, FluidRegistry.getFluid((String)"rc chlorine"));
    }

    private void makeHydrogen() {
        this.input.removeLiquid(100);
        this.tankH.addLiquid(50, FluidRegistry.getFluid((String)"rc oxygen"));
        this.tankL.addLiquid(100, FluidRegistry.getFluid((String)"rc deuterium"));
    }

    @Deprecated
    private Fluid getHydrogenIsotope() {
        return FluidRegistry.getFluid((String)"rc deuterium");
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int getOmega() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return this.power;
    }

    public int getIORenderAlpha() {
        return this.iotick;
    }

    public void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY != 0 ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.input.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int maxDrain = resource.amount;
        if (from == ForgeDirection.DOWN && resource.getFluid() == this.tankH.getActualFluid()) {
            return this.tankH.drain(maxDrain, doDrain);
        }
        if (from == ForgeDirection.UP && resource.getFluid() == this.tankL.getActualFluid()) {
            return this.tankL.drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.DOWN) {
            return this.tankH.drain(maxDrain, doDrain);
        }
        if (from == ForgeDirection.UP) {
            return this.tankL.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && fluid.equals(FluidRegistry.getFluid((String)"rc heavy water"));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY != 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tankH.getInfo(), this.tankL.getInfo(), this.input.getInfo()};
    }

    public void setOmega(int omega) {
        this.omega = omega;
    }

    public void setTorque(int torque) {
        this.torque = torque;
    }

    public void setPower(long power) {
        this.power = power;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return true;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.omega = 0;
        this.torque = 0;
        this.power = 0L;
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return TileEntityElectrolyzer.isSalt(itemstack);
    }

    public static boolean isSalt(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ItemStacks.salt)) {
            return true;
        }
        ArrayList li = OreDictionary.getOres((String)"salt");
        if (ReikaItemHelper.collectionContainsItemStack((Collection)li, (ItemStack)itemstack)) {
            return true;
        }
        li = OreDictionary.getOres((String)"dustSalt");
        return ReikaItemHelper.collectionContainsItemStack((Collection)li, (ItemStack)itemstack);
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection lavaside;
        ForgeDirection fireside;
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (waterside != null) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        if ((fireside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab)) != null) {
            Tamb += 200;
        }
        if ((lavaside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i)) != null) {
            Tamb += 600;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1200) {
            this.temperature = 1200;
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getThermalDamage() {
        return 0;
    }

    public void overheat(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
    }

    public void onDischarge(int charge, double range) {
        if (this.canMakeSodium() || this.canMakeHydrogen()) {
            int n;
            int extra = charge - this.getMinDischarge();
            int n2 = n = extra > 0 ? (int)Math.sqrt(extra) / 16 : 1;
            if (n == 0) {
                n = 1;
            }
            for (int i = 0; i < n; ++i) {
                this.timer.update();
            }
        }
    }

    public int getMinDischarge() {
        return 4096;
    }

    public void setTemperature(int T) {
        this.temperature = T;
    }

    public int getMaxTemperature() {
        return 1200;
    }

    public void onOverheat(World world, int x, int y, int z) {
    }

    public boolean canBeFrictionHeated() {
        return true;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tankH.writeToNBT(NBT);
        this.tankL.writeToNBT(NBT);
        this.input.writeToNBT(NBT);
        NBT.func_74768_a("omg", this.omega);
        NBT.func_74768_a("tq", this.torque);
        NBT.func_74772_a("pwr", this.power);
        NBT.func_74768_a("temp", this.temperature);
        NBT.func_74768_a("io", this.iotick);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tankH.readFromNBT(NBT);
        this.tankL.readFromNBT(NBT);
        this.input.readFromNBT(NBT);
        this.omega = NBT.func_74762_e("omg");
        this.torque = NBT.func_74762_e("tq");
        this.power = NBT.func_74763_f("pwr");
        this.temperature = NBT.func_74762_e("temp");
        this.iotick = NBT.func_74762_e("io");
    }

    public boolean addHeavyWater(int amt) {
        if (this.input.canTakeIn(amt)) {
            this.input.addLiquid(amt, FluidRegistry.getFluid((String)"rc heavy water"));
            return true;
        }
        return false;
    }

    @Override
    public boolean canEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean canExitToSide(ForgeDirection dir) {
        return false;
    }

    public float getAimX() {
        return 0.5f;
    }

    public float getAimY() {
        return 0.9375f;
    }

    public float getAimZ() {
        return 0.5f;
    }

    public int getInputLevel() {
        return this.input.getLevel();
    }

    public int getMinTorque(int available) {
        return 8;
    }

    @Override
    public int getMinTorque() {
        return 0;
    }

    @Override
    public int getMinSpeed() {
        return 0;
    }

    @Override
    public long getMinPower() {
        return 0L;
    }

    public boolean canBeCooledWithFins() {
        return false;
    }

    public boolean allowExternalHeating() {
        return true;
    }

    public boolean canDischargeLongRange() {
        return false;
    }

    public float getMultiplier() {
        return 0.5f;
    }

    public void resetAmbientTemperatureTimer() {
        this.tempTimer.reset();
    }
}

