/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCentrifuge
extends TileEntityInventoriedReactorBase
implements IFluidHandler,
ReactorPowerReceiver,
PipeConnector {
    private int torque;
    private int omega;
    private long power;
    private int iotick;
    public int split;
    public static final int MINSPEED = 262144;
    private final HybridTank tank = new HybridTank("centri", 12000);
    private StepTimer timer = new StepTimer(900);
    public static final int UF6_PER_DUST = 50;
    public static final int FUEL_CHANCE = 9;

    @Override
    public int getIndex() {
        return ReactorTiles.CENTRIFUGE.ordinal();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (this.omega >= 262144) {
            this.phi += 40.0f;
        } else if (this.omega >= 65536) {
            this.phi += 30.0f;
        } else if (this.omega >= 16384) {
            this.phi += 20.0f;
        } else if (this.omega >= 4096) {
            this.phi += 15.0f;
        }
        if (this.omega >= 1024) {
            this.phi += 10.0f;
        }
        if (this.omega >= 256) {
            this.phi += 7.0f;
        } else if (this.omega > 0) {
            this.phi += 5.0f;
        }
        this.iotick -= 8;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.timer.setCap(this.setTimer());
        if (!PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN)) {
            this.noInputMachine();
        }
        if (this.power > 0L && this.omega >= 262144) {
            if (this.canMake()) {
                this.timer.update();
                if (this.timer.checkCap() && !world.field_72995_K) {
                    this.make();
                }
            }
        } else {
            this.timer.reset();
        }
        if (!world.field_72995_K) {
            this.split = this.timer.getTick();
        }
    }

    private int setTimer() {
        if (this.omega >= 0x4000000) {
            return 8;
        }
        if (this.omega >= 0x2000000) {
            return 20;
        }
        if (this.omega >= 0x1000000) {
            return 50;
        }
        if (this.omega >= 0x800000) {
            return 100;
        }
        if (this.omega >= 0x400000) {
            return 240;
        }
        if (this.omega >= 0x200000) {
            return 400;
        }
        if (this.omega >= 0x100000) {
            return 600;
        }
        if (this.omega >= 524288) {
            return 800;
        }
        return 900;
    }

    private void make() {
        this.tank.drain(50, true);
        if (ReikaRandomHelper.doWithChance((double)9.0)) {
            ReikaInventoryHelper.addOrSetStack((ItemStack)ReactorStacks.fueldust.func_77946_l(), (ItemStack[])this.inv, (int)0);
        } else {
            ReikaInventoryHelper.addOrSetStack((ItemStack)ReactorStacks.depdust.func_77946_l(), (ItemStack[])this.inv, (int)1);
            if (ReikaRandomHelper.doWithChance((double)20.0)) {
                // empty if block
            }
        }
    }

    public boolean canMake() {
        return this.getUF6() >= 50 && this.hasInventorySpace();
    }

    private boolean hasInventorySpace() {
        if (this.inv[0] != null && this.inv[0].field_77994_a >= this.inv[0].func_77976_d()) {
            return false;
        }
        return this.inv[1] == null || this.inv[1].field_77994_a < this.inv[1].func_77976_d();
    }

    public int getProcessingScaled(int p) {
        return (int)((float)(p * this.split) / (float)this.timer.getCap());
    }

    public int getUF6() {
        return this.tank.getFluid() != null ? this.tank.getFluid().amount : 0;
    }

    public int getUF6Scaled(int p) {
        return p * this.getUF6() / this.tank.getCapacity();
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return true;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ReactorStacks.fueldust);
    }

    public int getOmega() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return this.power;
    }

    public int getIORenderAlpha() {
        return this.iotick;
    }

    public void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    public void setOmega(int omega) {
        this.omega = omega;
    }

    public void setTorque(int torque) {
        this.torque = torque;
    }

    public void setPower(long power) {
        this.power = power;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.omega = 0;
        this.torque = 0;
        this.power = 0L;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && fluid.equals(FluidRegistry.getFluid((String)"rc uranium hexafluoride"));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.split = NBT.func_74762_e("time");
        this.omega = NBT.func_74762_e("omg");
        this.torque = NBT.func_74762_e("tq");
        this.power = NBT.func_74763_f("pwr");
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.split);
        NBT.func_74768_a("omg", this.omega);
        NBT.func_74768_a("tq", this.torque);
        NBT.func_74772_a("pwr", this.power);
        this.tank.writeToNBT(NBT);
    }

    public boolean canAcceptMoreUF6(int amt) {
        return this.tank.getFluid() == null || this.tank.getFluid().amount + amt <= this.tank.getCapacity();
    }

    public void addUF6(int amt) {
        this.tank.fill(FluidRegistry.getFluidStack((String)"rc uranium hexafluoride", (int)amt), true);
    }

    public void removeFluid(int volume) {
        this.tank.removeLiquid(volume);
    }

    @Override
    public boolean canEnterFromSide(ForgeDirection dir) {
        return false;
    }

    @Override
    public boolean canExitToSide(ForgeDirection dir) {
        return dir.offsetY == 0;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side == ForgeDirection.UP;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.UP ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public int getMinTorque(int available) {
        return 1;
    }

    @Override
    public int getMinTorque() {
        return 1;
    }

    @Override
    public int getMinSpeed() {
        return 262144;
    }

    @Override
    public long getMinPower() {
        return 1L;
    }
}

