/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.ReactorCraft.Auxiliary.SteamTile;
import Reika.ReactorCraft.Base.TileEntityLine;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.Registry.WorkingFluid;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityReactorBoiler;
import Reika.ReactorCraft.TileEntities.TileEntitySteamDiffuser;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Auxiliary.TileEntityPipePump;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamLine
extends TileEntityLine
implements PumpablePipe,
SteamTile {
    private int steam;
    private WorkingFluid fluid = WorkingFluid.EMPTY;
    private Proportionality<ReactorType> source = new Proportionality();

    @Override
    public int getIndex() {
        return ReactorTiles.STEAMLINE.ordinal();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.drawFromBoiler(world, x, y, z);
        this.getPipeSteam(world, x, y, z);
        if (this.steam <= 0) {
            this.fluid = WorkingFluid.EMPTY;
        }
    }

    @Override
    protected boolean canConnectToMachine(Block id, int meta, ForgeDirection dir, TileEntity te) {
        if (id == ReactorTiles.BOILER.getBlock() && meta == ReactorTiles.BOILER.getBlockMetadata() && dir == ForgeDirection.DOWN) {
            return true;
        }
        if (id == ReactorTiles.GRATE.getBlock() && meta == ReactorTiles.GRATE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.BIGTURBINE.getBlock() && meta == ReactorTiles.BIGTURBINE.getBlockMetadata()) {
            return true;
        }
        if (id == ReactorTiles.DIFFUSER.getBlock() && meta == ReactorTiles.DIFFUSER.getBlockMetadata()) {
            return ((TileEntitySteamDiffuser)this.getAdjacentTileEntity(dir)).getFacing().getOpposite() == dir;
        }
        if (id == MachineRegistry.PIPEPUMP.getBlock() && meta == MachineRegistry.PIPEPUMP.getBlockMetadata()) {
            return ((TileEntityPipePump)this.getAdjacentTileEntity(dir)).canConnectToPipeOnSide(dir);
        }
        return false;
    }

    private void drawFromBoiler(World world, int x, int y, int z) {
        TileEntityReactorBoiler te;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        if (r == ReactorTiles.BOILER && this.canTakeInWorkingFluid((te = (TileEntityReactorBoiler)world.func_147438_o(x, y - 1, z)).getWorkingFluid())) {
            this.fluid = te.getWorkingFluid();
            int s = te.removeSteam();
            this.steam += s;
            this.source.addValue((Object)te.getReactorType(), (double)s);
        }
    }

    private boolean canTakeInWorkingFluid(WorkingFluid f) {
        if (f == WorkingFluid.EMPTY) {
            return false;
        }
        if (this.fluid == WorkingFluid.EMPTY) {
            return true;
        }
        return this.fluid == f;
    }

    private void getPipeSteam(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            WorldRift wr;
            TileEntity tile;
            TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
            if (te instanceof TileEntitySteamLine) {
                TileEntitySteamLine tile2 = (TileEntitySteamLine)te;
                if (!this.canTakeInWorkingFluid(tile2.fluid)) continue;
                this.readPipe(tile2);
                continue;
            }
            if (!(te instanceof WorldRift) || world.field_72995_K || !((tile = (wr = (WorldRift)te).getTileEntityFrom(this.dirs[i])) instanceof TileEntitySteamLine)) continue;
            TileEntitySteamLine ts = (TileEntitySteamLine)tile;
            if (!this.canTakeInWorkingFluid(ts.fluid)) continue;
            this.readPipe(ts);
        }
    }

    private void readPipe(TileEntitySteamLine te) {
        int dS = te.steam - this.steam;
        if (dS > 0) {
            this.steam += dS / 2 + 1;
            te.steam -= dS / 2 + 1;
            this.fluid = te.fluid;
            this.source = te.source;
        }
    }

    @Override
    public int getSteam() {
        return this.steam;
    }

    public void removeSteam(int amt) {
        this.steam -= amt;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.steam = NBT.func_74762_e("energy");
        this.fluid = WorkingFluid.getFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("energy", this.steam);
        this.fluid.saveToNBT(NBT);
    }

    public WorkingFluid getWorkingFluid() {
        return this.fluid;
    }

    public boolean canTransferTo(PumpablePipe p, ForgeDirection dir) {
        if (p instanceof TileEntitySteamLine) {
            WorkingFluid f = ((TileEntitySteamLine)p).fluid;
            return f != WorkingFluid.EMPTY ? f == this.fluid : true;
        }
        return false;
    }

    public int getFluidLevel() {
        return this.getSteam();
    }

    public void transferFrom(PumpablePipe from, int amt) {
        ((TileEntitySteamLine)from).steam -= amt;
        this.fluid = ((TileEntitySteamLine)from).fluid;
        this.steam += amt;
        this.source = ((TileEntitySteamLine)from).source;
    }

    public Proportionality<ReactorType> getSourceReactorType() {
        return this.source;
    }

    @Override
    public IIcon getTexture() {
        return Blocks.field_150325_L.func_149691_a(0, this.isInWorld() ? 15 : 7);
    }
}

