/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.ReactorCraft.Base.TankedReactorPowerReceiver;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.SodiumSolarUpgrades;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySolarExchanger
extends TankedReactorPowerReceiver
implements SodiumSolarUpgrades.SodiumSolarOutput {
    public static final int MINPOWER = 65536;
    public static final int MINSPEED = 2048;

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    @Override
    public int getCapacity() {
        return 1000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return false;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.SOLAR.ordinal();
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
    }

    public boolean isActive() {
        return this.sufficientPower();
    }

    public int receiveSodium(int amt) {
        amt = Math.min(amt, this.tank.getRemainingSpace());
        this.tank.addLiquid(amt, ReactorCraft.NA_hot);
        return amt;
    }

    @Override
    public int getMinTorque() {
        return 1;
    }

    @Override
    public int getMinSpeed() {
        return 2048;
    }

    @Override
    public long getMinPower() {
        return 65536L;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    public int getMinTorque(int available) {
        return 1;
    }
}

