/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.ReactorCraft.Base.TileEntityTankedReactorMachine;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCondenser
extends TileEntityTankedReactorMachine {
    @Override
    public int getIndex() {
        return ReactorTiles.CONDENSER.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.thermalTicker.update();
        if (world.func_147439_a(x, y - 1, z) == ReactorBlocks.STEAM.getBlockInstance() && !this.tank.isFull() && this.temperature < 100 && !world.field_72995_K) {
            int smeta = world.func_72805_g(x, y - 1, z);
            Fluid f = this.getFluidFromSteamMetadata(smeta);
            if (this.tank.isEmpty() || this.tank.getActualFluid().equals(f)) {
                world.func_147468_f(x, y - 1, z);
                this.tank.addLiquid(200, f);
            }
        }
        this.balance(world, x, y, z);
    }

    private Fluid getFluidFromSteamMetadata(int smeta) {
        if ((smeta & 4) == 4) {
            return FluidRegistry.getFluid((String)"rc lowpammonia");
        }
        return FluidRegistry.getFluid((String)"rc lowpwater");
    }

    private void balance(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ReactorTiles rt = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (rt != ReactorTiles.CONDENSER) continue;
            TileEntityCondenser te = (TileEntityCondenser)world.func_147438_o(dx, dy, dz);
            int dL = te.tank.getLevel() - this.tank.getLevel();
            if (dL / 4 <= 0) continue;
            this.tank.addLiquid(dL / 4, te.tank.getActualFluid());
            te.tank.removeLiquid(dL / 4);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public int getCapacity() {
        return 12000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return false;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return false;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.FLUID ? (with == ForgeDirection.UP ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT) : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side == ForgeDirection.UP && this.canConnectToPipe(p);
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.UP ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }
}

