/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import Reika.ReactorCraft.Auxiliary.LinkableReactorCore;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.Breeder.TileEntityBreederCore;
import Reika.ReactorCraft.TileEntities.Fission.Breeder.TileEntitySodiumHeater;
import Reika.ReactorCraft.TileEntities.Fission.Thorium.TileEntityFuelDump;
import Reika.ReactorCraft.TileEntities.Fission.Thorium.TileEntityThoriumCore;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityCPU;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityControlRod;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityFuelRod;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityReactorBoiler;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionHeater;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionInjector;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityNeutronAbsorber;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntitySolenoidMagnet;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityToroidMagnet;
import Reika.ReactorCraft.TileEntities.HTGR.TileEntityCO2Heater;
import Reika.ReactorCraft.TileEntities.HTGR.TileEntityPebbleBed;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityCentrifugalTurbine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityCondenser;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityHeatExchanger;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityHiPTurbine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityReactorPump;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySolarExchanger;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamGrate;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamLine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityCentrifuge;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityElectrolyzer;
import Reika.ReactorCraft.TileEntities.Processing.TileEntitySynthesizer;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityTritizer;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityUProcessor;
import Reika.ReactorCraft.TileEntities.TileEntityFusionMarker;
import Reika.ReactorCraft.TileEntities.TileEntityGasCollector;
import Reika.ReactorCraft.TileEntities.TileEntityGasDuct;
import Reika.ReactorCraft.TileEntities.TileEntityHeatPipe;
import Reika.ReactorCraft.TileEntities.TileEntityHeavyPump;
import Reika.ReactorCraft.TileEntities.TileEntityMagneticPipe;
import Reika.ReactorCraft.TileEntities.TileEntityNeutronReflector;
import Reika.ReactorCraft.TileEntities.TileEntityReactorFlywheel;
import Reika.ReactorCraft.TileEntities.TileEntityReactorGenerator;
import Reika.ReactorCraft.TileEntities.TileEntitySolarTop;
import Reika.ReactorCraft.TileEntities.TileEntitySteamDiffuser;
import Reika.ReactorCraft.TileEntities.TileEntityTurbineMeter;
import Reika.ReactorCraft.TileEntities.Waste.TileEntityWasteContainer;
import Reika.ReactorCraft.TileEntities.Waste.TileEntityWastePipe;
import Reika.ReactorCraft.TileEntities.Waste.TileEntityWasteStorage;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum ReactorTiles implements TileEnum
{
    FUEL("machine.fuel", ReactorBlocks.REACTOR, TileEntityFuelRod.class, 0),
    CONTROL("machine.control", ReactorBlocks.MODELREACTOR, TileEntityControlRod.class, 6, "RenderControl"),
    COOLANT("machine.coolant", ReactorBlocks.REACTOR, TileEntityWaterCell.class, 2),
    CPU("machine.cpu", ReactorBlocks.MACHINE, TileEntityCPU.class, 0),
    TURBINECORE("machine.turbine", ReactorBlocks.MODELREACTOR, TileEntityTurbineCore.class, 0, "RenderTurbine"),
    CONDENSER("machine.condenser", ReactorBlocks.MODELREACTOR, TileEntityCondenser.class, 1, "RenderCondenser"),
    STEAMLINE("machine.steamline", ReactorBlocks.LINE, TileEntitySteamLine.class, 2, "RenderWaterLine"),
    FLUIDEXTRACTOR("machine.heavypump", ReactorBlocks.MODELMACHINE, TileEntityHeavyPump.class, 0, "RenderHeavyPump"),
    CENTRIFUGE("machine.isocentrifuge", ReactorBlocks.MODELMACHINE, TileEntityCentrifuge.class, 1, "RenderCentrifuge"),
    PROCESSOR("machine.processor", ReactorBlocks.MODELMACHINE, TileEntityUProcessor.class, 2, "RenderProcessor"),
    WASTECONTAINER("machine.wastecontainer", ReactorBlocks.MACHINE, TileEntityWasteContainer.class, 2),
    BOILER("machine.reactorboiler", ReactorBlocks.REACTOR, TileEntityReactorBoiler.class, 3),
    GRATE("machine.grate", ReactorBlocks.MODELREACTOR, TileEntitySteamGrate.class, 3, "RenderSteamGrate"),
    PUMP("machine.reactorpump", ReactorBlocks.MODELREACTOR, TileEntityReactorPump.class, 4, "RenderReactorPump"),
    SYNTHESIZER("machine.synthesizer", ReactorBlocks.MACHINE, TileEntitySynthesizer.class, 1),
    MAGNET("machine.magnet", ReactorBlocks.MODELREACTOR, TileEntityToroidMagnet.class, 5, "RenderMagnet"),
    ELECTROLYZER("machine.electrolyzer", ReactorBlocks.MODELMACHINE, TileEntityElectrolyzer.class, 5, "RenderElectrolyzer"),
    TRITIZER("machine.tritizer", ReactorBlocks.REACTOR, TileEntityTritizer.class, 4),
    BREEDER("machine.breedercore", ReactorBlocks.REACTOR, TileEntityBreederCore.class, 5),
    SODIUMBOILER("machine.sodiumboiler", ReactorBlocks.REACTOR, TileEntitySodiumHeater.class, 6),
    EXCHANGER("machine.exchanger", ReactorBlocks.MODELMACHINE, TileEntityHeatExchanger.class, 4, "RenderExchanger"),
    STORAGE("machine.storage", ReactorBlocks.MODELMACHINE, TileEntityWasteStorage.class, 3, "RenderWasteStorage"),
    INJECTOR("machine.injector", ReactorBlocks.REACTOR, TileEntityFusionInjector.class, 7),
    HEATER("machine.fusionheater", ReactorBlocks.REACTOR, TileEntityFusionHeater.class, 8),
    GASPIPE("machine.gasduct", ReactorBlocks.DUCT, TileEntityGasDuct.class, 0, "DuctRenderer"),
    MAGNETPIPE("machine.magnetpipe", ReactorBlocks.DUCT, TileEntityMagneticPipe.class, 1, "DuctRenderer"),
    ABSORBER("machine.absorber", ReactorBlocks.REACTOR, TileEntityNeutronAbsorber.class, 1),
    SOLENOID("machine.solenoid", ReactorBlocks.MODELREACTOR, TileEntitySolenoidMagnet.class, 9, "RenderSolenoid"),
    COLLECTOR("machine.collector", ReactorBlocks.MODELMACHINE, TileEntityGasCollector.class, 6, "RenderGasCollector"),
    PEBBLEBED("machine.pebblebed", ReactorBlocks.REACTOR, TileEntityPebbleBed.class, 9),
    CO2HEATER("machine.co2heater", ReactorBlocks.REACTOR, TileEntityCO2Heater.class, 10),
    FLYWHEEL("machine.turbinewheel", ReactorBlocks.MODELMACHINE, TileEntityReactorFlywheel.class, 7, "RenderTurbineWheel"),
    REFLECTOR("machine.reflector", ReactorBlocks.REACTOR, TileEntityNeutronReflector.class, 11),
    GENERATOR("machine.reactorgenerator", ReactorBlocks.MODELMACHINE, TileEntityReactorGenerator.class, 8, "RenderGenerator"),
    MARKER("machine.fusionmarker", ReactorBlocks.MODELMACHINE, TileEntityFusionMarker.class, 9, "RenderFusionMarker"),
    TURBINEMETER("machine.turbinemeter", ReactorBlocks.MACHINE, TileEntityTurbineMeter.class, 3),
    BIGTURBINE("machine.bigturbine", ReactorBlocks.MODELREACTOR, TileEntityHiPTurbine.class, 7, "RenderBigTurbine"),
    DIFFUSER("machine.steamdiffuser", ReactorBlocks.MODELMACHINE, TileEntitySteamDiffuser.class, 10, "RenderSteamDiffuser"),
    THORIUM("machine.thorium", ReactorBlocks.REACTOR, TileEntityThoriumCore.class, 12),
    WASTEPIPE("machine.wastepipe", ReactorBlocks.DUCT, TileEntityWastePipe.class, 2),
    FUELDUMP("machine.fueldump", ReactorBlocks.REACTOR, TileEntityFuelDump.class, 13),
    SOLAR("machine.solarexchange", ReactorBlocks.MODELMACHINE, TileEntitySolarExchanger.class, 11, "RenderSolarExchanger"),
    SOLARTOP("machine.solartop", ReactorBlocks.MODELMACHINE, TileEntitySolarTop.class, 12, "RenderSolarTop"),
    MINITURBINE("machine.miniturbine", ReactorBlocks.MODELREACTOR, TileEntityCentrifugalTurbine.class, 8, "RenderMiniTurbine"),
    HEATPIPE("machine.heatpipe", ReactorBlocks.LINE, TileEntityHeatPipe.class, 3, "RenderWaterLine");

    private final String name;
    private final Class teClass;
    private final int meta;
    private String render;
    private final ReactorBlocks blockInstance;
    private TileEntity renderInstance;
    private static final BlockMap<ReactorTiles> reactorMappings;
    public static final ReactorTiles[] TEList;

    private ReactorTiles(String n2, ReactorBlocks block, Class<? extends TileEntity> tile, int m) {
        this(n2, block, tile, m, null);
    }

    private ReactorTiles(String n2, ReactorBlocks block, Class<? extends TileEntity> tile, int m, String r) {
        this.teClass = tile;
        this.name = n2;
        this.render = r;
        this.meta = m;
        this.blockInstance = block;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public Class getTEClass() {
        return this.teClass;
    }

    public static ArrayList<ReactorTiles> getTilesOfBlock(ReactorBlocks b) {
        ArrayList<ReactorTiles> li = new ArrayList<ReactorTiles>();
        for (int i = 0; i < TEList.length; ++i) {
            if (ReactorTiles.TEList[i].blockInstance != b) continue;
            li.add(TEList[i]);
        }
        return li;
    }

    public static TileEntity createTEFromIDAndMetadata(Block id, int meta) {
        ReactorTiles index = ReactorTiles.getMachineFromIDandMetadata(id, meta);
        if (index == null) {
            ReactorCraft.logger.logError((Object)("ID " + id + " and metadata " + meta + " are not a valid machine identification pair!"));
            return null;
        }
        Class TEClass = index.teClass;
        try {
            return (TileEntity)TEClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)ReactorCraft.instance, "ID " + id + " and Metadata " + meta + " failed to instantiate its TileEntity of " + TEClass);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)ReactorCraft.instance, "ID " + id + " and Metadata " + meta + " failed illegally accessed its TileEntity of " + TEClass);
        }
    }

    public static ReactorTiles getMachineFromIDandMetadata(Block id, int meta) {
        return (ReactorTiles)((Object)reactorMappings.get(id, meta));
    }

    public boolean isAvailableInCreativeInventory() {
        if (this == GENERATOR) {
            return PowerTypes.RF.isLoaded();
        }
        return true;
    }

    public static ReactorTiles getTE(IBlockAccess iba, int x, int y, int z) {
        Block id = iba.func_147439_a(x, y, z);
        int meta = iba.func_72805_g(x, y, z);
        return ReactorTiles.getMachineFromIDandMetadata(id, meta);
    }

    public ItemStack getCraftedProduct() {
        return new ItemStack(ReactorItems.PLACER.getItemInstance(), 1, this.ordinal());
    }

    public TileEntity createTEInstanceForRender() {
        if (this.renderInstance == null) {
            try {
                this.renderInstance = (TileEntity)this.teClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RegistrationException((DragonAPIMod)ReactorCraft.instance, "Could not create TE instance to render " + (Object)((Object)this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RegistrationException((DragonAPIMod)ReactorCraft.instance, "Could not create TE instance to render " + (Object)((Object)this));
            }
        }
        return this.renderInstance;
    }

    public boolean hasRender() {
        return this.render != null;
    }

    public String getRenderer() {
        if (!this.hasRender()) {
            throw new RuntimeException("Machine " + this.name + " has no render to call!");
        }
        return "Reika.ReactorCraft.Renders." + this.render;
    }

    public int getTextureStates() {
        switch (this) {
            case COOLANT: {
                return TileEntityWaterCell.LiquidStates.list.length;
            }
            case BOILER: 
            case SODIUMBOILER: 
            case CO2HEATER: {
                return 4;
            }
            case PEBBLEBED: 
            case FUEL: 
            case BREEDER: 
            case TRITIZER: 
            case THORIUM: {
                return 5;
            }
            case INJECTOR: {
                return 3;
            }
            case TURBINEMETER: {
                return 3;
            }
        }
        return 1;
    }

    public boolean hasSidedTextures() {
        return false;
    }

    public boolean isEndTextured() {
        switch (this) {
            case CONTROL: 
            case WASTECONTAINER: 
            case SYNTHESIZER: 
            case FUELDUMP: {
                return true;
            }
        }
        return false;
    }

    public boolean isTopSameTextureAsBottom() {
        switch (this) {
            case FUELDUMP: {
                return false;
            }
        }
        return true;
    }

    public boolean hasTextureStates() {
        return this.getTextureStates() > 1;
    }

    public Block getBlock() {
        return this.getBlockInstance();
    }

    public Block getBlockInstance() {
        return this.blockInstance.getBlockInstance();
    }

    public int getBlockMetadata() {
        return this.meta % 16;
    }

    public boolean renderInPass1() {
        switch (this) {
            case PROCESSOR: 
            case MAGNET: 
            case GASPIPE: 
            case MAGNETPIPE: 
            case COLLECTOR: 
            case SOLARTOP: {
                return true;
            }
        }
        return false;
    }

    public boolean isDummiedOut() {
        return false;
    }

    public void addRecipe(IRecipe ir) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(ir, RecipeHandler.RecipeLevel.CORE);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)ir);
            }
        }
    }

    public void addRecipe(ItemStack is, Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(is, RecipeHandler.RecipeLevel.CORE, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            }
        }
    }

    public void addCrafting(Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(this.getCraftedProduct(), RecipeHandler.RecipeLevel.CORE, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)this.getCraftedProduct(), (Object[])obj);
            }
        }
    }

    public void addSizedCrafting(int num, Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), RecipeHandler.RecipeLevel.CORE, obj);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), (Object[])obj);
            }
        }
    }

    public void addSizedOreCrafting(int num, Object ... obj) {
        if (!this.isDummiedOut()) {
            WorktableRecipes.getInstance().addRecipe((IRecipe)new ShapedOreRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), obj), RecipeHandler.RecipeLevel.CORE);
            if (ConfigRegistry.TABLEMACHINES.getState()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)num), obj));
            }
        }
    }

    public static void loadMappings() {
        for (int i = 0; i < TEList.length; ++i) {
            ReactorTiles r = TEList[i];
            Block id = r.getBlock();
            int meta = r.getBlockMetadata();
            reactorMappings.put(id, meta, (Object)r);
        }
    }

    public boolean isPipe() {
        return this == GASPIPE || this == MAGNETPIPE;
    }

    public ReactorType getReactorType() {
        switch (this) {
            case INJECTOR: 
            case MAGNET: 
            case MAGNETPIPE: 
            case ABSORBER: 
            case HEATER: 
            case SOLENOID: {
                return ReactorType.FUSION;
            }
            case COOLANT: 
            case BOILER: 
            case FUEL: 
            case CONTROL: 
            case CPU: {
                return ReactorType.FISSION;
            }
            case SODIUMBOILER: 
            case BREEDER: {
                return ReactorType.BREEDER;
            }
            case CO2HEATER: 
            case PEBBLEBED: {
                return ReactorType.HTGR;
            }
            case THORIUM: {
                return ReactorType.THORIUM;
            }
        }
        return null;
    }

    public boolean isTurbine() {
        return TileEntityTurbineCore.class.isAssignableFrom(this.teClass);
    }

    public boolean isPowerReceiver() {
        return ReactorPowerReceiver.class.isAssignableFrom(this.teClass);
    }

    public boolean isMultiblock() {
        return MultiBlockTile.class.isAssignableFrom(this.teClass);
    }

    public boolean isReactorCore() {
        return ReactorCoreTE.class.isAssignableFrom(this.teClass);
    }

    public boolean isLinkableReactorCore() {
        return LinkableReactorCore.class.isAssignableFrom(this.teClass);
    }

    public ItemStack getCraftedProduct(TileEntity te) {
        return this.getCraftedProduct();
    }

    public boolean allowTickAcceleration() {
        switch (this) {
            case PROCESSOR: {
                return true;
            }
        }
        return false;
    }

    static {
        reactorMappings = new BlockMap();
        TEList = ReactorTiles.values();
    }
}

