/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.BoundedConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.UserSpecificConfig;
import Reika.ReactorCraft.ReactorCraft;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Property;

public enum ReactorOptions implements IntegerConfig,
BooleanConfig,
BoundedConfig,
UserSpecificConfig
{
    VISIBLENEUTRONS("Visible Neutrons", true),
    SILVERORE("Generate Silver Ore Even If Other Mods Do", true),
    MAGNETORE("Generate Magnetite Ore Even If Other Mods Do", true),
    CALCITEORE("Generate Calcite Ore Even If Other Mods Do", true),
    CADMIUMORE("Generate Cadmium Ore Even If Other Mods Do", true),
    INDIUMORE("Generate Indium Ore Even If Other Mods Do", true),
    RETROGEN("Retrogen Ores", false),
    RAINBOW("Rainbow Fluorite", false),
    TOROIDCHARGE("Toroid Spark Delay", 4),
    CHUNKLOADING("Fission Cores Chunkload When Active", true),
    OREDENSITY("Ore Density Percentage", 100),
    DISCRETE("Ore Discretization", 1),
    DYECRAFT("Allow Fluorite Recoloring", false),
    FASTNEUTRONS("Enable Fast and Thermal Neutrons", false);

    private String label;
    private boolean defaultState;
    private int defaultValue;
    private Class type;
    public static final ReactorOptions[] optionList;

    private ReactorOptions(String l, boolean d) {
        this.label = l;
        this.defaultState = d;
        this.type = Boolean.TYPE;
    }

    private ReactorOptions(String l, int d) {
        this.label = l;
        this.defaultValue = d;
        this.type = Integer.TYPE;
    }

    public boolean isBoolean() {
        return this.type == Boolean.TYPE;
    }

    public boolean isNumeric() {
        return this.type == Integer.TYPE;
    }

    public Class getPropertyType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean getState() {
        return (Boolean)ReactorCraft.config.getControl(this.ordinal());
    }

    public int getValue() {
        return (Integer)ReactorCraft.config.getControl(this.ordinal());
    }

    public boolean isDummiedOut() {
        return this.type == null;
    }

    public boolean getDefaultState() {
        return this.defaultState;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isEnforcingDefaults() {
        return false;
    }

    public boolean shouldLoad() {
        return true;
    }

    public static int getToroidChargeRate() {
        int base = TOROIDCHARGE.getValue();
        return Math.max(Math.min(base, 20), 4);
    }

    public static float getOreMultiplier() {
        return MathHelper.func_76131_a((float)((float)OREDENSITY.getValue() / 100.0f), (float)0.5f, (float)2.0f);
    }

    public boolean isValueValid(Property p) {
        switch (this) {
            case DISCRETE: {
                return p.getInt() > 0 && p.getInt() <= 100;
            }
        }
        return true;
    }

    public String getBoundsAsString() {
        switch (this) {
            case DISCRETE: {
                return "(1-100)";
            }
        }
        return "";
    }

    public boolean isUserSpecific() {
        switch (this) {
            case VISIBLENEUTRONS: {
                return true;
            }
        }
        return false;
    }

    static {
        optionList = ReactorOptions.values();
    }
}

