/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.ReactorCraft.Registry.ReactorItems;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum ReactorFuel {
    URANIUM(ReactorItems.FUEL.getItemInstance(), 25, 3, 5, 20),
    PLUTONIUM(ReactorItems.PLUTONIUM.getItemInstance(), 30, 4, 10, 30);

    private final Item fuel;
    public final int fissionChance;
    public final int consumeChance;
    public final int wasteChance;
    public final int temperatureStep;
    private static final HashMap<Item, ReactorFuel> itemMap;
    public static final ReactorFuel[] fuelList;

    private ReactorFuel(Item item, int fiss, int con, int waste, int temp) {
        this.fuel = item;
        this.fissionChance = fiss;
        this.consumeChance = con;
        this.wasteChance = waste;
        this.temperatureStep = temp;
    }

    public boolean canProducePower() {
        return true;
    }

    public ItemStack getFuelItem() {
        return new ItemStack(this.fuel);
    }

    public ItemStack getFissionProduct(ItemStack input) {
        if (input == null) {
            return null;
        }
        switch (this) {
            case PLUTONIUM: {
                if (input.func_77960_j() == ReactorItems.PLUTONIUM.getNumberMetadatas() - 1) {
                    return null;
                }
                return ReactorItems.PLUTONIUM.getStackOfMetadata(input.func_77960_j() + 1);
            }
            case URANIUM: {
                if (input.func_77960_j() == ReactorItems.FUEL.getNumberMetadatas() - 1) {
                    return ReactorItems.DEPLETED.getStackOf();
                }
                return ReactorItems.FUEL.getStackOfMetadata(input.func_77960_j() + 1);
            }
        }
        return null;
    }

    public static ReactorFuel getFrom(ItemStack is) {
        return is != null ? itemMap.get(is.func_77973_b()) : null;
    }

    static {
        itemMap = new HashMap();
        fuelList = ReactorFuel.values();
        for (int i = 0; i < fuelList.length; ++i) {
            ReactorFuel f = fuelList[i];
            itemMap.put(f.fuel, f);
        }
    }
}

