/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Registry;

import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorOres;
import java.util.Locale;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum FluoriteTypes {
    BLUE(0, 38, 255),
    PINK(255, 255, 236),
    ORANGE(255, 155, 0),
    MAGENTA(178, 0, 255),
    GREEN(0, 188, 18),
    RED(255, 50, 50),
    WHITE(255, 255, 255),
    YELLOW(255, 216, 0);

    public final int red;
    public final int green;
    public final int blue;
    public static final FluoriteTypes[] colorList;

    private FluoriteTypes(int r, int g, int b) {
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    public String getOreTextureName() {
        return "ReactorCraft:ore/fluorite_" + this.getColorName();
    }

    public String getBlockTextureName() {
        return "ReactorCraft:mat/floblock_" + this.getColorName();
    }

    public String getColorName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public static FluoriteTypes getRandomColor() {
        Random r = new Random();
        int c = colorList.length;
        return colorList[r.nextInt(c)];
    }

    public String getBlockName() {
        if (ReactorOptions.RAINBOW.getState()) {
            return StatCollector.func_74838_a((String)"block.fluorite");
        }
        return this.getName() + " " + StatCollector.func_74838_a((String)"block.fluorite");
    }

    public String getOreName() {
        return this.getName() + " " + StatCollector.func_74838_a((String)"ore.fluorite");
    }

    public String getItemName() {
        return this.getName() + " " + StatCollector.func_74838_a((String)"item.fluorite");
    }

    public String getName() {
        return ReikaStringParser.capFirstChar((String)this.name());
    }

    public ItemStack getItem() {
        return ReactorItems.FLUORITE.getStackOfMetadata(this.ordinal());
    }

    public ItemStack getOreBlock() {
        return new ItemStack(ReactorOres.FLUORITE.getBlock(), 1, this.ordinal());
    }

    public ItemStack getStorageBlock() {
        return new ItemStack(ReactorBlocks.FLUORITE.getBlockInstance(), 1, this.ordinal());
    }

    public int getColor() {
        return ReikaColorAPI.RGBtoHex((int)this.red, (int)this.green, (int)this.blue);
    }

    public ReikaDyeHelper getCorrespondingDyeType() {
        return ReikaDyeHelper.valueOf((String)this.name());
    }

    static {
        colorList = FluoriteTypes.values();
    }
}

