/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft;

import Reika.DragonAPI.Instantiable.Recipe.FluidInputRecipe;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.MathSci.Isotopes;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Auxiliary.WasteManager;
import Reika.ReactorCraft.Registry.CraftingItems;
import Reika.ReactorCraft.Registry.FluoriteTypes;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorOres;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCentrifuge;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCompactor;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCrystallizer;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesFrictionHeater;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesGrinder;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesPulseFurnace;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityFuelConverter;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ReactorRecipes {
    private static void addRCInterface() {
        GameRegistry.addShapelessRecipe((ItemStack)ItemRegistry.RAILGUN.getCraftedMetadataProduct(3, 7), (Object[])new Object[]{ReactorItems.DEPLETED.getStackOf()});
        GameRegistry.addShapelessRecipe((ItemStack)ItemRegistry.RAILGUN.getCraftedMetadataProduct(1, 7), (Object[])new Object[]{ReactorItems.OLDPELLET.getStackOf()});
        GameRegistry.addShapelessRecipe((ItemStack)FluoriteTypes.WHITE.getItem(), (Object[])new Object[]{ItemStacks.getModOreIngot((ModOreList)ModOreList.FLUORITE)});
        RecipesGrinder.getRecipes().addRecipe(ReactorOres.PITCHBLENDE.getProduct(), CraftingItems.UDUST.getItem());
        RecipesGrinder.getRecipes().addRecipe(ItemStacks.getModOreIngot((ModOreList)ModOreList.PITCHBLENDE), CraftingItems.UDUST.getItem());
        RecipesGrinder.getRecipes().addOreDictRecipe(ModOreList.PITCHBLENDE.getProductOreDictName(), CraftingItems.UDUST.getItem(), RecipeHandler.RecipeLevel.CORE);
        RecipesGrinder.getRecipes().addOreDictRecipe(ModOreList.URANIUM.getProductOreDictName(), CraftingItems.UDUST.getItem(), RecipeHandler.RecipeLevel.CORE);
        RecipesGrinder.getRecipes().addRecipe(ItemStacks.tungsteningot, ItemStacks.tungstenflakes);
        RecipesGrinder.getRecipes().addRecipe(new ItemStack(Items.field_151166_bC), ReactorStacks.emeralddust);
        RecipesCrystallizer.getRecipes().addRecipe(FluidRegistry.getFluid((String)"rc nuclear waste"), 50, ReactorStacks.wastedust, RecipeHandler.RecipeLevel.CORE);
        RecipesCentrifuge.getRecipes().addRecipe(ReactorStacks.wastedust, WasteManager.getThoriumOutputs(true), null, RecipeHandler.RecipeLevel.CORE);
        for (Isotopes.ElementGroup g : Isotopes.ElementGroup.values()) {
            RecipesCentrifuge.getRecipes().addRecipe(WasteManager.getWaste(g), WasteManager.getThoriumGroupOutputs(g), null, RecipeHandler.RecipeLevel.CORE);
        }
        RecipesPulseFurnace.getRecipes().addSmelting(CraftingItems.CARBIDEFLAKES.getItem(), CraftingItems.CARBIDE.getItem());
        RecipesCompactor.getRecipes().addRecipe(ReactorStacks.lodestone.func_77946_l(), ReactorItems.MAGNET.getCraftedProduct(2), 5000, 100);
        for (int i = 0; i < ReactorItems.MAGNET.getNumberMetadatas() - 1; ++i) {
            RecipesCompactor.getRecipes().addRecipe(ReactorItems.MAGNET.getStackOfMetadata(i), ReactorItems.MAGNET.getCraftedMetadataProduct(2, i + 1), 10000 * (1 + i), 100);
        }
        TileEntityFuelConverter.Conversions.addRecipe((String)"LIFBE", (String)"rc lifbe", (String)"rc lifbe fuel", (int)100, (int)1, (double)100.0, (ItemMatch[])new ItemMatch[]{new ItemMatch(ReactorItems.FLUORITE.getItemInstance()), new ItemMatch("dustThorium")});
        if (ModList.IC2.isLoaded() && !IC2Handler.getInstance().isIC2Classic()) {
            TileEntityFuelConverter.Conversions.addRecipe((String)"Distill", (String)"rc lowpwater", (String)"ic2distilledwater", (int)25, (int)1, (double)40.0, (ItemMatch[])new ItemMatch[]{new ItemMatch(ReactorStacks.lime)});
        }
    }

    public static void addModInterface() {
        ReactorRecipes.addRCInterface();
        ArrayList li = OreDictionary.getOres((String)ReactorOres.MAGNETITE.getProductDictionaryName());
        for (ItemStack is : li) {
            if (is.func_77973_b() == ReactorStacks.lodestone.func_77973_b()) continue;
            GameRegistry.addShapelessRecipe((ItemStack)is.func_77946_l(), (Object[])new Object[]{ReactorStacks.lodestone});
        }
        GameRegistry.addRecipe((IRecipe)new FluidInputRecipe.ShapelessFluidInputRecipe(MatBlocks.CONCRETE.getStackOf(4), new Object[]{Blocks.field_150435_aG, Blocks.field_150354_m, Blocks.field_150351_n, FluidRegistry.WATER}));
        if (FluidRegistry.getFluid((String)"oil") != null) {
            GameRegistry.addRecipe((IRecipe)new FluidInputRecipe.ShapelessFluidInputRecipe(MatBlocks.CONCRETE.getStackOf(6), new Object[]{Blocks.field_150354_m, Blocks.field_150351_n, FluidRegistry.getFluid((String)"oil")}));
        }
    }

    public static void addRecipes() {
        ReactorRecipes.addMachines();
        ReactorRecipes.addCrafting();
        ReactorRecipes.addItems();
        ReactorRecipes.addMisc();
        ReactorRecipes.addMultiblocks();
        ReactorRecipes.addSmelting();
    }

    private static void addMultiblocks() {
        Block id = ReactorBlocks.HEATERMULTI.getBlockInstance();
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 0), (Object[])new Object[]{"SBS", "BLB", "SBS", Character.valueOf('B'), BlockRegistry.BLASTGLASS.getStackOf(), Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('L'), ItemStacks.lens});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 1), (Object[])new Object[]{"WWW", "WSW", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('S'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 2), (Object[])new Object[]{"SOS", "OSO", "SOS", Character.valueOf('O'), ReactorStacks.insulCore, Character.valueOf('S'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 3), (Object[])new Object[]{"OSO", "SSS", "OSO", Character.valueOf('O'), ReactorStacks.insulCore, Character.valueOf('S'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 4), (Object[])new Object[]{"SSS", "SOS", "SSS", Character.valueOf('O'), ReactorStacks.insulCore, Character.valueOf('S'), ItemStacks.steelingot});
        id = ReactorBlocks.INJECTORMULTI.getBlockInstance();
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 0), (Object[])new Object[]{"WWW", "HHH", "MMM", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 1), (Object[])new Object[]{"MWM", "MHM", "MMM", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 2), (Object[])new Object[]{"WMW", "MHM", "WMW", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 3), (Object[])new Object[]{"MMM", "HHH", "WWW", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 4), (Object[])new Object[]{"MMM", "MHM", "MWM", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 5), (Object[])new Object[]{"MWM", "HHH", "MWM", Character.valueOf('H'), CraftingItems.WIRE.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 6), (Object[])new Object[]{"MWM", "MHM", "MWM", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 7), (Object[])new Object[]{"HWH", "WMW", "HWH", Character.valueOf('H'), CraftingItems.HYSTERESIS.getItem(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('W'), ReactorStacks.insulCore});
        id = ReactorBlocks.SOLENOIDMULTI.getBlockInstance();
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 0), (Object[])new Object[]{"SSS", "SSS", "SSS", Character.valueOf('S'), CraftingItems.FERROINGOT.getItem()});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 1), (Object[])new Object[]{"SSS", "SBS", "SSS", Character.valueOf('S'), CraftingItems.FERROINGOT.getItem(), Character.valueOf('B'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 2), (Object[])new Object[]{"SSS", "MMM", "SSS", Character.valueOf('M'), ReactorStacks.maxMagnet, Character.valueOf('S'), CraftingItems.MAGNETIC.getItem()});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 3), (Object[])new Object[]{"SSS", "MMM", "SSS", Character.valueOf('M'), ReactorStacks.weakerMagnet, Character.valueOf('S'), CraftingItems.MAGNETIC.getItem()});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 4), (Object[])new Object[]{"SSS", "MMM", "SSS", Character.valueOf('M'), CraftingItems.FERROINGOT.getItem(), Character.valueOf('S'), CraftingItems.HYSTERESIS.getItem()});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 5), (Object[])new Object[]{"SSS", "WPW", "SSS", Character.valueOf('W'), CraftingItems.WIRE.getItem(), Character.valueOf('P'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('S'), CraftingItems.FERROINGOT.getItem()});
        id = ReactorBlocks.GENERATORMULTI.getBlockInstance();
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 0), (Object[])new Object[]{"SsS", "sss", "SsS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('s'), ItemStacks.shaftitem});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 1), (Object[])new Object[]{"SSS", "SBS", "SSS", Character.valueOf('S'), CraftingItems.WIRE.getItem(), Character.valueOf('B'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 2), (Object[])new Object[]{"SSS", "MMM", "SSS", Character.valueOf('M'), CraftingItems.WIRE.getItem(), Character.valueOf('S'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 3), (Object[])new Object[]{"W W", " S ", "W W", Character.valueOf('W'), ReikaItemHelper.blackWool, Character.valueOf('S'), ItemStacks.steelingot});
        id = ReactorBlocks.TURBINEMULTI.getBlockInstance();
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 0), (Object[])new Object[]{"sss", "sss", "sss", Character.valueOf('s'), ItemStacks.prop});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 1), (Object[])new Object[]{"BBB", "SSS", "ppp", Character.valueOf('B'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('p'), ItemStacks.prop});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 2), (Object[])new Object[]{"PbP", "bPb", "PbP", Character.valueOf('P'), ItemStacks.pipe, Character.valueOf('b'), ItemStacks.basepanel});
        id = ReactorBlocks.FLYWHEELMULTI.getBlockInstance();
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 0), (Object[])new Object[]{"sss", "sSs", "sss", Character.valueOf('s'), ItemStacks.steelingot, Character.valueOf('S'), ItemStacks.steelblock});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 1), (Object[])new Object[]{"WWW", "SSS", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('S'), ItemStacks.steelingot});
        GameRegistry.addRecipe((ItemStack)new ItemStack(id, 1, 2), (Object[])new Object[]{"sss", "sSs", "sss", Character.valueOf('s'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot});
    }

    private static void addCrafting() {
        CraftingItems.TANK.addRecipe("OOO", "O O", "OOO", Character.valueOf('O'), BlockRegistry.BLASTGLASS.getStackOf());
        CraftingItems.CANISTER.addRecipe(" S ", "SCS", " S ", Character.valueOf('S'), CraftingItems.ALLOY.getItem(), Character.valueOf('C'), Blocks.field_150486_ae);
        CraftingItems.ROD.addRecipe("SAS", "ACA", "SAS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('A'), CraftingItems.ALLOY.getItem(), Character.valueOf('C'), CraftingItems.GRAPHITE.getItem());
        CraftingItems.MAGNETIC.addSizedRecipe(3, "SSS", Character.valueOf('S'), CraftingItems.FERROINGOT.getItem());
        CraftingItems.MAGNETCORE.addRecipe("CCC", "C C", "CCC", Character.valueOf('C'), CraftingItems.MAGNETIC.getItem());
        CraftingItems.HYSTERESISRING.addRecipe("CCC", "C C", "CCC", Character.valueOf('C'), CraftingItems.HYSTERESIS.getItem());
        CraftingItems.WIRE.addSizedRecipe(2, "  G", " G ", "G  ", Character.valueOf('G'), Items.field_151043_k);
        CraftingItems.HYSTERESIS.addSizedRecipe(DifficultyEffects.PARTCRAFT.getInt(), "ISI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), ItemStacks.steelingot);
        CraftingItems.COOLANT.addRecipe("SPS", "S S", "SpS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), Blocks.field_150410_aZ, Character.valueOf('p'), ItemStacks.pipe);
        CraftingItems.FABRIC.addSizedRecipe(3, "LDL", "LDL", "LDL", Character.valueOf('D'), ReactorItems.DEPLETED.getStackOf(), Character.valueOf('L'), Items.field_151116_aA);
        CraftingItems.FABRIC.addSizedRecipe(1, "LDL", "LDL", "LDL", Character.valueOf('D'), ReactorItems.OLDPELLET.getStackOf(), Character.valueOf('L'), Items.field_151116_aA);
        CraftingItems.FABRIC.addSizedOreRecipe(2, "LDL", "LDL", "LDL", Character.valueOf('D'), "ingotLead", Character.valueOf('L'), Items.field_151116_aA);
        CraftingItems.CARBIDEFLAKES.addShapelessOreRecipe("dustCoal", ItemStacks.tungstenflakes);
        CraftingItems.TURBCORE.addRecipe("CCC", "CTC", "CCC", Character.valueOf('C'), CraftingItems.CARBIDE.getItem(), Character.valueOf('T'), ItemStacks.compoundturb);
        ItemStack is = ReikaItemHelper.getSizedItemStack((ItemStack)CraftingItems.ALLOY.getItem(), (int)3);
        ShapelessOreRecipe slr = new ShapelessOreRecipe(is, new Object[]{"ingotCadmium", "ingotIndium", "ingotSilver"});
        RecipesBlastFurnace.getRecipes().addAlloyingRecipe(is, 1600, (IRecipe)slr, 1, 0.8f);
        is = ReikaItemHelper.getSizedItemStack((ItemStack)CraftingItems.FERROINGOT.getItem(), (int)1);
        ShapelessOreRecipe sor = new ShapelessOreRecipe(is, new Object[]{ItemStacks.steelingot, Items.field_151042_j, ReactorStacks.lodestone});
        RecipesBlastFurnace.getRecipes().addAlloyingRecipe(is, 1200, (IRecipe)sor, 1, 1.0f);
        if (ReikaItemHelper.oreItemExists((String)"ingotNickel")) {
            sor = new ShapelessOreRecipe(is, new Object[]{ItemStacks.steelingot, "ingotNickel", ReactorStacks.lodestone});
            RecipesBlastFurnace.getRecipes().addAlloyingRecipe(is, 1200, (IRecipe)sor, 1, 1.0f);
        }
    }

    private static void addSmelting() {
        ItemStack block;
        int i;
        for (i = 0; i < FluoriteTypes.colorList.length; ++i) {
            FluoriteTypes fl = FluoriteTypes.colorList[i];
            block = new ItemStack(ReactorBlocks.FLUORITEORE.getBlockInstance(), 1, fl.ordinal());
            ItemStack shard = ReactorItems.FLUORITE.getStackOfMetadata(fl.ordinal());
            ReikaRecipeHelper.addSmelting((ItemStack)block, (ItemStack)shard, (float)ReactorOres.FLUORITE.xpDropped);
        }
        for (i = 0; i < ReactorOres.oreList.length; ++i) {
            ReactorOres ore = ReactorOres.oreList[i];
            block = ore.getOreBlock();
            ItemStack drop = ore.getProduct();
            ReikaRecipeHelper.addSmelting((ItemStack)block, (ItemStack)drop, (float)ore.xpDropped);
        }
        ReikaRecipeHelper.addSmelting((ItemStack)ReactorStacks.calcite, (ItemStack)ReactorStacks.lime, (float)0.2f);
        RecipesFrictionHeater.getRecipes().addCoreRecipe(ItemStacks.coaldust, CraftingItems.GRAPHITE.getItem(), 400, 100);
        RecipesBlastFurnace.getRecipes().addRecipe(ReactorStacks.lime, 850, ReikaRecipeHelper.getShapelessRecipeFor((ItemStack)ReactorStacks.lime, (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151110_aK)}), 1, 0.1f);
    }

    private static void addMisc() {
        for (int i = 0; i < FluoriteTypes.colorList.length; ++i) {
            FluoriteTypes fl = FluoriteTypes.colorList[i];
            ItemStack block = new ItemStack(ReactorBlocks.FLUORITE.getBlockInstance(), 1, i);
            ItemStack shard = ReactorItems.FLUORITE.getStackOfMetadata(i);
            ItemStack lamp = new ItemStack(ReactorBlocks.LAMP.getBlockInstance(), 1, i);
            GameRegistry.addRecipe((ItemStack)block, (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), shard});
            GameRegistry.addShapelessRecipe((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)shard, (int)9), (Object[])new Object[]{block});
            GameRegistry.addRecipe((ItemStack)lamp, (Object[])new Object[]{"SCS", "C C", "SOS", Character.valueOf('C'), shard, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('O'), Blocks.field_150343_Z});
            if (!ReactorOptions.DYECRAFT.getState()) continue;
            for (int k = 0; k < FluoriteTypes.colorList.length; ++k) {
                if (k == i) continue;
                String dye = FluoriteTypes.colorList[k].getCorrespondingDyeType().getOreDictName();
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ReactorItems.FLUORITE.getStackOfMetadata(k), new Object[]{shard, dye}));
            }
        }
        GameRegistry.addRecipe((ItemStack)MatBlocks.CALCITE.getStackOf(), (Object[])new Object[]{"CCC", "CCC", "CCC", Character.valueOf('C'), ReactorStacks.calcite});
        GameRegistry.addShapelessRecipe((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ReactorStacks.calcite, (int)9), (Object[])new Object[]{MatBlocks.CALCITE.getStackOf()});
        GameRegistry.addRecipe((ItemStack)MatBlocks.SCRUBBER.getStackOf(), (Object[])new Object[]{"IWI", "WPW", "IWI", Character.valueOf('I'), Blocks.field_150411_aY, Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('P'), ItemStacks.pipe});
        GameRegistry.addShapelessRecipe((ItemStack)MatBlocks.CONCRETE.getStackOf(4), (Object[])new Object[]{Blocks.field_150435_aG, Blocks.field_150354_m, Blocks.field_150351_n, Items.field_151131_as});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151116_aA), (Object[])new Object[]{ReactorStacks.lime, Items.field_151078_bh});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151121_aF, 16, 0), new Object[]{ReactorStacks.lime, Items.field_151131_as, "logWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151121_aF, 4, 0), new Object[]{ReactorStacks.lime, Items.field_151131_as, "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151121_aF, 1, 0), new Object[]{ReactorStacks.lime, Items.field_151131_as, "stickWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151121_aF, 1, 0), new Object[]{ReactorStacks.lime, Items.field_151131_as, "dustWood"}));
        GameRegistry.addShapelessRecipe((ItemStack)ReactorStacks.calcite, (Object[])new Object[]{ItemStacks.getModOreIngot((ModOreList)ModOreList.CALCITE)});
        GameRegistry.addShapelessRecipe((ItemStack)ReactorStacks.ammonium, (Object[])new Object[]{ItemStacks.getModOreIngot((ModOreList)ModOreList.AMMONIUM)});
        GameRegistry.addShapelessRecipe((ItemStack)ReactorStacks.lodestone, (Object[])new Object[]{ItemStacks.getModOreIngot((ModOreList)ModOreList.MAGNETITE)});
    }

    private static void addItems() {
        GameRegistry.addRecipe((ItemStack)ReactorItems.DEPLETED.getCraftedProduct(2), (Object[])new Object[]{"dd", "dd", Character.valueOf('d'), ReactorStacks.depdust.func_77946_l()});
        GameRegistry.addRecipe((ItemStack)ReactorItems.FUEL.getCraftedProduct(2), (Object[])new Object[]{"dd", "dd", Character.valueOf('d'), ReactorStacks.fueldust.func_77946_l()});
        ShapedRecipes sr = ReikaRecipeHelper.getShapedRecipeFor((ItemStack)ReactorItems.PELLET.getCraftedProduct(4), (Object[])new Object[]{" G ", "GUG", " G ", Character.valueOf('G'), CraftingItems.GRAPHITE.getItem(), Character.valueOf('U'), CraftingItems.UDUST.getItem()});
        RecipesBlastFurnace.getRecipes().addRecipe(ReactorItems.PELLET.getCraftedProduct(4), 750, (IRecipe)sr, 1, 1.0f);
        GameRegistry.addRecipe((ItemStack)ReactorItems.BREEDERFUEL.getCraftedProduct(4), (Object[])new Object[]{" D ", "DED", " D ", Character.valueOf('D'), ReactorItems.DEPLETED.getStackOf(), Character.valueOf('E'), ReactorItems.FUEL.getStackOf()});
        GameRegistry.addRecipe((ItemStack)ReactorItems.CANISTER.getCraftedProduct(16), (Object[])new Object[]{" i ", "igi", " i ", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('i'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)ReactorItems.REMOTE.getStackOf(), (Object[])new Object[]{"SES", "BCB", "BPB", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('B'), Blocks.field_150430_aB, Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('C'), ItemStacks.pcb});
        GameRegistry.addRecipe((ItemStack)ReactorItems.BOOK.getStackOf(), (Object[])new Object[]{"RSR", "PPP", "PPP", Character.valueOf('R'), ReactorItems.FLUORITE.getItemInstance(), Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), Items.field_151121_aF});
        GameRegistry.addRecipe((ItemStack)ReactorItems.HAZHELMET.getStackOf(), (Object[])new Object[]{"FFF", "F F", Character.valueOf('F'), CraftingItems.FABRIC.getItem()});
        GameRegistry.addRecipe((ItemStack)ReactorItems.HAZCHEST.getStackOf(), (Object[])new Object[]{"F F", "FFF", "FFF", Character.valueOf('F'), CraftingItems.FABRIC.getItem()});
        GameRegistry.addRecipe((ItemStack)ReactorItems.HAZLEGS.getStackOf(), (Object[])new Object[]{"FFF", "F F", "F F", Character.valueOf('F'), CraftingItems.FABRIC.getItem()});
        GameRegistry.addRecipe((ItemStack)ReactorItems.HAZBOOTS.getStackOf(), (Object[])new Object[]{"F F", "F F", Character.valueOf('F'), CraftingItems.FABRIC.getItem()});
        GameRegistry.addRecipe((ItemStack)ReactorItems.GEIGER.getStackOf(), (Object[])new Object[]{" r ", "sSs", "sgs", Character.valueOf('g'), ItemStacks.steelgear, Character.valueOf('s'), ItemStacks.steelingot, Character.valueOf('S'), ItemStacks.screen, Character.valueOf('r'), ItemStacks.radar});
        GameRegistry.addRecipe((ItemStack)ReactorItems.CLEANUP.getStackOf(), (Object[])new Object[]{" sp", "sbs", "ss ", Character.valueOf('b'), Items.field_151131_as, Character.valueOf('s'), ItemStacks.steelingot, Character.valueOf('p'), ItemStacks.pipe});
        GameRegistry.addRecipe((ItemStack)ReactorItems.IRONFINDER.getStackOf(), (Object[])new Object[]{"L L", "S S", "SSS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('L'), ReactorStacks.lodestone});
        ItemRegistry.UPGRADE.addMetaBlastRecipe(1980, 32, ItemEngineUpgrade.Upgrades.EFFICIENCY.ordinal(), new Object[]{"IGI", "FTF", "BPB", Character.valueOf('G'), ItemStacks.generator, Character.valueOf('I'), ItemStacks.redgoldingot, Character.valueOf('B'), ItemStacks.waterplate, Character.valueOf('P'), ItemStacks.power, Character.valueOf('F'), CraftingItems.FERROINGOT.getItem(), Character.valueOf('T'), ItemStacks.tungsteningot});
    }

    private static void addMachines() {
        ReactorTiles.FUEL.addCrafting("SHS", "PCP", "SCS", Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('C'), CraftingItems.CANISTER.getItem(), Character.valueOf('H'), Blocks.field_150438_bZ);
        ReactorTiles.CONTROL.addCrafting("SGS", "RRR", "PPP", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('R'), CraftingItems.ROD.getItem(), Character.valueOf('G'), ItemStacks.gearunit);
        ReactorTiles.COOLANT.addCrafting("SPS", "GRG", "SPS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), ItemStacks.pipe, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('R'), MachineRegistry.RESERVOIR.getCraftedProduct());
        ReactorTiles.TURBINECORE.addCrafting("BBB", "BCB", "BBB", Character.valueOf('B'), ItemStacks.prop, Character.valueOf('C'), CraftingItems.TURBCORE.getItem());
        ReactorTiles.STEAMLINE.addSizedCrafting(3, "NPN", "NPN", "NPN", Character.valueOf('N'), Blocks.field_150325_L, Character.valueOf('P'), ItemStacks.pipe);
        ReactorTiles.FLUIDEXTRACTOR.addCrafting("PpP", "GIG", "PSP", Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('p'), ItemStacks.pipe, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('I'), ItemStacks.impeller, Character.valueOf('S'), ItemStacks.shaftitem);
        ReactorTiles.CENTRIFUGE.addCrafting("SPS", "B B", "PGP", Character.valueOf('B'), ItemStacks.bedingot, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('G'), ItemStacks.gearunit16);
        ReactorTiles.PROCESSOR.addCrafting("POP", "OMO", Character.valueOf('O'), CraftingItems.TANK.getItem(), Character.valueOf('M'), ItemStacks.mixer, Character.valueOf('P'), ItemStacks.pipe);
        ReactorTiles.WASTECONTAINER.addCrafting("SCS", "CcC", "SCS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('C'), MachineRegistry.COOLINGFIN.getCraftedProduct(), Character.valueOf('c'), Blocks.field_150486_ae);
        ReactorTiles.BOILER.addCrafting("SPS", "PrP", "SPS", Character.valueOf('r'), MachineRegistry.RESERVOIR.getCraftedProduct(), Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot);
        ReactorTiles.CONDENSER.addCrafting("SPS", "pRp", "FFF", Character.valueOf('F'), MachineRegistry.COOLINGFIN.getCraftedProduct(), Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('p'), ItemStacks.pipe, Character.valueOf('R'), MachineRegistry.RESERVOIR.getCraftedProduct());
        ReactorTiles.GRATE.addCrafting("SIS", "p p", "SPS", Character.valueOf('p'), ItemStacks.basepanel, Character.valueOf('P'), ItemStacks.pipe, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('I'), Blocks.field_150411_aY);
        ReactorTiles.PUMP.addCrafting("PpP", "gCg", "PsP", Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('g'), Blocks.field_150410_aZ, Character.valueOf('p'), ItemStacks.pipe, Character.valueOf('C'), ItemStacks.compressor, Character.valueOf('s'), ItemStacks.shaftitem);
        ReactorTiles.SYNTHESIZER.addCrafting("SpS", "pMp", "ShS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('M'), ItemStacks.mixer, Character.valueOf('p'), ItemStacks.basepanel, Character.valueOf('h'), ItemStacks.igniter);
        ReactorTiles.SODIUMBOILER.addCrafting(" i ", "ibi", " i ", Character.valueOf('b'), ReactorTiles.BOILER.getCraftedProduct(), Character.valueOf('i'), Items.field_151042_j);
        ReactorTiles.BREEDER.addCrafting("SPS", "PCP", "SPS", Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('C'), ReactorTiles.FUEL.getCraftedProduct());
        ReactorTiles.TRITIZER.addCrafting("SPS", "GPG", "SPS", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('P'), ItemStacks.pipe, Character.valueOf('S'), ItemStacks.steelingot);
        ReactorTiles.GASPIPE.addSizedCrafting(DifficultyEffects.PIPECRAFT.getInt(), "CGC", "CGC", "CGC", Character.valueOf('C'), Blocks.field_150405_ch, Character.valueOf('G'), Blocks.field_150359_w);
        ReactorTiles.ELECTROLYZER.addCrafting("SPS", "PRP", "BPB", Character.valueOf('P'), ItemStacks.pipe, Character.valueOf('B'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('R'), MachineRegistry.RESERVOIR.getCraftedProduct());
        ReactorTiles.EXCHANGER.addCrafting("FPF", "GIG", "FPF", Character.valueOf('P'), ItemStacks.pipe, Character.valueOf('I'), ItemStacks.impeller, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('F'), MachineRegistry.COOLINGFIN.getCraftedProduct());
        ReactorTiles.STORAGE.addCrafting("SPS", "PCP", "SPS", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('C'), Blocks.field_150486_ae);
        ReactorTiles.CPU.addCrafting("SCS", "CGC", "SCS", Character.valueOf('S'), ItemStacks.basepanel, Character.valueOf('C'), ItemStacks.pcb, Character.valueOf('G'), ItemStacks.gearunit);
        ReactorTiles.MAGNETPIPE.addSizedCrafting(DifficultyEffects.PIPECRAFT.getInt(), "CGC", "CGC", "CGC", Character.valueOf('C'), Items.field_151043_k, Character.valueOf('G'), BlockRegistry.BLASTGLASS.getStackOf());
        ReactorTiles.MAGNET.addCrafting("MCM", "CHC", "MCM", Character.valueOf('H'), CraftingItems.HYSTERESISRING.getItem(), Character.valueOf('M'), CraftingItems.MAGNETCORE.getItem(), Character.valueOf('C'), CraftingItems.COOLANT.getItem());
        ReactorTiles.SOLENOID.addCrafting("SPS", "MCM", "IGI", Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('M'), CraftingItems.MAGNETIC.getItem(), Character.valueOf('C'), CraftingItems.MAGNETCORE.getItem(), Character.valueOf('I'), CraftingItems.FERROINGOT.getItem(), Character.valueOf('G'), ItemStacks.gearunit16);
        ReactorTiles.HEATER.addCrafting("MPM", "P P", "MPM", Character.valueOf('M'), CraftingItems.FERROINGOT.getItem(), Character.valueOf('P'), BlockRegistry.BLASTGLASS.getStackOf());
        ReactorTiles.INJECTOR.addCrafting("PMP", "M M", "PMP", Character.valueOf('P'), ReactorTiles.MAGNETPIPE.getCraftedProduct(), Character.valueOf('M'), CraftingItems.MAGNETIC.getItem());
        ReactorTiles.ABSORBER.addCrafting(" P ", "PCP", " P ", Character.valueOf('C'), ItemStacks.steelblock, Character.valueOf('P'), ReactorItems.DEPLETED.getStackOf());
        ReactorTiles.ABSORBER.addCrafting("PPP", "PCP", "PPP", Character.valueOf('C'), ItemStacks.steelblock, Character.valueOf('P'), ReactorItems.OLDPELLET.getStackOf());
        ReactorTiles.CO2HEATER.addCrafting(" i ", "ibi", " i ", Character.valueOf('b'), ReactorTiles.BOILER.getCraftedProduct(), Character.valueOf('i'), ItemStacks.basepanel);
        ReactorTiles.PEBBLEBED.addCrafting("SHS", "PCP", "SHS", Character.valueOf('H'), Blocks.field_150438_bZ, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('C'), ReactorTiles.FUEL.getCraftedProduct());
        ReactorTiles.COLLECTOR.addCrafting(" p ", "SpS", "PpP", Character.valueOf('p'), ItemStacks.pipe, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot);
        ReactorTiles.REFLECTOR.addCrafting("GGG", "GSG", "GGG", Character.valueOf('G'), CraftingItems.GRAPHITE.getItem(), Character.valueOf('S'), ItemStacks.steelblock);
        if (PowerTypes.RF.isLoaded() || PowerTypes.EU.isLoaded()) {
            ReactorTiles.GENERATOR.addCrafting("RGR", "GFG", "RGR", Character.valueOf('G'), CraftingItems.WIRE.getItem(), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('F'), CraftingItems.MAGNETCORE.getItem());
        }
        ReactorTiles.MARKER.addCrafting("F", "R", Character.valueOf('F'), FluoriteTypes.BLUE.getItem(), Character.valueOf('R'), Blocks.field_150429_aA);
        ReactorTiles.TURBINEMETER.addCrafting("SrS", "PGP", "PCP", Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('C'), ItemStacks.pcb, Character.valueOf('G'), Blocks.field_150426_aN, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('S'), ItemStacks.steelingot);
        ReactorTiles.BIGTURBINE.addCrafting("BBB", "BCB", "BBB", Character.valueOf('B'), ItemStacks.prop, Character.valueOf('C'), ReactorTiles.TURBINECORE.getCraftedProduct());
        ReactorTiles.FLYWHEEL.addCrafting("BBB", "SSS", "BBB", Character.valueOf('B'), ItemStacks.steelblock, Character.valueOf('S'), ItemStacks.shaftitem);
        ReactorTiles.DIFFUSER.addCrafting("BBB", "DPD", "BBB", Character.valueOf('B'), ItemStacks.basepanel, Character.valueOf('D'), ItemStacks.diffuser, Character.valueOf('P'), ItemStacks.pipe);
        ReactorTiles.THORIUM.addCrafting("aSa", "PCP", "tPt", Character.valueOf('t'), ItemStacks.tungsteningot, Character.valueOf('a'), ItemStacks.silumin, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('S'), ItemStacks.steelingot, Character.valueOf('C'), ReactorTiles.FUEL.getCraftedProduct());
        ReactorTiles.FUELDUMP.addCrafting("pIp", "BPB", "pbp", Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('p'), ItemStacks.pipe, Character.valueOf('P'), ItemStacks.bedpipe, Character.valueOf('B'), ItemStacks.basepanel, Character.valueOf('I'), ItemStacks.impeller);
        ReactorTiles.WASTEPIPE.addSizedCrafting(DifficultyEffects.PIPECRAFT.getInt(), "CbC", "CGC", "CbC", Character.valueOf('C'), MatBlocks.CONCRETE.getStackOf(), Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('G'), Blocks.field_150359_w);
        ReactorTiles.SOLARTOP.addCrafting("aPa", "tct", "sPs", Character.valueOf('a'), CraftingItems.ALLOY.getItem(), Character.valueOf('t'), ItemStacks.tungsteningot, Character.valueOf('c'), ItemStacks.condenser, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('s'), ItemStacks.steelingot);
        ReactorTiles.SOLAR.addCrafting("sPs", "pEp", "sPs", Character.valueOf('p'), ItemStacks.pipe, Character.valueOf('E'), ReactorTiles.EXCHANGER.getCraftedProduct(), Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('s'), ItemStacks.steelingot);
        ReactorTiles.HEATPIPE.addSizedCrafting(6, " NP", "NPN", "PN ", Character.valueOf('N'), Blocks.field_150325_L, Character.valueOf('P'), Items.field_151043_k);
        if (ReikaItemHelper.oreItemExists((String)"ingotCopper")) {
            ReactorTiles.HEATPIPE.addSizedOreCrafting(3, " NP", "NPN", "PN ", Character.valueOf('N'), Blocks.field_150325_L, Character.valueOf('P'), "ingotCopper");
        }
    }
}

