/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.NEI;

import Reika.ReactorCraft.NEI.CentrifugeHandler;
import Reika.ReactorCraft.NEI.ElectrolyzerHandler;
import Reika.ReactorCraft.NEI.NH3Handler;
import Reika.ReactorCraft.NEI.UProcessorHandler;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class NEI_ReactorConfig
implements IConfigureNEI {
    private static final NH3Handler ammonia = new NH3Handler();
    private static final UProcessorHandler UProcessor = new UProcessorHandler();
    private static final CentrifugeHandler centrifuge = new CentrifugeHandler();
    private static final ElectrolyzerHandler electrolyzer = new ElectrolyzerHandler();

    public void loadConfig() {
        ReactorCraft.logger.log((Object)"Loading NEI Compatibility!");
        API.registerRecipeHandler((ICraftingHandler)ammonia);
        API.registerUsageHandler((IUsageHandler)ammonia);
        API.registerRecipeHandler((ICraftingHandler)UProcessor);
        API.registerUsageHandler((IUsageHandler)UProcessor);
        API.registerRecipeHandler((ICraftingHandler)centrifuge);
        API.registerUsageHandler((IUsageHandler)centrifuge);
        API.registerRecipeHandler((ICraftingHandler)electrolyzer);
        API.registerUsageHandler((IUsageHandler)electrolyzer);
        ReactorCraft.logger.log((Object)"Hiding technical blocks from NEI!");
        this.hideBlock(ReactorBlocks.REACTOR.getBlockInstance());
        this.hideBlock(ReactorBlocks.MODELREACTOR.getBlockInstance());
        this.hideBlock(ReactorBlocks.MACHINE.getBlockInstance());
        this.hideBlock(ReactorBlocks.MODELMACHINE.getBlockInstance());
        this.hideBlock(ReactorBlocks.DUCT.getBlockInstance());
        this.hideBlock(ReactorBlocks.LINE.getBlockInstance());
        if (ReactorCraft.instance.isLocked()) {
            int i;
            for (i = 0; i < ReactorItems.itemList.length; ++i) {
                ReactorItems ir = ReactorItems.itemList[i];
                API.hideItem((ItemStack)new ItemStack(ir.getItemInstance()));
            }
            for (i = 0; i < ReactorBlocks.blockList.length; ++i) {
                ReactorBlocks b = ReactorBlocks.blockList[i];
                this.hideBlock(b.getBlockInstance());
            }
        }
    }

    private void hideBlock(Block b) {
        API.hideItem((ItemStack)new ItemStack(b, 1, Short.MAX_VALUE));
    }

    public String getName() {
        return "ReactorCraft NEI Handlers";
    }

    public String getVersion() {
        return "Gamma";
    }
}

