/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.GUIs.GuiElectrolyzer;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityElectrolyzer;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class ElectrolyzerHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Electrolyzer";
    }

    public String getGuiTexture() {
        return "/Reika/ReactorCraft/Textures/GUI/electrolyzer.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(ReactorCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 0, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(ReactorCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(59, 8, 70, 60), "recelect", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("recelect")) {
            this.arecipes.add(new ElectrolyzerRecipe(ItemStacks.salt));
            this.arecipes.add(new ElectrolyzerRecipe(FluidRegistry.getFluid((String)"rc heavy water")));
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("recelect")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void drawExtras(int recipe) {
        ElectrolyzerRecipe er = (ElectrolyzerRecipe)((Object)this.arecipes.get(recipe));
        Fluid o1 = er.heavyOut;
        Fluid o2 = er.lightOut;
        ReikaTextureHelper.bindTerrainTexture();
        ReikaGuiAPI.instance.func_94065_a(93, 7, ReikaLiquidRenderer.getFluidIconSafe((Fluid)o1), 16, 60);
        ReikaGuiAPI.instance.func_94065_a(129, 7, ReikaLiquidRenderer.getFluidIconSafe((Fluid)o2), 16, 60);
        if (er.input != null) {
            ReikaGuiAPI.instance.func_94065_a(12, 7, ReikaLiquidRenderer.getFluidIconSafe((Fluid)er.input), 16, 60);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (ReikaItemHelper.matchStacks((ItemStack)ReactorStacks.nacan, (ItemStack)result) || ReikaItemHelper.matchStacks((ItemStack)ReactorStacks.clcan, (ItemStack)result)) {
            this.arecipes.add(new ElectrolyzerRecipe(ItemStacks.salt));
        }
        if (ReikaItemHelper.matchStacks((ItemStack)ReactorStacks.h2can, (ItemStack)result) || ReikaItemHelper.matchStacks((ItemStack)ReactorStacks.ocan, (ItemStack)result)) {
            this.arecipes.add(new ElectrolyzerRecipe(FluidRegistry.getFluid((String)"rc heavy water")));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (TileEntityElectrolyzer.isSalt(ingredient)) {
            this.arecipes.add(new ElectrolyzerRecipe(ingredient));
        }
        if (ReikaItemHelper.matchStacks((ItemStack)ingredient, (ItemStack)ReactorItems.BUCKET.getStackOfMetadata(0))) {
            this.arecipes.add(new ElectrolyzerRecipe(FluidRegistry.getFluid((String)"rc heavy water")));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiElectrolyzer.class;
    }

    public class ElectrolyzerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private Fluid input;
        private ItemStack itemIn;
        private Fluid lightOut;
        private Fluid heavyOut;

        public ElectrolyzerRecipe(Fluid in) {
            super((TemplateRecipeHandler)ElectrolyzerHandler.this);
            this.input = in;
            this.heavyOut = FluidRegistry.getFluid((String)"rc oxygen");
            this.lightOut = FluidRegistry.getFluid((String)"rc deuterium");
        }

        public ElectrolyzerRecipe(ItemStack in) {
            super((TemplateRecipeHandler)ElectrolyzerHandler.this);
            this.itemIn = in;
            this.heavyOut = FluidRegistry.getFluid((String)"rc sodium");
            this.lightOut = FluidRegistry.getFluid((String)"rc chlorine");
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return this.itemIn != null ? new PositionedStack((Object)this.itemIn, 39, 30) : null;
        }
    }
}

