/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks.Multi;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.ReactorCraft.Base.BlockMultiBlock;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.TileEntityReactorGenerator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGeneratorMulti
extends BlockMultiBlock {
    public BlockGeneratorMulti(Material par2Material) {
        super(par2Material);
    }

    @Override
    public int getNumberTextures() {
        return 13;
    }

    @Override
    public boolean checkForFullMultiBlock(World world, int x, int y, int z, ForgeDirection dir) {
        if (!this.checkCore(world, x, y, z, dir)) {
            return false;
        }
        if (!this.checkWindings(world, x, y, z, dir)) {
            return false;
        }
        if (!this.checkHousing(world, x, y, z, dir)) {
            return false;
        }
        if (!this.checkEndCap(world, x, y, z, dir)) {
            return false;
        }
        int l = TileEntityReactorGenerator.getGeneratorLength() - 1;
        return ReactorTiles.getTE((IBlockAccess)world, x + dir.offsetX * l, y, z + dir.offsetZ * l) == ReactorTiles.GENERATOR;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    private boolean checkCore(World world, int x, int y, int z, ForgeDirection dir) {
        int l = TileEntityReactorGenerator.getGeneratorLength() - 1;
        for (int i = 0; i < l; ++i) {
            int dx = x + dir.offsetX * i;
            int dz = z + dir.offsetZ * i;
            Block b = world.func_147439_a(dx, y, dz);
            int meta = world.func_72805_g(dx, y, dz);
            if (b == this && meta == 0) continue;
            return false;
        }
        int dx = x + dir.offsetX * l;
        int dz = z + dir.offsetZ * l;
        TileEntity te = world.func_147438_o(dx, y, dz);
        if (te instanceof TileEntityReactorGenerator) {
            return dir == ((TileEntityReactorGenerator)te).getFacing().getOpposite();
        }
        return false;
    }

    private boolean checkWindings(World world, int x, int y, int z, ForgeDirection dir) {
        int l = TileEntityReactorGenerator.getGeneratorLength() - 1;
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        for (int i = 0; i < l; ++i) {
            int seekmeta = i < 2 ? 3 : 1;
            int dx = x + dir.offsetX * i;
            int dz = z + dir.offsetZ * i;
            int ddx = dx + left.offsetX;
            int ddx2 = dx - left.offsetX;
            int ddz = dz + left.offsetZ;
            int ddz2 = dz - left.offsetZ;
            for (int k = -1; k <= 1; ++k) {
                int dy = y + k;
                Block id = world.func_147439_a(ddx, dy, ddz);
                int meta = world.func_72805_g(ddx, dy, ddz);
                Block id2 = world.func_147439_a(ddx2, dy, ddz2);
                int meta2 = world.func_72805_g(ddx2, dy, ddz2);
                Block id3 = world.func_147439_a(dx, dy, dz);
                int meta3 = world.func_72805_g(dx, dy, dz);
                if (id != this || meta != seekmeta) {
                    return false;
                }
                if (id2 != this || meta2 != seekmeta) {
                    return false;
                }
                if (k == 0 || id3 == this && meta3 == seekmeta) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkHousing(World world, int x, int y, int z, ForgeDirection dir) {
        int l = TileEntityReactorGenerator.getGeneratorLength() - 1;
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        for (int i = 0; i < l; ++i) {
            int meta2;
            Block id2;
            int meta;
            Block id;
            int dy;
            int k;
            int dx = x + dir.offsetX * i;
            int dz = z + dir.offsetZ * i;
            int ddx = dx + left.offsetX;
            int ddx2 = dx - left.offsetX;
            int ddz = dz + left.offsetZ;
            int ddz2 = dz - left.offsetZ;
            int seekmeta = 2;
            for (k = -2; k <= 2; k += 4) {
                dy = y + k;
                id = world.func_147439_a(ddx, dy, ddz);
                meta = world.func_72805_g(ddx, dy, ddz);
                id2 = world.func_147439_a(ddx2, dy, ddz2);
                meta2 = world.func_72805_g(ddx2, dy, ddz2);
                Block id3 = world.func_147439_a(dx, dy, dz);
                int meta3 = world.func_72805_g(dx, dy, dz);
                if (i == 1 && k == 2) {
                    seekmeta = 3;
                }
                if (id != this || meta != 2) {
                    return false;
                }
                if (id2 != this || meta2 != 2) {
                    return false;
                }
                if (id3 == this && meta3 == seekmeta) continue;
                return false;
            }
            ddx = dx + left.offsetX * 2;
            ddx2 = dx - left.offsetX * 2;
            ddz = dz + left.offsetZ * 2;
            ddz2 = dz - left.offsetZ * 2;
            for (k = -1; k <= 1; ++k) {
                dy = y + k;
                id = world.func_147439_a(ddx, dy, ddz);
                meta = world.func_72805_g(ddx, dy, ddz);
                id2 = world.func_147439_a(ddx2, dy, ddz2);
                meta2 = world.func_72805_g(ddx2, dy, ddz2);
                if (id != this || meta != 2) {
                    return false;
                }
                if (id2 == this && meta2 == 2) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkEndCap(World world, int x, int y, int z, ForgeDirection dir) {
        int meta;
        Block id;
        int l = TileEntityReactorGenerator.getGeneratorLength() - 1;
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        int dx = x + dir.offsetX * l;
        int dz = z + dir.offsetZ * l;
        for (int k = -2; k <= 2; ++k) {
            int dy = y + k;
            for (int m = -2; m <= 2; ++m) {
                if (Math.abs(k) == 2 && Math.abs(m) == 2 || k == 0 && m == 0) continue;
                int ddx = dx + left.offsetX * m;
                int ddz = dz + left.offsetZ * m;
                id = world.func_147439_a(ddx, dy, ddz);
                meta = world.func_72805_g(ddx, dy, ddz);
                if (id == this && meta == 2) continue;
                return false;
            }
        }
        for (int i = 0; i < 2; ++i) {
            dx = x + dir.offsetX * i;
            dz = z + dir.offsetZ * i;
            int ddx = dx + left.offsetX * 2;
            int ddz = dz + left.offsetZ * 2;
            int ddx2 = dx - left.offsetX * 2;
            int ddz2 = dz - left.offsetZ * 2;
            id = world.func_147439_a(ddx, y + 2, ddz);
            meta = world.func_72805_g(ddx, y + 2, ddz);
            Block id2 = world.func_147439_a(ddx2, y + 2, ddz2);
            int meta2 = world.func_72805_g(ddx2, y + 2, ddz2);
            if (id != this || meta != 2) {
                return false;
            }
            if (id2 != this || meta2 != 2) {
                return false;
            }
            id = world.func_147439_a(ddx, y - 2, ddz);
            meta = world.func_72805_g(ddx, y - 2, ddz);
            id2 = world.func_147439_a(ddx2, y - 2, ddz2);
            meta2 = world.func_72805_g(ddx2, y - 2, ddz2);
            if (id != this || meta != 2) {
                return false;
            }
            if (id2 == this && meta2 == 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void breakMultiBlock(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        Set set = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ReactorTiles.GENERATOR)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, set, x - 12, y - 4, z - 12, x + 12, y + 4, z + 12);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata(world);
            if (ReactorTiles.getTE((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) == ReactorTiles.GENERATOR) {
                TileEntityReactorGenerator te = (TileEntityReactorGenerator)world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                te.setHasMultiBlock(false);
                continue;
            }
            if (meta < 8) continue;
            world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta - 8, 3);
        }
    }

    @Override
    protected void onCreateFullMultiBlock(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        Set set = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ReactorTiles.GENERATOR)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, set, x - 12, y - 4, z - 12, x + 12, y + 4, z + 12);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata(world);
            if (ReactorTiles.getTE((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) == ReactorTiles.GENERATOR) {
                TileEntityReactorGenerator te = (TileEntityReactorGenerator)world.func_147438_o(c.xCoord, c.yCoord, c.zCoord);
                te.setHasMultiBlock(true);
                continue;
            }
            if (meta >= 8) continue;
            world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta + 8, 3);
        }
    }

    @Override
    public int getNumberVariants() {
        return 4;
    }

    @Override
    protected String getIconBaseName() {
        return "generator";
    }

    @Override
    public int getTextureIndex(IBlockAccess world, int x, int y, int z, int side, int meta) {
        if (meta >= 8) {
            return 9;
        }
        if (meta == 3) {
            return 5;
        }
        if (meta == 4) {
            return 2;
        }
        return meta;
    }

    @Override
    public int getItemTextureIndex(int meta, int side) {
        if (meta < 0) {
            return 9 - meta;
        }
        if (meta >= 8) {
            return 9;
        }
        if (meta == 3) {
            return 5;
        }
        return meta;
    }

    @Override
    public boolean canTriggerMultiBlockCheck(World world, int x, int y, int z, int meta) {
        return meta == 0;
    }

    @Override
    protected TileEntity getTileEntityForPosition(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 12, y - 4, z - 12, x + 12, y + 4, z + 12);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            if (ReactorTiles.getTE((IBlockAccess)world, c.xCoord, c.yCoord + 1, c.zCoord) != ReactorTiles.GENERATOR) continue;
            TileEntityReactorGenerator te = (TileEntityReactorGenerator)world.func_147438_o(c.xCoord, c.yCoord + 1, c.zCoord);
            return te;
        }
        return null;
    }
}

