/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks.Multi;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.ReactorCraft.Base.BlockMultiBlock;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.TileEntityReactorFlywheel;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFlywheelMulti
extends BlockMultiBlock {
    public BlockFlywheelMulti(Material par2Material) {
        super(par2Material);
    }

    @Override
    public int getNumberTextures() {
        return 4;
    }

    @Override
    public boolean checkForFullMultiBlock(World world, int x, int y, int z, ForgeDirection dir) {
        int midZ;
        int midY;
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        if (blocks.getSize() != 20) {
            return false;
        }
        int midX = blocks.getMinX() + blocks.getSizeX() / 2;
        if (ReactorTiles.getTE((IBlockAccess)world, midX, midY = blocks.getMinY() + blocks.getSizeY() / 2, midZ = blocks.getMinZ() + blocks.getSizeZ() / 2) != ReactorTiles.FLYWHEEL) {
            return false;
        }
        TileEntityReactorFlywheel te = (TileEntityReactorFlywheel)world.func_147438_o(midX, midY, midZ);
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)te.getFacing());
        for (int i = 1; i <= 2; ++i) {
            int m;
            int dx = midX + left.offsetX * i;
            int dz = midZ + left.offsetZ * i;
            int n = m = i == 1 ? 0 : 2;
            if (world.func_147439_a(dx, midY, dz) != this || world.func_72805_g(dx, midY, dz) != m) {
                return false;
            }
            dx = midX - left.offsetX * i;
            dz = midZ - left.offsetZ * i;
            if (world.func_147439_a(dx, midY, dz) != this || world.func_72805_g(dx, midY, dz) != m) {
                return false;
            }
            if (world.func_147439_a(midX, midY - i, midZ) != this || world.func_72805_g(midX, midY - i, midZ) != m) {
                return false;
            }
            if (world.func_147439_a(midX, midY + i, midZ) == this && world.func_72805_g(midX, midY + i, midZ) == m) continue;
            return false;
        }
        int dx = midX + left.offsetX;
        int dz = midZ + left.offsetZ;
        if (world.func_147439_a(dx, midY + 1, dz) != this || world.func_72805_g(dx, midY + 1, dz) != 1) {
            return false;
        }
        if (world.func_147439_a(dx, midY - 1, dz) != this || world.func_72805_g(dx, midY - 1, dz) != 1) {
            return false;
        }
        dx = midX - left.offsetX;
        dz = midZ - left.offsetZ;
        if (world.func_147439_a(dx, midY + 1, dz) != this || world.func_72805_g(dx, midY + 1, dz) != 1) {
            return false;
        }
        if (world.func_147439_a(dx, midY - 1, dz) != this || world.func_72805_g(dx, midY - 1, dz) != 1) {
            return false;
        }
        dx = midX + left.offsetX;
        dz = midZ + left.offsetZ;
        if (world.func_147439_a(dx, midY + 2, dz) != this || world.func_72805_g(dx, midY + 2, dz) != 2) {
            return false;
        }
        if (world.func_147439_a(dx, midY - 2, dz) != this || world.func_72805_g(dx, midY - 2, dz) != 2) {
            return false;
        }
        dx = midX - left.offsetX;
        dz = midZ - left.offsetZ;
        if (world.func_147439_a(dx, midY + 2, dz) != this || world.func_72805_g(dx, midY + 2, dz) != 2) {
            return false;
        }
        if (world.func_147439_a(dx, midY - 2, dz) != this || world.func_72805_g(dx, midY - 2, dz) != 2) {
            return false;
        }
        dx = midX + left.offsetX * 2;
        dz = midZ + left.offsetZ * 2;
        if (world.func_147439_a(dx, midY + 1, dz) != this || world.func_72805_g(dx, midY + 1, dz) != 2) {
            return false;
        }
        if (world.func_147439_a(dx, midY - 1, dz) != this || world.func_72805_g(dx, midY - 1, dz) != 2) {
            return false;
        }
        dx = midX - left.offsetX * 2;
        dz = midZ - left.offsetZ * 2;
        if (world.func_147439_a(dx, midY + 1, dz) != this || world.func_72805_g(dx, midY + 1, dz) != 2) {
            return false;
        }
        return world.func_147439_a(dx, midY - 1, dz) == this && world.func_72805_g(dx, midY - 1, dz) == 2;
    }

    @Override
    public void breakMultiBlock(World world, int x, int y, int z) {
        int midZ;
        int midY;
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x + 1, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x - 1, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y + 1, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y - 1, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y, z + 1, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y, z - 1, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata(world);
            if (meta < 8) continue;
            world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta - 8, 3);
        }
        int midX = blocks.getMidX();
        if (ReactorTiles.getTE((IBlockAccess)world, midX, midY = blocks.getMidY(), midZ = blocks.getMidZ()) == ReactorTiles.FLYWHEEL) {
            TileEntityReactorFlywheel te = (TileEntityReactorFlywheel)world.func_147438_o(midX, midY, midZ);
            te.setHasMultiBlock(false);
        }
    }

    @Override
    protected void onCreateFullMultiBlock(World world, int x, int y, int z) {
        int midZ;
        int midY;
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata(world);
            if (meta >= 8) continue;
            world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta + 8, 3);
        }
        int midX = blocks.getMidX();
        if (ReactorTiles.getTE((IBlockAccess)world, midX, midY = blocks.getMidY(), midZ = blocks.getMidZ()) == ReactorTiles.FLYWHEEL) {
            TileEntityReactorFlywheel te = (TileEntityReactorFlywheel)world.func_147438_o(midX, midY, midZ);
            te.setHasMultiBlock(true);
        }
    }

    @Override
    public int getNumberVariants() {
        return 3;
    }

    @Override
    protected String getIconBaseName() {
        return "flywheel";
    }

    @Override
    public int getTextureIndex(IBlockAccess world, int x, int y, int z, int side, int meta) {
        return meta >= 8 ? 3 : meta;
    }

    @Override
    public int getItemTextureIndex(int meta, int side) {
        return meta & 7;
    }

    @Override
    public boolean canTriggerMultiBlockCheck(World world, int x, int y, int z, int meta) {
        return true;
    }

    @Override
    protected TileEntity getTileEntityForPosition(World world, int x, int y, int z) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBoundsRanged((IBlockAccess)world, x, y, z, (Block)this, x - 6, y - 6, z - 6, x + 6, y + 6, z + 6, 1);
        int midX = blocks.getMinX() + blocks.getSizeX() / 2;
        int midY = blocks.getMinY() + blocks.getSizeY() / 2;
        int midZ = blocks.getMinZ() + blocks.getSizeZ() / 2;
        if (ReactorTiles.getTE((IBlockAccess)world, midX, midY, midZ) != ReactorTiles.FLYWHEEL) {
            return null;
        }
        return world.func_147438_o(midX, midY, midZ);
    }
}

