/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.Feedable;
import Reika.ReactorCraft.Auxiliary.HydrogenExplosion;
import Reika.ReactorCraft.Auxiliary.LinkableReactorCore;
import Reika.ReactorCraft.Auxiliary.RadiationEffects;
import Reika.ReactorCraft.Auxiliary.WasteManager;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Event.ReactorMeltdownEvent;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorOptions;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityCPU;
import Reika.RotaryCraft.API.Interfaces.EMPControl;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityNuclearCore
extends TileEntityInventoriedReactorBase
implements LinkableReactorCore,
Feedable,
ChunkLoadingTile,
EMPControl {
    protected int hydrogen = 0;
    private int activeTimer = 0;
    private static final int MAX_HYDROGEN = 200;
    public static final int CLADDING = 800;
    public static final int HYDROGEN = 1400;
    public static final int MELTDOWN = 1800;
    private Coordinate CPU;

    @Override
    public void link(TileEntityCPU te) {
        this.CPU = new Coordinate((TileEntity)te);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K && this.isFissile() && rand.nextInt(20) == 0) {
            world.func_72838_d((Entity)new EntityNeutron(world, x, y, z, this.getRandomDirection(), EntityNeutron.NeutronType.DECAY));
        }
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.clearInventory((IInventory)this);
            ReikaInventoryHelper.addToIInv((ItemStack)ReactorItems.FUEL.getStackOf(), (IInventory)this);
        }
        if (!world.field_72995_K) {
            this.feedWaste(world, x, y, z);
            this.feed();
        }
        if (this.activeTimer > 0) {
            --this.activeTimer;
            if (this.activeTimer == 0) {
                this.onActivityChange(false);
            }
        }
        this.thermalTicker.update();
        if (this.thermalTicker.checkCap()) {
            this.updateTemperature(world, x, y, z);
        }
        if (this.temperature > 800) {
            if (rand.nextInt(20) == 0) {
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
            }
            ReikaParticleHelper.SMOKE.spawnAroundBlockWithOutset(world, x, y, z, 9, 0.0625);
        } else if (this.temperature > this.getWarningTemperature() && ReikaRandomHelper.doWithChance((double)20.0)) {
            if (rand.nextInt(20) == 0) {
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
            }
            ReikaParticleHelper.SMOKE.spawnAroundBlockWithOutset(world, x, y, z, 4, 0.0625);
        }
    }

    protected int getWarningTemperature() {
        return 500;
    }

    private void onActivityChange(boolean active) {
        if (!this.field_145850_b.field_72995_K && ReactorOptions.CHUNKLOADING.getState()) {
            if (active) {
                ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
            } else {
                this.unload();
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void unload() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)1);
    }

    private void feedWaste(World world, int x, int y, int z) {
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (te instanceof TileEntityNuclearCore) {
            for (int i = 4; i < 12; ++i) {
                if (this.inv[i] == null) continue;
                for (int k = 4; k < 12; ++k) {
                    if (((TileEntityNuclearCore)te).inv[k] != null) continue;
                    ((TileEntityNuclearCore)te).inv[k] = this.inv[i];
                    this.inv[i] = null;
                }
            }
        }
    }

    @Override
    public final int func_70297_j_() {
        return 1;
    }

    public final int func_70302_i_() {
        return 12;
    }

    @Override
    public final int getTemperature() {
        return this.temperature;
    }

    @Override
    public final void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public boolean feed() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block id = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        TileEntity tile = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (tile instanceof Feedable && ((Feedable)tile).feedIn(this.inv[3])) {
            this.inv[3] = this.inv[2];
            this.inv[2] = this.inv[1];
            this.inv[1] = this.inv[0];
            id = world.func_147439_a(x, y + 1, z);
            meta = world.func_72805_g(x, y + 1, z);
            tile = this.getAdjacentTileEntity(ForgeDirection.UP);
            this.inv[0] = tile instanceof Feedable ? ((Feedable)tile).feedOut() : null;
        }
        this.collapseInventory();
        return false;
    }

    private void collapseInventory() {
        for (int i = 0; i < 4; ++i) {
            for (int k = 3; k > 0; --k) {
                if (this.inv[k] != null) continue;
                this.inv[k] = this.inv[k - 1];
                this.inv[k - 1] = null;
            }
        }
    }

    @Override
    public boolean feedIn(ItemStack is) {
        if (is == null) {
            return true;
        }
        if (!this.func_94041_b(0, is)) {
            return false;
        }
        if (this.inv[0] == null) {
            this.inv[0] = is.func_77946_l();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack feedOut() {
        if (this.inv[3] == null) {
            return null;
        }
        ItemStack is = this.inv[3].func_77946_l();
        this.inv[3] = null;
        return is;
    }

    protected final void tryPushSpentFuel(int slot) {
        for (int i = 4; i < 12; ++i) {
            if (this.inv[i] != null) continue;
            this.inv[i] = this.inv[slot];
            this.inv[slot] = null;
            return;
        }
    }

    public abstract boolean isFissile();

    @Override
    public final boolean canEnterFromSide(ForgeDirection dir) {
        return dir == ForgeDirection.UP;
    }

    @Override
    public final boolean canExitToSide(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    protected boolean checkPoisonedChance() {
        int count = 0;
        for (int i = 4; i < 12; ++i) {
            ItemStack is = this.inv[i];
            if (is == null || is.func_77973_b() != ReactorItems.WASTE.getItemInstance()) continue;
            ++count;
        }
        return rand.nextInt(9 - count) == 0;
    }

    protected void addWaste() {
        boolean flag = false;
        ItemStack waste = WasteManager.getRandomWasteItem();
        for (int i = 4; i < 12 && !flag; ++i) {
            ItemStack inslot = this.inv[i];
            if (inslot == null) {
                this.inv[i] = waste;
                flag = true;
                continue;
            }
            if (!ItemStack.func_77970_a((ItemStack)waste, (ItemStack)inslot) || !waste.func_77969_a(inslot) || this.inv[i].field_77994_a + waste.field_77994_a > waste.func_77976_d()) continue;
            this.inv[i].field_77994_a += waste.field_77994_a;
            flag = true;
        }
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        boolean inactive = this.activeTimer <= 0;
        this.activeTimer = 2400;
        if (inactive) {
            this.onActivityChange(true);
        }
        return false;
    }

    public final boolean isActive() {
        return this.activeTimer > 0;
    }

    protected final void spawnNeutronBurst(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            world.func_72838_d((Entity)new EntityNeutron(world, x, y, z, this.getRandomDirection(), this.getNeutronType()));
        }
    }

    protected final EntityNeutron.NeutronType getNeutronType() {
        switch (this.getMachine().getReactorType()) {
            case BREEDER: {
                return EntityNeutron.NeutronType.BREEDER;
            }
            case FISSION: {
                return EntityNeutron.NeutronType.FISSION;
            }
            case FUSION: {
                return EntityNeutron.NeutronType.FUSION;
            }
            case THORIUM: {
                return EntityNeutron.NeutronType.THORIUM;
            }
        }
        return null;
    }

    @Override
    public int getMaxTemperature() {
        return 1800;
    }

    protected void onMeltdown(World world, int x, int y, int z) {
        MinecraftForge.EVENT_BUS.post((Event)new ReactorMeltdownEvent(world, x, y, z));
        if (world.field_72995_K) {
            return;
        }
        int r = 2;
        for (int i = x - r; i <= x + r; ++i) {
            for (int j = y - r; j <= y + r; ++j) {
                for (int k = z - r; k <= z + r; ++k) {
                    ReactorTiles other;
                    ReactorTiles src = ReactorTiles.TEList[this.getIndex()];
                    if (src != (other = ReactorTiles.getTE((IBlockAccess)world, i, j, k))) continue;
                    world.func_147449_b(i, j, k, ReactorBlocks.CORIUMFLOWING.getBlockInstance());
                }
            }
        }
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 8.0f, false);
        double scatter = RadiationEffects.instance.contaminateArea(world, x, y, z, 32, 8.0f, 2.0, true, RadiationEffects.RadiationIntensity.LETHAL);
        this.testAndDoHydrogenExplosion(world, x, y, z, scatter);
    }

    private void testAndDoHydrogenExplosion(World world, int x, int y, int z, double scatter) {
        HydrogenExplosion ex = new HydrogenExplosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 7.0f);
        ex.func_77278_a();
        ex.func_77279_a(false);
    }

    @Override
    protected void updateTemperature(World world, int x, int y, int z) {
        super.updateTemperature(world, x, y, z);
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = this.temperature - Tamb;
        if (dT != 0) {
            int d = ReikaWorldHelper.isExposedToAir((World)world, (int)x, (int)y, (int)z) ? 32 : 64;
            this.temperature -= 1 + dT / d;
        }
        if (dT > 0) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                Block id = world.func_147439_a(dx, dy, dz);
                int meta = world.func_72805_g(dx, dy, dz);
                if (id != this.getTileEntityBlockID() || meta != ReactorTiles.TEList[this.getIndex()].getBlockMetadata()) continue;
                TileEntityNuclearCore te = (TileEntityNuclearCore)world.func_147438_o(dx, dy, dz);
                int dTemp = this.temperature - te.temperature;
                if (dTemp <= 0) continue;
                this.temperature -= dTemp / 16;
                te.temperature += dTemp / 16;
            }
        }
        if (this.temperature >= 500) {
            ReactorAchievements.HOTCORE.triggerAchievement(this.getPlacer());
        }
        if (this.temperature > 1800) {
            this.onMeltdown(world, x, y, z);
            ReactorAchievements.MELTDOWN.triggerAchievement(this.getPlacer());
        }
        if (this.temperature > 1400) {
            ++this.hydrogen;
            if (this.hydrogen > 200) {
                this.testAndDoHydrogenExplosion(world, x, y, z, 1.0);
            }
        } else if (this.hydrogen > 0) {
            --this.hydrogen;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.activeTimer = NBT.func_74762_e("activetick");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("activetick", this.activeTimer);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hydrogen = NBT.func_74762_e("h2");
        this.CPU = Coordinate.readFromNBT((String)"cpu", (NBTTagCompound)NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("h2", this.hydrogen);
        if (this.CPU != null) {
            this.CPU.writeToNBT("cpu", NBT);
        }
    }

    public final void breakBlock() {
        TileEntity te;
        if (!this.field_145850_b.field_72995_K) {
            this.unload();
        }
        if (this.CPU != null && (te = this.CPU.getTileEntity(this.field_145850_b)) instanceof TileEntityCPU) {
            ((TileEntityCPU)te).removeTemperatureCheck(this);
        }
    }

    protected final void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        if (!world.field_72995_K && invalid) {
            this.unload();
        }
    }

    @Override
    public final int getTextureState(ForgeDirection side) {
        if (side.offsetY != 0) {
            return 4;
        }
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles src = this.getMachine();
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z);
        ReactorTiles r2 = ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z);
        if (r2 == src && r == src) {
            return 2;
        }
        if (r2 == src) {
            return 1;
        }
        if (r == src) {
            return 3;
        }
        return 0;
    }

    public final void onHitWithEMP(TileEntity te) {
        this.temperature += 500;
    }
}

