/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeRenderConnector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityLine
extends TileEntityReactorBase {
    private boolean[] connections = new boolean[6];

    protected final void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    public final boolean isConnectedOnSideAt(World world, int x, int y, int z, ForgeDirection dir) {
        dir = dir.offsetX == 0 ? dir.getOpposite() : dir;
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block id = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (ReactorTiles.getMachineFromIDandMetadata(id, meta) == this.getMachine()) {
            return true;
        }
        TileEntity te = world.func_147438_o(dx, dy, dz);
        if (te instanceof WorldRift) {
            return true;
        }
        return this.canConnectToMachine(id, meta, dir, te);
    }

    protected boolean canConnectToMachine(Block id, int meta, ForgeDirection dir, TileEntity te) {
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = NBT.func_74767_n("conn" + i);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < 6; ++i) {
            NBT.func_74757_a("conn" + i, this.connections[i]);
        }
    }

    public final boolean isConnectionValidForSide(ForgeDirection dir) {
        if (dir.offsetX == 0 && MinecraftForgeClient.getRenderPass() != 1) {
            dir = dir.getOpposite();
        }
        return this.connections[dir.ordinal()];
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public final void recomputeConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            this.connections[i] = this.isConnected(this.dirs[i]);
            world.func_147479_m(x + this.dirs[i].offsetX, y + this.dirs[i].offsetY, z + this.dirs[i].offsetZ);
        }
        world.func_147479_m(x, y, z);
    }

    public final void deleteFromAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntityLine te = (TileEntityLine)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = false;
            world.func_147479_m(dx, dy, dz);
        }
    }

    public final void addToAdjacentConnections(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = x + dir.offsetY;
            int dz = x + dir.offsetZ;
            ReactorTiles m = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (m != this.getMachine()) continue;
            TileEntityLine te = (TileEntityLine)world.func_147438_o(dx, dy, dz);
            te.connections[dir.getOpposite().ordinal()] = true;
            world.func_147479_m(dx, dy, dz);
        }
    }

    private final boolean isConnected(ForgeDirection dir) {
        ReactorTiles m2;
        int x = this.field_145851_c + dir.offsetX;
        int y = this.field_145848_d + dir.offsetY;
        int z = this.field_145849_e + dir.offsetZ;
        ReactorTiles m = this.getMachine();
        if (m == (m2 = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, x, y, z))) {
            return true;
        }
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof PipeRenderConnector) {
            return ((PipeRenderConnector)te).canConnectToPipeOnSide(dir);
        }
        return te instanceof WorldRift;
    }

    public final int getPacketDelay() {
        return 4 * super.getPacketDelay();
    }

    public abstract IIcon getTexture();

    public void onEntityCollided(Entity e) {
    }
}

