/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineGun
extends InventoriedPowerReceiver
implements RangedEffect,
EnchantableMachine,
DiscreteFunction {
    private HashMap<Enchantment, Integer> enchantments = new HashMap();

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if (DragonAPICore.debugtest) {
            ReikaInventoryHelper.addToIInv((Item)Items.field_151032_g, (IInventory)this);
        }
        if (this.tickcount >= this.getOperationTime() && ReikaInventoryHelper.checkForItem((Item)Items.field_151032_g, (ItemStack[])this.inv)) {
            AxisAlignedBB box = this.drawAABB(world, x, y, z, meta);
            List li = world.func_72872_a(EntityLivingBase.class, box);
            if (li.size() > 0 && !ReikaEntityHelper.allAreDead((List)li, (boolean)false) && !this.isReikaOnly(li)) {
                this.fire(world, x, y, z, meta);
            }
            this.tickcount = 0;
        }
    }

    private boolean isReikaOnly(List<EntityLivingBase> li) {
        if (li.size() != 1) {
            return false;
        }
        EntityLivingBase e = li.get(0);
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        if (ReikaPlayerAPI.isReika((EntityPlayer)((EntityPlayer)e))) {
            return !((EntityPlayer)e).field_71075_bZ.field_75098_d;
        }
        return false;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private int getArrowSlot() {
        return ReikaInventoryHelper.locateIDInInventory((Item)Items.field_151032_g, (IInventory)this);
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return is.func_77973_b() == Items.field_151032_g;
    }

    public int func_70302_i_() {
        return 27;
    }

    private double getFirePower() {
        return (double)this.getEnchantment(Enchantment.field_77345_t) * 0.5 + ReikaMathLibrary.logbase((long)(this.torque + 1), (int)2);
    }

    @Override
    public int getOperationTime() {
        return ReikaMathLibrary.extrema((int)(16 - (int)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2)), (int)4, (String)"max");
    }

    private void fire(World world, int x, int y, int z, int meta) {
        double vx = 0.0;
        double vz = 0.0;
        double v = this.getFirePower();
        switch (meta) {
            case 1: {
                ++x;
                vx = v;
                break;
            }
            case 0: {
                --x;
                vx = -v;
                break;
            }
            case 2: {
                ++z;
                vz = v;
                break;
            }
            case 3: {
                --z;
                vz = -v;
            }
        }
        EntityArrow ar = new EntityArrow(world);
        ar.func_70012_b((double)x + 0.5, (double)y + 0.8, (double)z + 0.5, 0.0f, 0.0f);
        ar.field_70159_w = vx;
        ar.field_70179_y = vz;
        if (!world.field_72995_K) {
            ar.field_70133_I = true;
            world.func_72838_d((Entity)ar);
        }
        if (!this.hasEnchantment(Enchantment.field_77342_w)) {
            ReikaInventoryHelper.decrStack((int)this.getArrowSlot(), (ItemStack[])this.inv);
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.bow", (float)1.0f, (float)1.0f);
    }

    private AxisAlignedBB drawAABB(World world, int x, int y, int z, int meta) {
        double d = 0.1;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72331_e(d, d, d);
        int r = this.getRange();
        switch (meta) {
            case 1: {
                box.func_72317_d(1.0, 0.0, 0.0);
                box.field_72336_d += (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.EAST, (int)r), r);
                break;
            }
            case 0: {
                box.func_72317_d(-1.0, 0.0, 0.0);
                box.field_72340_a -= (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.WEST, (int)r), r);
                break;
            }
            case 2: {
                box.func_72317_d(0.0, 0.0, 1.0);
                box.field_72334_f += (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.SOUTH, (int)r), r);
                break;
            }
            case 3: {
                box.func_72317_d(0.0, 0.0, -1.0);
                box.field_72339_c -= (double)Math.min(ReikaWorldHelper.getFreeDistance((World)world, (int)x, (int)y, (int)z, (ForgeDirection)ForgeDirection.NORTH, (int)r), r);
            }
        }
        return box;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ARROWGUN;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    public int getRange() {
        return this.getMaxRange();
    }

    @Override
    public int getMaxRange() {
        return 10 + 2 * (int)ReikaMathLibrary.logbase((long)(this.torque + 1), (int)2);
    }

    public int getRedstoneOverride() {
        return Container.func_94526_b((IInventory)this);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public boolean applyEnchants(ItemStack is) {
        boolean accepted = false;
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77342_w, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77342_w, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77342_w, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77345_t, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77345_t, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77345_t, (ItemStack)is));
            accepted = true;
        }
        return accepted;
    }

    @Override
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantments().containsKey(e);
    }

    @Override
    public int getEnchantment(Enchantment e) {
        if (!this.hasEnchantment(e)) {
            return 0;
        }
        return this.getEnchantments().get(e);
    }

    @Override
    public boolean hasEnchantments() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null || this.getEnchantment(Enchantment.field_77331_b[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77342_w);
        li.add(Enchantment.field_77345_t);
        return li;
    }
}

