/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Collections.ClassNameCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.API.Interfaces.EMPControl;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeType;

public class TileEntityEMP
extends TileEntityPowerReceiver
implements RangedEffect {
    public static final long BLAST_ENERGY = 4184000000L;
    private ArrayList<Coordinate> blocks = new ArrayList();
    private BlockArray check = new BlockArray();
    private static ClassNameCache blacklist = new ClassNameCache();
    private static HashSet<WorldLocation> shutdownLocations = new HashSet();
    private boolean loading = true;
    private boolean canLoad = true;
    private long energy;
    public static final int MAX_RANGE = 64;
    @SideOnly(value=Side.CLIENT)
    public EMPEffect effectRender;
    private boolean fired = false;

    private static void addEntry(Class<? extends TileEntity> cl) {
        blacklist.add(cl.getName());
        RotaryCraft.logger.log((Object)("Adding " + cl.getName() + " to the EMP immunity list"));
    }

    private static void addEntry(String name, ModList mod) {
        if (!mod.isLoaded()) {
            return;
        }
        blacklist.add(name);
        RotaryCraft.logger.log((Object)("Adding " + name + " to the EMP immunity list"));
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (world.field_72995_K && this.effectRender != null && this.effectRender.tick()) {
            this.effectRender = null;
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.EMP;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getPowerBelow();
        if (this.fired) {
            return;
        }
        if (this.power >= this.MINPOWER) {
            this.energy += this.power;
        }
        if (this.canLoad && this.check.isEmpty()) {
            int r = this.getRange();
            for (int i = x - r; i <= x + r; ++i) {
                for (int k = z - r; k <= z + r; ++k) {
                    this.check.addBlockCoordinate(i, y, k);
                    this.loading = true;
                }
            }
        }
        if (!world.field_72995_K) {
            this.createListing();
        }
        if (this.loading) {
            for (int i = 0; i < 6; ++i) {
                double dx = rand.nextDouble();
                double dz = rand.nextDouble();
                world.func_72869_a("portal", (double)x - 0.5 + dx * 2.0, (double)y + rand.nextDouble() + 0.4, (double)z - 0.5 + dz * 2.0, -1.0 + dx * 2.0, 0.2, -1.0 + dz * 2.0);
            }
        }
        if (this.energy / 20L >= 4184000000L && !this.loading) {
            this.fire(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initEffect() {
        this.effectRender = new EMPEffect();
    }

    private void createListing() {
        World world = this.field_145850_b;
        int num = 1 + 8 * ConfigRegistry.EMPLOAD.getValue();
        for (int i = 0; i < num && this.loading; ++i) {
            int index = rand.nextInt(this.check.getSize());
            Coordinate b = this.check.getNthBlock(index);
            int x = b.xCoord;
            int z = b.zCoord;
            for (int y = 0; y < world.field_73011_w.getHeight(); ++y) {
                TileEntity te = world.func_147438_o(x, y, z);
                if (!this.canAffect(te)) continue;
                this.blocks.add(new Coordinate(te));
            }
            this.check.remove(b.xCoord, b.yCoord, b.zCoord);
            if (!this.check.isEmpty()) continue;
            this.loading = false;
            this.canLoad = false;
        }
    }

    private boolean canAffect(TileEntity te) {
        if (te == null || te.func_145837_r()) {
            return false;
        }
        if (te instanceof IEnergyReceiver) {
            return true;
        }
        if (te instanceof IEnergyProvider) {
            return true;
        }
        if (InterfaceCache.IC2POWERTILE.instanceOf((Object)te)) {
            return true;
        }
        if (InterfaceCache.NODE.instanceOf((Object)te)) {
            return true;
        }
        if (ModList.CHROMATICRAFT.isLoaded() && te instanceof TileEntityCrystalPylon) {
            return true;
        }
        return te instanceof RotaryCraftTileEntity;
    }

    private void fire(World world, int x, int y, int z) {
        this.fired = true;
        ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.EMPEFFECT.getMinValue(), (TileEntity)this, (int)128, (int[])new int[0]);
        for (int i = 0; i < this.blocks.size(); ++i) {
            TileEntity te = this.blocks.get(i).getTileEntity(world);
            if (ModList.CHROMATICRAFT.isLoaded() && te instanceof TileEntityCrystalPylon) {
                ((TileEntityCrystalPylon)te).onEMP(this);
                continue;
            }
            if (InterfaceCache.NODE.instanceOf((Object)te)) {
                this.chargeNode((INode)te);
                continue;
            }
            this.shutdownTE(te);
        }
        this.affectEntities(world, x, y, z);
    }

    private void destroySelf(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true);
        if (ReikaRandomHelper.doWithChance((double)50.0)) {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)this.getMachine().getCraftedProduct());
        } else if (ReikaRandomHelper.doWithChance((double)50.0)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(new ItemStack(Items.field_151156_bN));
            items.add(new ItemStack(Items.field_151045_i, 9, 0));
            items.add(new ItemStack(Items.field_151043_k, 32, 0));
            items.add(ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)rand.nextInt(16)));
            ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), items);
        } else {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(8 + rand.nextInt(16))));
        }
    }

    private void affectEntities(World world, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(128.0, 64.0, 128.0);
        List li = world.func_72872_a(Entity.class, box);
        for (Entity e : li) {
            if (InterfaceCache.BCROBOT.instanceOf((Object)e)) {
                world.func_72876_a(e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 3.0f, false);
                e.func_70106_y();
                continue;
            }
            if (!(e instanceof EntityLivingBase) || !ReikaEntityHelper.isEntityWearingPoweredArmor((EntityLivingBase)((EntityLivingBase)e))) continue;
            for (int i = 1; i <= 4; ++i) {
                e.func_70062_b(i, null);
            }
            float f = (float)ReikaRandomHelper.getRandomBetween((double)3.0, (double)10.0);
            world.func_72885_a(e, e.field_70165_t, e.field_70163_u, e.field_70161_v, f, true, true);
            e.field_70159_w += ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.5);
            e.field_70179_y += ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.5);
            e.field_70181_x += -ReikaRandomHelper.getRandomBetween((double)0.125, (double)1.0);
        }
    }

    private void chargeNode(INode te) {
        te.setNodeVisBase(Aspect.ENERGY, (short)32000);
        te.setNodeVisBase(Aspect.WEAPON, (short)32000);
        te.setNodeVisBase(Aspect.MECHANISM, (short)32000);
        te.addToContainer(Aspect.ENERGY, 8000);
        te.addToContainer(Aspect.WEAPON, 1000);
        te.addToContainer(Aspect.MECHANISM, 2000);
        switch (te.getNodeType()) {
            case UNSTABLE: {
                if (rand.nextInt(2) == 0) {
                    te.setNodeType(NodeType.DARK);
                    break;
                }
                te.setNodeType(NodeType.PURE);
                break;
            }
            case DARK: {
                te.setNodeType(NodeType.TAINTED);
                break;
            }
            case NORMAL: {
                te.setNodeType(NodeType.UNSTABLE);
                break;
            }
            case TAINTED: {
                te.setNodeType(NodeType.HUNGRY);
                break;
            }
        }
    }

    private void shutdownTE(TileEntity te) {
        if (te == null) {
            return;
        }
        if (this.isBlacklisted(te)) {
            return;
        }
        ReikaPacketHelper.sendDataPacketToEntireServer((String)"RotaryCraftData", (int)PacketRegistry.SPARKLOC.getMinValue(), (int[])new int[]{te.field_145850_b.field_73011_w.field_76574_g, te.field_145851_c, te.field_145848_d, te.field_145849_e, 1});
        if (te instanceof RotaryCraftTileEntity) {
            RotaryCraftTileEntity rc = (RotaryCraftTileEntity)te;
            if (!rc.isShutdown()) {
                rc.onEMP();
            }
        } else if (te instanceof EMPControl) {
            ((EMPControl)te).onHitWithEMP((TileEntity)this);
        } else {
            shutdownLocations.add(new WorldLocation(te));
        }
    }

    private boolean isBlacklisted(TileEntity te) {
        return blacklist.contains(te.getClass());
    }

    private void shutdownFallback(TileEntity te) {
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        Block id = this.field_145850_b.func_147439_a(x, y, z);
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        this.dropMachine(this.field_145850_b, x, y, z);
    }

    public static boolean isShutdown(TileEntity te) {
        return shutdownLocations.contains(new WorldLocation(te));
    }

    public static boolean isShutdown(World world, int x, int y, int z) {
        return shutdownLocations.contains(new WorldLocation(world, x, y, z));
    }

    public static void resetCoordinate(World world, int x, int y, int z) {
        if (shutdownLocations.remove(new WorldLocation(world, x, y, z))) {
            ReikaPacketHelper.sendDataPacketToEntireServer((String)"RotaryCraftData", (int)PacketRegistry.SPARKLOC.getMinValue(), (int[])new int[]{world.field_73011_w.field_76574_g, x, y, z, 0});
        }
    }

    private void dropMachine(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b != null) {
            b.func_149697_b(world, x, y, z, meta, 0);
        }
        world.func_147468_f(x, y, z);
    }

    @Override
    public int getRange() {
        return 64;
    }

    @Override
    public int getMaxRange() {
        return 64;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean usable() {
        return !this.fired;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("load", this.loading);
        NBT.func_74757_a("cload", this.canLoad);
        NBT.func_74757_a("fire", this.fired);
        NBT.func_74772_a("e", this.energy);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.loading = NBT.func_74767_n("load");
        this.canLoad = NBT.func_74767_n("cload");
        this.fired = NBT.func_74767_n("fire");
        this.energy = NBT.func_74763_f("e");
    }

    public void updateListing() {
        this.canLoad = true;
    }

    @SideOnly(value=Side.CLIENT)
    public final double func_145833_n() {
        return 16384.0;
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    static {
        TileEntityEMP.addEntry(TileEntityChest.class);
        TileEntityEMP.addEntry(TileEntityEnderChest.class);
        TileEntityEMP.addEntry(TileEntityHopper.class);
        TileEntityEMP.addEntry(TileEntityDropper.class);
        TileEntityEMP.addEntry(TileEntityDispenser.class);
        TileEntityEMP.addEntry(TileEntityBrewingStand.class);
        TileEntityEMP.addEntry(TileEntityEnchantmentTable.class);
        TileEntityEMP.addEntry(TileEntityEndPortal.class);
        TileEntityEMP.addEntry(TileEntitySign.class);
        TileEntityEMP.addEntry(TileEntitySkull.class);
        TileEntityEMP.addEntry("buildcraft.factory.TileTank", ModList.BCFACTORY);
        TileEntityEMP.addEntry("buildcraft.transport.PipeTransport", ModList.BCTRANSPORT);
        TileEntityEMP.addEntry("thermalexpansion.Blocks.conduit.TileConduitRoot", ModList.THERMALEXPANSION);
        TileEntityEMP.addEntry("ic2.core.Blocks.wiring.TileEntityCable", ModList.IC2);
        TileEntityEMP.addEntry("codechicken.enderstorage.common.TileFrequencyOwner", ModList.ENDERSTORAGE);
        TileEntityEMP.addEntry("thaumcraft.common.tiles.*", ModList.THAUMCRAFT);
        TileEntityEMP.addEntry("forestry.core.tiles.TileNaturalistChest", ModList.FORESTRY);
        TileEntityEMP.addEntry("forestry.core.tiles.TileMill", ModList.FORESTRY);
        TileEntityEMP.addEntry("forestry.apiculture.multiblock.TileAlvearyPlain", ModList.FORESTRY);
        TileEntityEMP.addEntry("forestry.apiculture.tiles.*", ModList.FORESTRY);
        TileEntityEMP.addEntry("forestry.aboriculture.tiles.TileTreeContainer", ModList.FORESTRY);
        TileEntityEMP.addEntry("forestry.factory.tiles.TileWorktable", ModList.FORESTRY);
        TileEntityEMP.addEntry("Reika.ExpandedRedstone.TileEntities.*", ModList.EXPANDEDREDSTONE);
        TileEntityEMP.addEntry("Reika.ElectriCraft.TileEntities.TileEntityWire", ModList.ELECTRICRAFT);
    }

    @SideOnly(value=Side.CLIENT)
    public static class EMPEffect {
        public static final int EXPAND_LIFESPAN = 20;
        public static final int FADE_LIFESPAN = 10;
        private int age = 0;

        private EMPEffect() {
        }

        public boolean tick() {
            ++this.age;
            return this.age > 30;
        }

        public double getRadius(float ptick) {
            if (this.age >= 20) {
                return 64.0f + 2.0f * ((float)(this.age - 20) + ptick);
            }
            return Math.min(64.0, 0.25 + (double)(((float)this.age + ptick) * 64.0f) / 20.0);
        }

        public float getBrightness() {
            return this.age <= 20 ? 1.0f : 1.0f - (float)(this.age - 20) / 10.0f;
        }

        public int getColor1() {
            return ReikaColorAPI.getColorWithBrightnessMultiplier((int)-4259841, (float)this.getBrightness());
        }

        public int getColor2() {
            return ReikaColorAPI.getColorWithBrightnessMultiplier((int)-12061982, (float)this.getBrightness());
        }
    }
}

