/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityItemRefresher
extends TileEntityPowerReceiver
implements RangedEffect {
    public static final int FALLOFF = 1024;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        int range = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + 1 + range), (double)(y + 1 + range), (double)(z + 1 + range));
        List items = world.func_72872_a(EntityItem.class, box);
        for (EntityItem item : items) {
            if (item.field_70292_b > item.lifespan - 20) {
                item.field_70292_b = item.lifespan - 20;
            }
            if (item.field_70181_x != 0.0) continue;
            item.field_70181_x = 0.4;
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    public int getRange() {
        return Math.min(this.getMaxRange(), 4 + (int)(this.power - this.MINPOWER) / 1024);
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.REFRESHER;
    }

    @Override
    public int getMaxRange() {
        return 128;
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

