/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Surveying;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.BlockColorMapper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGPR
extends TileEntityPowerReceiver
implements GuiController,
RangedEffect {
    public BlockKey[][] blocks = new BlockKey[256][81];
    public boolean xdir;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private int oldmeta = 0;

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public BlockVector getLookDirection() {
        return new BlockVector(this.field_145851_c + this.offsetX, this.field_145848_d + this.offsetY, this.field_145849_e + this.offsetZ, ReikaDirectionHelper.getRightBy90((ForgeDirection)this.getGuiDirection()));
    }

    public void shift(ForgeDirection dir, int amt) {
        if (amt == 0) {
            this.offsetZ = 0;
            this.offsetY = 0;
            this.offsetX = 0;
        } else {
            this.offsetX += dir.offsetX * amt;
            this.offsetY += dir.offsetY * amt;
            this.offsetZ += dir.offsetZ * amt;
        }
    }

    public void shiftInt(int amt) {
        this.shift(this.getGuiDirection(), amt);
    }

    public void resetOffset() {
        this.offsetZ = 0;
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public ForgeDirection getGuiDirection() {
        return this.xdir ? ForgeDirection.SOUTH : ForgeDirection.EAST;
    }

    public double getSpongy(World world, int x, int y, int z) {
        int range = (this.getBounds()[1] - this.getBounds()[0]) / 2;
        int numcave = 0;
        int numsolid = 0;
        boolean dungeon = false;
        boolean mineshaft = false;
        boolean stronghold = false;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = y; k >= 0; --k) {
                    Block id = world.func_147439_a(x + i, k, z + j);
                    if (ReikaWorldHelper.caveBlock((Block)id)) {
                        ++numcave;
                    } else {
                        ++numsolid;
                    }
                    if (id == Blocks.field_150321_G) {
                        mineshaft = true;
                    }
                    if (id != Blocks.field_150384_bq && id != Blocks.field_150378_br) continue;
                    stronghold = true;
                }
            }
        }
        double ans = (double)numcave / (double)(numcave + numsolid);
        return ans;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getSummativeSidedPower();
        this.power = (long)this.omega * (long)this.torque;
        if (this.power < this.MINPOWER) {
            return;
        }
        RotaryAchievements.GPR.triggerAchievement(this.getPlacer());
        if (this.tickcount == 0) {
            int[] bounds = this.getBounds();
            this.eval2(world, x + this.offsetX, y + this.offsetY, z + this.offsetZ, meta, bounds);
            this.tickcount = 20;
        }
        --this.tickcount;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor(int x, int y) {
        return this.getBlockColor(this.blocks[x][y]);
    }

    @SideOnly(value=Side.CLIENT)
    private int getBlockColor(BlockKey bk) {
        return bk != null ? BlockColorMapper.instance.getColorForBlock(bk.blockID, bk.metadata) : -2851073;
    }

    private void eval2(World world, int x, int y, int z, int meta, int[] bounds) {
        int a = 0;
        if (this.xdir) {
            a = 1;
        }
        int b = 1 - a;
        int diff = (bounds[1] - bounds[0]) / 2;
        if (a == 1) {
            for (int j = bounds[0]; j <= bounds[1]; ++j) {
                for (int i = 0; i < y; ++i) {
                    BlockKey bk;
                    this.blocks[i][j] = bk = BlockKey.getAt((IBlockAccess)world, (int)(x + j - bounds[0] - diff), (int)(y - i - 1), (int)z);
                    this.checkAchievements(bk);
                }
            }
        } else {
            for (int j = bounds[0]; j <= bounds[1]; ++j) {
                for (int i = 0; i < y; ++i) {
                    BlockKey bk;
                    this.blocks[i][j] = bk = BlockKey.getAt((IBlockAccess)world, (int)x, (int)(y - i - 1), (int)(z + j - bounds[0] - diff));
                    this.checkAchievements(bk);
                }
            }
        }
    }

    private void checkAchievements(BlockKey bk) {
        if (bk.blockID == Blocks.field_150384_bq || bk.blockID == Blocks.field_150378_br) {
            RotaryAchievements.GPRENDPORTAL.triggerAchievement(this.getPlacer());
        } else if (bk.blockID == Blocks.field_150474_ac) {
            RotaryAchievements.GPRSPAWNER.triggerAchievement(this.getPlacer());
        }
    }

    public int[] getBounds() {
        int[] val = new int[]{40, 40};
        int range = this.getRange();
        if (range <= 0) {
            return val;
        }
        val[0] = val[0] - range;
        val[1] = val[1] + range;
        if (val[0] < 0) {
            val[0] = 0;
        }
        if (val[1] >= 80) {
            val[1] = 80;
        }
        return val;
    }

    @Override
    public int getRange() {
        return (int)(2.0 * ReikaMathLibrary.logbase((long)(this.power - this.MINPOWER), (int)2));
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.GPR;
    }

    @Override
    public int getMaxRange() {
        return 40;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.offsetX = NBT.func_74762_e("xoff");
        this.offsetY = NBT.func_74762_e("yoff");
        this.offsetZ = NBT.func_74762_e("zoff");
    }

    @Override
    public void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("xoff", this.offsetX);
        NBT.func_74768_a("yoff", this.offsetY);
        NBT.func_74768_a("zoff", this.offsetZ);
    }
}

