/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesLavaMaker;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidProducer;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityLavaMaker
extends InventoriedPowerLiquidProducer
implements IFluidHandler,
PipeConnector,
TemperatureTE,
ConditionalOperation {
    public static final int CAPACITY = 64000;
    public static final int MAXTEMP = 1800;
    private int temperature;
    private long energy;
    private StepTimer timer = new StepTimer(20);

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.timer.update();
        if (this.timer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        this.energy = this.temperature > this.getMeltingTemperature() ? (this.energy += this.power) : (long)((double)this.energy * 0.85);
        ++this.tickcount;
        if (this.omega > 0 && this.power > 0L) {
            if (this.tickcount > 98) {
                SoundRegistry.FRICTION.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.1f : 0.5f, 0.5f);
                this.tickcount = 0;
            }
            world.func_72869_a("crit", (double)x + rand.nextDouble(), (double)y, (double)z + rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble(), 0.4 * rand.nextDouble(), -0.2 + 0.4 * rand.nextDouble());
        }
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack is = this.inv[i];
            if (is == null) continue;
            FluidStack fs = RecipesLavaMaker.getRecipes().getMelting(is);
            long melt_energy = RecipesLavaMaker.getRecipes().getMeltingEnergy(is);
            if (fs == null || !this.canMake(fs) || this.energy < melt_energy * 20L) continue;
            this.tank.addLiquid(fs.amount, fs.getFluid());
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            this.energy -= melt_energy * 20L;
            return;
        }
    }

    private int getMeltingTemperature() {
        for (int i = 0; i < this.inv.length; ++i) {
            int temp;
            ItemStack is = this.inv[i];
            if (is == null || (temp = RecipesLavaMaker.getRecipes().getMeltTemperature(is)) <= Integer.MIN_VALUE) continue;
            return temp;
        }
        return Integer.MAX_VALUE;
    }

    private boolean canMake(FluidStack liq) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.tank.isEmpty()) {
            return true;
        }
        if (!this.tank.getActualFluid().equals(liq.getFluid())) {
            return false;
        }
        return this.tank.getLevel() + liq.amount <= this.tank.getCapacity();
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int func_70302_i_() {
        return 9;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.FUELLINE;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return RecipesLavaMaker.getRecipes().isValidFuel(is);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.LAVAMAKER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        if (this.tank.isFull()) {
            return 15;
        }
        if (!this.canMake()) {
            return 15;
        }
        return 0;
    }

    private boolean canMake() {
        for (int i = 0; i < this.inv.length; ++i) {
            FluidStack fs;
            ItemStack is = this.inv[i];
            if (is == null || (fs = RecipesLavaMaker.getRecipes().getMelting(is)) == null || !this.canMake(fs)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.energy = NBT.func_74763_f("e");
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74772_a("e", this.energy);
        NBT.func_74768_a("temp", this.temperature);
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public boolean hasStone() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    public void setEmpty() {
        this.tank.empty();
    }

    public void removeLava(int amt) {
        this.tank.removeLiquid(amt);
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to.offsetY == 0;
    }

    @Override
    public int getCapacity() {
        return 64000;
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Items";
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.power > 0L) {
            this.temperature = (int)((double)this.temperature + ReikaMathLibrary.logbase((long)this.power, (int)2));
        }
        this.temperature = this.temperature > Tamb ? (this.temperature -= (this.temperature - Tamb) / 64) : (this.temperature += (this.temperature - Tamb) / 64);
        if (this.temperature - Tamb <= 64 && this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > 1800) {
            this.temperature = 1800;
            this.overheat(world, x, y, z);
        }
        if (this.temperature > 50) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 1800;
    }
}

