/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Instantiable.Math.MovingAverage;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.PressureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidProducer;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFractionator
extends InventoriedPowerLiquidProducer
implements MultiOperational,
ConditionalOperation,
PressureTE {
    public int mixTime;
    private int pressure;
    public static final int CAPACITY = 240000;
    public static final int MINTIME = 10;
    public static int MAXPRESSURE = 1000;
    public boolean idle = false;
    private static final HashSet<KeyedItemStack> ingredients = new HashSet();
    private static final Interpolation yield = new Interpolation(false);
    private final MovingAverage torqueInput = new MovingAverage(20);

    public static boolean isJetFuelIngredient(ItemStack is) {
        return ingredients.contains(new KeyedItemStack(is).setSimpleHash(true));
    }

    public static Collection<KeyedItemStack> getIngredients() {
        return Collections.unmodifiableCollection(ingredients);
    }

    public void testIdle() {
        this.idle = !this.getAllIngredients();
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int getFuelScaled(int par1) {
        return this.tank.getLevel() * par1 / 240000;
    }

    public int getMixScaled(int par1) {
        return this.mixTime * par1 / this.getOperationTime();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.power = (long)this.omega * (long)this.torque;
        if (this.inv[ingredients.size() + 1] != null && this.tank.getLevel() >= 1000 && this.inv[ingredients.size() + 1].func_77973_b() == Items.field_151133_ar && this.inv[TileEntityFractionator.ingredients.size() + 1].field_77994_a == 1) {
            this.inv[TileEntityFractionator.ingredients.size() + 1] = ItemStacks.fuelbucket.func_77946_l();
            this.tank.removeLiquid(1000);
        }
        this.torqueInput.addValue((double)this.torque);
        if (!world.field_72995_K && this.getTicksExisted() % 20 == 0) {
            this.updatePressure(world, x, y, z, meta);
        }
        this.testIdle();
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            this.mixTime = 0;
            return;
        }
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            this.doOperation(n > 1);
        }
    }

    @Override
    public void updatePressure(World world, int x, int y, int z, int meta) {
        int local = this.pressure;
        int dp = local - (int)ReikaWorldHelper.getAmbientPressureAt((World)world, (int)x, (int)y, (int)z, (boolean)false);
        int sub = (int)(Math.signum(dp) * (float)Math.max(1, Math.abs(dp / 16)));
        int avg = (int)this.torqueInput.getAverage();
        if (avg <= 0) {
            sub *= 8;
        }
        local -= sub;
        if (avg > 0) {
            local = (int)((double)local + 1.8 * Math.sqrt(avg));
        }
        if (local > MAXPRESSURE) {
            this.overpressure(world, x, y, z);
            local = MAXPRESSURE;
        }
        this.pressure = this.pressure < local ? (this.pressure += Math.max(1, Math.min(ReikaRandomHelper.getRandomPlusMinus((int)6, (int)13), (local - this.pressure) / 4))) : local;
    }

    private void doOperation(boolean multiple) {
        if (this.process()) {
            ++this.mixTime;
            if (multiple || this.mixTime >= this.getOperationTime()) {
                this.mixTime = 0;
                this.make();
            }
        } else {
            this.mixTime = 0;
        }
    }

    private void make() {
        RotaryAchievements.JETFUEL.triggerAchievement(this.getPlacer());
        for (int i = 0; i < ingredients.size(); ++i) {
            if (!DifficultyEffects.CONSUMEFRAC.testChance() || this.field_145850_b.field_72995_K) continue;
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
        }
        if (DifficultyEffects.FRACTIONTEAR.testChance()) {
            ReikaInventoryHelper.decrStack((int)ingredients.size(), (ItemStack[])this.inv);
        }
        this.tank.addLiquid((int)(this.getYieldRatio() * (float)DifficultyEffects.PRODUCEFRAC.getInt()), FluidRegistry.getFluid((String)"rc jet fuel"));
    }

    public float getYieldRatio() {
        return (float)yield.getValue((double)this.pressure);
    }

    private boolean process() {
        if (this.tank.getLevel() + DifficultyEffects.PRODUCEFRAC.getMaxAmount() >= 240000) {
            return false;
        }
        if (this.inv[ingredients.size()] == null) {
            return false;
        }
        if (this.inv[ingredients.size()].func_77973_b() != Items.field_151073_bk) {
            return false;
        }
        return this.getAllIngredients();
    }

    private boolean getAllIngredients() {
        HashSet<KeyedItemStack> check = new HashSet<KeyedItemStack>(ingredients);
        for (int i = 0; i < ingredients.size(); ++i) {
            if (this.inv[i] == null) {
                return false;
            }
            KeyedItemStack ks = new KeyedItemStack(this.inv[i]).setSimpleHash(true);
            if (!check.contains(ks)) {
                return false;
            }
            check.remove(ks);
        }
        return true;
    }

    public int func_70302_i_() {
        return ingredients.size() + 1 + 1;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("mix", this.mixTime);
        NBT.func_74768_a("press", this.pressure);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.mixTime = NBT.func_74762_e("mix");
        this.pressure = NBT.func_74762_e("press");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FRACTIONATOR;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot == ingredients.size() + 1) {
            return is.func_77973_b() == Items.field_151133_ar;
        }
        if (slot == ingredients.size()) {
            return is.func_77973_b() == Items.field_151073_bk;
        }
        if (!TileEntityFractionator.isJetFuelIngredient(is)) {
            return false;
        }
        HashSet slots = ReikaInventoryHelper.getSlotsBetweenWithItemStack((ItemStack)is, (IInventory)this, (int)0, (int)(ingredients.size() - 1), (boolean)false);
        return slots.isEmpty() || slots.contains(slot);
    }

    public int getRedstoneOverride() {
        if (!this.getAllIngredients()) {
            return 15;
        }
        return 15 * this.tank.getLevel() / 240000;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m == MachineRegistry.BEDPIPE;
    }

    public int getFuelLevel() {
        return this.tank.getLevel();
    }

    public void setEmpty() {
        this.tank.empty();
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to == ForgeDirection.UP;
    }

    @Override
    public int getCapacity() {
        return 240000;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.FRACTIONATOR.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.FRACTIONATOR.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        int nslots = ReikaInventoryHelper.countEmptySlots((ItemStack[])this.inv);
        return nslots == 0 || nslots == 1 && this.inv[7] == null;
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Missing Ingredients";
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public int getMaxPressure() {
        return MAXPRESSURE;
    }

    @Override
    public void addPressure(int press) {
        this.pressure += press;
    }

    @Override
    public void overpressure(World world, int x, int y, int z) {
    }

    static {
        ingredients.add(new KeyedItemStack(Items.field_151065_br).setSimpleHash(true));
        ingredients.add(new KeyedItemStack(new ItemStack(Items.field_151044_h, 1, 0)).setIgnoreMetadata(false).setSimpleHash(true));
        ingredients.add(new KeyedItemStack(Items.field_151064_bs).setSimpleHash(true));
        ingredients.add(new KeyedItemStack(ItemRegistry.ETHANOL.getStackOf()).setIgnoreMetadata(false).setSimpleHash(true));
        ingredients.add(new KeyedItemStack(ItemStacks.netherrackdust).setSimpleHash(true));
        ingredients.add(new KeyedItemStack(ItemStacks.tar).setSimpleHash(true));
        yield.addPoint(0.0, 0.01);
        yield.addPoint(100.0, 0.05);
        yield.addPoint(180.0, 0.1);
        yield.addPoint(500.0, 0.4);
        yield.addPoint(720.0, 1.0);
        yield.addPoint(850.0, 1.5);
        yield.addPoint(1000.0, 2.5);
    }
}

