/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.XPProducer;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.FrictionHeatable;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedRCTileEntity;
import Reika.RotaryCraft.Items.Tools.ItemCraftPattern;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlastFurnace
extends InventoriedRCTileEntity
implements TemperatureTE,
XPProducer,
FrictionHeatable,
DiscreteFunction,
ConditionalOperation {
    private int temperature;
    public int smeltTime = 0;
    public static final int SMELTTEMP = 600;
    public static final int BEDROCKTEMP = 1450;
    public static final int MAXTEMP = 2000;
    public static final float SMELT_XP = 0.6f;
    public static final int CENTER_ADDITIVE = 0;
    public static final int LOWER_ADDITIVE = 11;
    public static final int UPPER_ADDITIVE = 14;
    public static final int PATTERN_SLOT = 15;
    public static final int OUTPUT_CENTER = 10;
    public static final int OUTPUT_UPPER = 12;
    public static final int OUTPUT_LOWER = 13;
    private float xp;
    private RecipesBlastFurnace.BlastFurnacePattern pattern;
    private final StepTimer tempTimer = new StepTimer(20);
    public boolean[] lockedSlots = new boolean[this.inv.length];
    public boolean leaveLastItem;

    @Override
    protected int getActiveTexture() {
        return this.getRecipe() != null || this.getCrafting() != null ? 1 : 0;
    }

    private RecipesBlastFurnace.BlastCrafting getCrafting() {
        ItemStack[] center = new ItemStack[9];
        System.arraycopy(this.inv, 1, center, 0, 9);
        RecipesBlastFurnace.BlastCrafting c = RecipesBlastFurnace.getRecipes().getCrafting(center, this.temperature);
        return c;
    }

    private RecipesBlastFurnace.BlastRecipe getRecipe() {
        ItemStack[] center = new ItemStack[9];
        System.arraycopy(this.inv, 1, center, 0, 9);
        RecipesBlastFurnace.BlastRecipe rec = RecipesBlastFurnace.getRecipes().getRecipe(this.inv[0], this.inv[11], this.inv[14], center, this.temperature);
        if (rec == null) {
            return null;
        }
        if (rec.requiresEmptyOutput() && (this.inv[10] != null || this.inv[13] != null || this.inv[12] != null)) {
            return null;
        }
        ItemStack out = rec.outputItem();
        int num = this.getProducedFor(rec);
        if (!this.checkCanMakeItem(out = ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)num))) {
            return null;
        }
        if (this.leaveLastItem) {
            for (int i = 1; i <= 9; ++i) {
                if (this.inv[i] == null || this.inv[i].field_77994_a != 1) continue;
                return null;
            }
        }
        return rec;
    }

    private boolean checkCanMakeItem(ItemStack out) {
        return this.canAdd(out, 10) || this.canAdd(out, 13) || this.canAdd(out, 12);
    }

    private boolean canAdd(ItemStack is, int slot) {
        if (this.inv[slot] == null) {
            return true;
        }
        ItemStack in = this.inv[slot];
        return ReikaItemHelper.areStacksCombinable((ItemStack)is, (ItemStack)is, (int)this.func_70297_j_());
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        RecipesBlastFurnace.BlastRecipe rec = this.getRecipe();
        RecipesBlastFurnace.BlastCrafting bc = this.getCrafting();
        if (bc != null) {
            this.pattern = bc;
            if (bc.speed <= 1 || this.field_145850_b.func_82737_E() % (long)bc.speed == 0L) {
                ++this.smeltTime;
            }
            if (this.smeltTime >= this.getOperationTime()) {
                this.craft(bc);
            }
        } else if (rec != null) {
            this.pattern = rec;
            ++this.smeltTime;
            if (this.smeltTime >= this.getOperationTime()) {
                this.make(rec);
            }
        } else {
            this.pattern = null;
            this.smeltTime = 0;
            return;
        }
    }

    private void craft(RecipesBlastFurnace.BlastCrafting bc) {
        this.smeltTime = 0;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack out = bc.outputItem();
        if (!(ReikaInventoryHelper.addOrSetStack((ItemStack)out, (ItemStack[])this.inv, (int)10) || ReikaInventoryHelper.addOrSetStack((ItemStack)out, (ItemStack[])this.inv, (int)12) || ReikaInventoryHelper.addOrSetStack((ItemStack)out, (ItemStack[])this.inv, (int)13) || this.checkSpreadFit(out, out.field_77994_a))) {
            return;
        }
        this.xp += (float)out.field_77994_a * bc.xp;
        if (this.getPlacer() != null) {
            out.func_77980_a(this.field_145850_b, this.getPlacer(), out.field_77994_a);
        }
        for (int i = 1; i < 10; ++i) {
            if (this.inv[i] == null) continue;
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
        }
    }

    private void make(RecipesBlastFurnace.BlastRecipe rec) {
        int i;
        double chance;
        int num;
        this.smeltTime = 0;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int made = num = this.getProducedFor(rec);
        ItemStack out = rec.outputItem();
        if (rec.hasBonus && ReikaRandomHelper.doWithChance((double)(chance = DifficultyEffects.BONUSSTEEL.getDouble() * (ReikaMathLibrary.intpow((double)1.005, (int)(num * num)) - 1.0)))) {
            num = (int)((float)num * (1.0f + rand.nextFloat()));
        }
        if (ReikaItemHelper.matchStacks((ItemStack)out, (ItemStack)ItemStacks.steelblock)) {
            if (!(ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.steelingot, (int)(2 * num)), (ItemStack[])this.inv, (int)10) || ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.steelingot, (int)(2 * num)), (ItemStack[])this.inv, (int)12) || ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.steelingot, (int)(2 * num)), (ItemStack[])this.inv, (int)13))) {
                return;
            }
            if (!(ReikaInventoryHelper.addOrSetStack((ItemStack)new ItemStack(Items.field_151044_h, 3 * num, 1), (ItemStack[])this.inv, (int)10) || ReikaInventoryHelper.addOrSetStack((ItemStack)new ItemStack(Items.field_151044_h, 3 * num, 1), (ItemStack[])this.inv, (int)12) || ReikaInventoryHelper.addOrSetStack((ItemStack)new ItemStack(Items.field_151044_h, 3 * num, 1), (ItemStack[])this.inv, (int)13))) {
                return;
            }
            if (!(ReikaInventoryHelper.addOrSetStack((ItemStack)new ItemStack(Items.field_151042_j, 5 * num, 0), (ItemStack[])this.inv, (int)10) || ReikaInventoryHelper.addOrSetStack((ItemStack)new ItemStack(Items.field_151042_j, 5 * num, 0), (ItemStack[])this.inv, (int)12) || ReikaInventoryHelper.addOrSetStack((ItemStack)new ItemStack(Items.field_151042_j, 5 * num, 0), (ItemStack[])this.inv, (int)13))) {
                return;
            }
        } else if (!(ReikaInventoryHelper.addOrSetStack((Item)out.func_77973_b(), (int)num, (int)out.func_77960_j(), (ItemStack[])this.inv, (int)10) || ReikaInventoryHelper.addOrSetStack((Item)out.func_77973_b(), (int)num, (int)out.func_77960_j(), (ItemStack[])this.inv, (int)12) || ReikaInventoryHelper.addOrSetStack((Item)out.func_77973_b(), (int)num, (int)out.func_77960_j(), (ItemStack[])this.inv, (int)13) || this.checkSpreadFit(out, num))) {
            return;
        }
        this.xp += rec.xp * (float)num;
        for (i = 0; i < rec.primary.numberToUse; ++i) {
            if (!ReikaRandomHelper.doWithChance((double)this.getConsumptionFactor(rec.primary.chanceToUse, made))) continue;
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        }
        for (i = 0; i < rec.secondary.numberToUse; ++i) {
            if (!ReikaRandomHelper.doWithChance((double)this.getConsumptionFactor(rec.secondary.chanceToUse, made))) continue;
            ReikaInventoryHelper.decrStack((int)11, (ItemStack[])this.inv);
        }
        for (i = 0; i < rec.tertiary.numberToUse; ++i) {
            if (!ReikaRandomHelper.doWithChance((double)this.getConsumptionFactor(rec.tertiary.chanceToUse, made))) continue;
            ReikaInventoryHelper.decrStack((int)14, (ItemStack[])this.inv);
        }
        for (i = 1; i < 10; ++i) {
            if (this.inv[i] == null) continue;
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
        }
        RotaryAchievements a = this.getAchievement(rec);
        if (a != null) {
            a.triggerAchievement(this.getPlacer());
        }
    }

    private float getConsumptionFactor(float base, int made) {
        return MathHelper.func_76131_a((float)(base * (float)made * DifficultyEffects.BLASTCONSUME.getChance()), (float)base, (float)1.0f);
    }

    private int getProducedFor(RecipesBlastFurnace.BlastRecipe rec) {
        int num = 0;
        for (int i = 1; i < 10; ++i) {
            if (this.inv[i] == null || !rec.isValidMainItem(this.inv[i])) continue;
            ++num;
        }
        return rec.getNumberProduced(num);
    }

    private RotaryAchievements getAchievement(RecipesBlastFurnace.BlastRecipe rec) {
        if (rec.isValidMainItem(ItemStacks.scrap)) {
            return RotaryAchievements.RECYCLE;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)rec.outputItem(), (ItemStack)ItemStacks.steelingot)) {
            return RotaryAchievements.MAKESTEEL;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)rec.outputItem(), (ItemStack)ItemStacks.steelblock)) {
            return RotaryAchievements.FAILSTEEL;
        }
        return null;
    }

    public int getTemperatureScaled(int p1) {
        return p1 * this.temperature / 2000;
    }

    public void dropXP() {
        ReikaWorldHelper.splitAndSpawnXP((World)this.field_145850_b, (double)((float)this.field_145851_c + rand.nextFloat()), (double)((float)this.field_145848_d + 1.25f), (double)((float)this.field_145849_e + rand.nextFloat()), (int)((int)this.xp));
        this.xp = 0.0f;
    }

    public float getXP() {
        return this.xp;
    }

    public void clearXP() {
        this.xp = 0.0f;
    }

    private boolean checkSpreadFit(ItemStack is, int num) {
        int f3;
        int f2;
        int maxfit = 0;
        int f1 = is.func_77976_d() - this.inv[10].field_77994_a;
        maxfit = f1 + (f2 = is.func_77976_d() - this.inv[12].field_77994_a) + (f3 = is.func_77976_d() - this.inv[13].field_77994_a);
        if (num > maxfit) {
            return false;
        }
        if (f1 > num) {
            this.inv[10].field_77994_a += num;
            return true;
        }
        this.inv[10].field_77994_a = this.inv[10].func_77976_d();
        if (f2 > (num -= f1)) {
            this.inv[12].field_77994_a += num;
            return true;
        }
        this.inv[12].field_77994_a = this.inv[12].func_77976_d();
        if (f3 > (num -= f2)) {
            this.inv[12].field_77994_a += num;
            return true;
        }
        this.inv[13].field_77994_a = this.inv[13].func_77976_d();
        num -= f3;
        return true;
    }

    @Override
    public int getOperationTime() {
        int time = 2 * ((1500 - (this.temperature - 600)) / 12);
        if (time < 1) {
            return 1;
        }
        return time;
    }

    public int getCookScaled(int p1) {
        return p1 * this.smeltTime / this.getOperationTime();
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (RotaryAux.isNextToWater(world, x, y, z)) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) == null) {
            iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150403_cj);
        }
        if (iceside != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        int Tadd = 0;
        if (RotaryAux.isNextToFire(world, x, y, z)) {
            Tadd += Tamb >= 100 ? 100 : 200;
        }
        if (RotaryAux.isNextToLava(world, x, y, z)) {
            Tadd += Tamb >= 100 ? 400 : 600;
        }
        if (this.temperature > (Tamb += Tadd)) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 2000) {
            this.temperature = 2000;
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side == null) {
                side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150431_aC);
            }
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    public int func_70302_i_() {
        return 16;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("melt", this.smeltTime);
        NBT.func_74768_a("temp", this.temperature);
        NBT.func_74776_a("exp", this.xp);
        NBT.func_74768_a("locks", ReikaArrayHelper.booleanToBitflags((boolean[])this.lockedSlots));
        NBT.func_74757_a("last", this.leaveLastItem);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.smeltTime = NBT.func_74762_e("melt");
        this.temperature = NBT.func_74762_e("temp");
        this.xp = NBT.func_74760_g("exp");
        this.lockedSlots = ReikaArrayHelper.booleanFromBitflags((int)NBT.func_74762_e("locks"), (int)this.inv.length);
        this.leaveLastItem = NBT.func_74767_n("last");
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return is != null && this.getSlotForItem(i, is);
    }

    private boolean getSlotForItem(int slot, ItemStack is) {
        ItemStack patt = this.inv[15];
        if (ItemRegistry.CRAFTPATTERN.matchItem(patt) && slot >= 1 && slot <= 9) {
            return ItemCraftPattern.checkPatternForMatch((IInventory)this, ItemCraftPattern.RecipeMode.BLASTFURN, slot, slot - 1, is, patt);
        }
        if (this.lockedSlots[slot]) {
            return false;
        }
        HashSet slots = ReikaInventoryHelper.getSlotsBetweenWithItemStack((ItemStack)is, (IInventory)this, (int)1, (int)9, (boolean)false);
        if (!slots.isEmpty()) {
            return slots.contains(slot);
        }
        Set<Integer> types = RecipesBlastFurnace.getRecipes().getInputTypesForItem(is);
        if (slot == 0) {
            return types.contains(1);
        }
        if (slot == 11) {
            return types.contains(2);
        }
        if (slot == 14) {
            return types.contains(3);
        }
        if (slot >= 1 && slot <= 9) {
            return types.contains(0);
        }
        return false;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BLASTFURNACE;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 10 || i == 12 || i == 13;
    }

    public int getRedstoneOverride() {
        return this.getRecipe() == null ? 15 : 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public void onEMP() {
    }

    @Override
    public int getMaxTemperature() {
        return 2000;
    }

    @Override
    public boolean areConditionsMet() {
        return this.getRecipe() != null;
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Insufficient Temperature or Invalid or Missing Items";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public void resetAmbientTemperatureTimer() {
        this.tempTimer.reset();
    }

    @Override
    public float getMultiplier() {
        return 1.0f;
    }

    @Override
    public void onOverheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean canBeFrictionHeated() {
        return true;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }
}

