/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPurifier
extends InventoriedPowerReceiver
implements TemperatureTE,
DiscreteFunction,
ConditionalOperation {
    public int cookTime = 0;
    public int temperature;
    public static final int SMELTTEMP = 600;
    public static final int MAXTEMP = 1000;

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 6;
    }

    public int func_70302_i_() {
        return 8;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.cookTime = this.tickcount++;
        this.updateTemperature(world, x, y, z, meta);
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            this.tickcount = 0;
            return;
        }
        if (!this.canSmelt()) {
            this.tickcount = 0;
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.smelt();
    }

    private void smelt() {
        this.tickcount = 0;
        int count = 0;
        for (int i = 1; i < 6; ++i) {
            if (!this.isModSteel(this.inv[i])) continue;
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            ++count;
        }
        if (count <= 0) {
            return;
        }
        ReikaInventoryHelper.addOrSetStack((Item)ItemStacks.steelingot.func_77973_b(), (int)count, (int)ItemStacks.steelingot.func_77960_j(), (ItemStack[])this.inv, (int)6);
        if (rand.nextInt(25) == 0) {
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        }
        if (rand.nextInt(5) == 0) {
            ReikaInventoryHelper.decrStack((int)7, (ItemStack[])this.inv);
        }
    }

    public int getCookScaled(int par1) {
        return par1 * this.cookTime / this.getOperationTime();
    }

    private boolean canSmelt() {
        if (this.temperature < 600) {
            return false;
        }
        if (this.inv[0] == null) {
            return false;
        }
        if (this.inv[0].func_77973_b() != Items.field_151016_H) {
            return false;
        }
        if (this.inv[7] == null) {
            return false;
        }
        if (!ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[7], (Block)Blocks.field_150354_m)) {
            return false;
        }
        for (int i = 1; i < 6; ++i) {
            if (!this.isModSteel(this.inv[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isModSteel(ItemStack is) {
        if (is == null) {
            return false;
        }
        List<ItemStack> steel = ItemStacks.getModSteels();
        for (ItemStack s : steel) {
            if (is.func_77973_b() != s.func_77973_b() || is.func_77960_j() != s.func_77960_j() && s.func_77981_g()) continue;
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot == 0) {
            return is.func_77973_b() == Items.field_151016_H;
        }
        if (slot == 7) {
            return ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150354_m);
        }
        if (slot == 6) {
            return false;
        }
        return this.isModSteel(is);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PURIFIER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temperature");
        this.cookTime = NBT.func_74762_e("time");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temperature", this.temperature);
        NBT.func_74768_a("time", this.cookTime);
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (RotaryAux.isNextToWater(world, x, y, z)) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        if (RotaryAux.isNextToFire(world, x, y, z)) {
            Tamb += 200;
        }
        if (RotaryAux.isNextToLava(world, x, y, z)) {
            Tamb += 600;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1000) {
            this.temperature = 1000;
            this.overheat(world, x, y, z);
        }
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        ReikaWorldHelper.overheat((World)world, (int)x, (int)y, (int)z, (ItemStack)ItemStacks.scrap.func_77946_l(), (int)0, (int)7, (boolean)false, (float)1.0f, (boolean)false, (boolean)true, (float)2.0f);
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    public int getRedstoneOverride() {
        if (this.inv[0] == null) {
            return 15;
        }
        if (this.inv[0].func_77973_b() != Items.field_151016_H) {
            return 0;
        }
        boolean hasModSteel = false;
        for (int i = 1; i < 6; ++i) {
            if (!this.isModSteel(this.inv[i])) continue;
            hasModSteel = true;
        }
        if (!hasModSteel) {
            return 15;
        }
        if (this.inv[6] == null) {
            return 0;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)this.inv[6], (ItemStack)ItemStacks.steelingot)) {
            return 15;
        }
        if (this.inv[6].field_77994_a >= ItemStacks.steelingot.func_77976_d()) {
            return 15;
        }
        return 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.PURIFIER.getOperationTime(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return this.canSmelt();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Invalid or Missing Items";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }
}

