/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaRedstoneHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.MagnetizationCore;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesMagnetizer;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityMagnetizer
extends InventoriedPowerReceiver
implements OneSlotMachine,
DiscreteFunction,
ConditionalOperation,
MagnetizationCore {
    private boolean[] lastPower = new boolean[3];

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return j == 0;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MAGNETIZER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        RecipesMagnetizer.MagnetizerRecipe r;
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER) {
            this.tickcount = 0;
            return;
        }
        if (this.omega < this.MINSPEED) {
            this.tickcount = 0;
            return;
        }
        if (!ReikaRedstoneHelper.isGettingACRedstone((World)world, (int)x, (int)y, (int)z, (boolean[])this.lastPower)) {
            return;
        }
        ++this.tickcount;
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (this.inv[0] != null && (r = RecipesMagnetizer.getRecipes().getRecipe(this.inv[0])) != null && this.canRunRecipe(r)) {
            this.magnetize(r);
        }
    }

    private boolean hasRecipe() {
        return this.inv[0] != null && RecipesMagnetizer.getRecipes().getRecipe(this.inv[0]) != null;
    }

    private boolean canRunRecipe(RecipesMagnetizer.MagnetizerRecipe r) {
        return this.omega >= r.minSpeed && (r.allowStacking || this.inv[0].field_77994_a == 1);
    }

    private void magnetize(RecipesMagnetizer.MagnetizerRecipe r) {
        if (rand.nextInt(r.timeFactor) > 0) {
            return;
        }
        ItemStack is = this.inv[0];
        if (r.action != null) {
            r.action.step(this.omega, this.inv[0]);
        } else if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("magnet", 1);
        } else if (is.field_77990_d.func_74764_b("magnet")) {
            int m = is.field_77990_d.func_74762_e("magnet");
            if (m < this.getMaxCharge(r)) {
                ++m;
            }
            is.field_77990_d.func_74768_a("magnet", m);
        } else {
            is.field_77990_d.func_74768_a("magnet", 1);
        }
    }

    private int getMaxCharge(RecipesMagnetizer.MagnetizerRecipe r) {
        return this.omega / r.speedPeruT;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        RecipesMagnetizer.MagnetizerRecipe rec = RecipesMagnetizer.getRecipes().getRecipe(is);
        return rec != null && (this.inv[0] == null && is.field_77994_a == 1 || rec.allowStacking);
    }

    public int getRedstoneOverride() {
        if (!this.hasRecipe()) {
            return 15;
        }
        return 0;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.MAGNETIZER.getOperationTime(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return this.hasRecipe();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Shaft Core";
    }

    @Override
    public int getCoreMagnetization() {
        return this.inv[0] != null && this.inv[0].field_77990_d != null ? this.inv[0].field_77990_d.func_74762_e("magnet") : 0;
    }
}

