/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DamagingContact;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesGrinder;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityGrinder
extends InventoriedPowerReceiver
implements PipeConnector,
IFluidHandler,
MultiOperational,
ConditionalOperation,
DamagingContact {
    public int grinderCookTime;
    public boolean idle = false;
    public static final int MAXLUBE = 4000;
    private static final int MIN_LUBE_PRODUCTION = DifficultyEffects.CANOLA.getAverageAmount();
    private final HybridTank tank = new HybridTank("grinder", 4000);
    private static final ItemHashMap<Float> grindableSeeds = new ItemHashMap();
    private static final OneWayCollections.OneWaySet<KeyedItemStack> lockedSeeds = new OneWayCollections.OneWaySet();

    public static void addGrindableSeed(ItemStack seed, float factor) {
        if (!lockedSeeds.contains((Object)seed)) {
            grindableSeeds.put(seed, (Object)Float.valueOf(MathHelper.func_76131_a((float)factor, (float)0.0f, (float)0.75f)));
        }
    }

    public static boolean isGrindableSeed(ItemStack seed) {
        return grindableSeeds.containsKey(seed);
    }

    public static Collection<ItemStack> getGrindableSeeds() {
        return grindableSeeds.keySet();
    }

    public static void removeGrindableSeed(ItemStack seed) {
        if (!lockedSeeds.contains((Object)seed)) {
            grindableSeeds.remove(seed);
        }
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    public void testIdle() {
        this.idle = !this.canGrind();
    }

    public boolean getReceptor(World world, int x, int y, int z, int metadata) {
        if (y == 0) {
            return false;
        }
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
            }
        }
        return true;
    }

    public void readPower() {
        if (!this.getReceptor(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p())) {
            return;
        }
        this.getPower(false);
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.grinderCookTime = NBT.func_74765_d("CookTime");
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74777_a("CookTime", (short)this.grinderCookTime);
        this.tank.writeToNBT(NBT);
    }

    public int getCookProgressScaled(int par1) {
        return this.grinderCookTime * par1 / 2 / this.getOperationTime();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.testIdle();
        boolean flag1 = false;
        ++this.tickcount;
        this.readPower();
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            this.grinderCookTime = 0;
            return;
        }
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            flag1 |= this.doOperation(n > 1);
        }
        if (flag1) {
            this.func_70296_d();
        }
        if (this.inv[2] != null && this.tank.getLevel() >= 1000 && !world.field_72995_K && this.inv[2].func_77973_b() == Items.field_151133_ar && this.inv[2].field_77994_a == 1) {
            this.inv[2] = ItemStacks.lubebucket.func_77946_l();
            this.tank.removeLiquid(1000);
        }
    }

    private boolean doOperation(boolean multiple) {
        if (this.canGrind()) {
            ++this.grinderCookTime;
            if (multiple || this.grinderCookTime >= this.getOperationTime()) {
                this.grinderCookTime = 0;
                this.tickcount = 0;
                this.grind();
            }
            return true;
        }
        this.grinderCookTime = 0;
        return false;
    }

    private boolean canGrind() {
        if (this.inv[0] == null) {
            return false;
        }
        boolean flag = false;
        if (TileEntityGrinder.isGrindableSeed(this.inv[0])) {
            flag = true;
            if (this.tank.getRemainingSpace() < MIN_LUBE_PRODUCTION) {
                return false;
            }
        }
        ItemStack out = RecipesGrinder.getRecipes().getGrindingResult(this.inv[0]);
        if (flag && out == null) {
            return true;
        }
        if (out == null) {
            return false;
        }
        if (this.inv[1] == null) {
            return true;
        }
        if (!this.inv[1].func_77969_a(out)) {
            return false;
        }
        return this.inv[1].field_77994_a + out.field_77994_a <= Math.min(this.func_70297_j_(), out.func_77976_d());
    }

    public int getLubricantScaled(int par1) {
        return this.tank.getLevel() * par1 / 4000;
    }

    private void grind() {
        ItemStack out;
        ItemStack is = this.inv[0];
        if (is != null && TileEntityGrinder.isGrindableSeed(is)) {
            float num = ((Float)grindableSeeds.get(is)).floatValue();
            this.tank.addLiquid((int)((float)DifficultyEffects.CANOLA.getInt() * num), FluidRegistry.getFluid((String)"rc lubricant"));
        }
        if ((out = RecipesGrinder.getRecipes().getGrindingResult(is)) != null) {
            if (this.inv[1] == null) {
                this.inv[1] = out.func_77946_l();
            } else if (this.inv[1].func_77973_b() == out.func_77973_b()) {
                this.inv[1].field_77994_a += out.field_77994_a;
            }
        }
        --is.field_77994_a;
        if (is.field_77994_a <= 0) {
            this.inv[0] = null;
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        this.phi = (float)((double)this.phi + (double)0.85f * ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.GRINDER;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot == 1) {
            return false;
        }
        if (slot == 2) {
            return is.func_77973_b() == Items.field_151133_ar;
        }
        return is.func_77973_b() == ItemRegistry.CANOLA.getItemInstance() || RecipesGrinder.getRecipes().isGrindable(is);
    }

    public int getRedstoneOverride() {
        if (!this.canGrind()) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.HOSE || m == MachineRegistry.BEDPIPE;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side != ForgeDirection.DOWN;
    }

    @Override
    public void onEMP() {
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.tank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public void setLevel(int amt) {
        this.tank.setContents(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public void removeLiquid(int amt) {
        this.tank.removeLiquid(amt);
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side != ForgeDirection.UP ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.GRINDER.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.GRINDER.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return this.canGrind();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Invalid or Missing Items";
    }

    @Override
    public int getContactDamage() {
        return 3;
    }

    @Override
    public boolean canDealDamage() {
        return this.power >= this.MINPOWER && this.torque >= this.MINTORQUE;
    }

    @Override
    public DamageSource getDamageType() {
        return RotaryCraft.grind;
    }

    static {
        grindableSeeds.put(ItemStacks.canolaSeeds, (Object)Float.valueOf(1.0f));
        lockedSeeds.add((Object)new KeyedItemStack(ItemRegistry.CANOLA.getItemInstance()).lock());
    }
}

