/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPoweredLiquidIO;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFuelConverter
extends InventoriedPoweredLiquidIO {
    public static final int CAPACITY = 5000;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FUELENHANCER;
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    public int getRedstoneOverride() {
        if (this.input.isEmpty()) {
            return 15;
        }
        if (this.output.isFull()) {
            return 15;
        }
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getPowerBelow();
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.omega < this.MINSPEED) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        Conversions c = this.getConversion();
        if (c != null && this.getInputLevel() >= c.fluidRatio * c.speedFactor && this.hasItems(c) && this.output.canTakeIn(c.speedFactor)) {
            this.input.removeLiquid(c.fluidRatio * c.speedFactor);
            this.output.addLiquid(c.speedFactor, c.output);
            this.consumeItems(c);
        }
    }

    private Conversions getConversion() {
        return !this.input.isEmpty() ? (Conversions)((Object)Conversions.conversionMap.get(this.input.getActualFluid().getName())) : null;
    }

    private boolean hasItems(Conversions c) {
        for (int i = 0; i < c.ingredients.length; ++i) {
            if (ReikaInventoryHelper.checkForItemStack((ItemMatch)c.ingredients[i], (ItemStack[])this.inv)) continue;
            return false;
        }
        return true;
    }

    private void consumeItems(Conversions c) {
        for (int i = 0; i < c.ingredients.length; ++i) {
            if (!ReikaRandomHelper.doWithChance((double)c.itemConsumptionChance)) continue;
            ReikaInventoryHelper.decrStack((int)ReikaInventoryHelper.locateInInventory((ItemMatch)c.ingredients[i], (ItemStack[])this.inv), (ItemStack[])this.inv);
        }
    }

    public int func_70302_i_() {
        return 9;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return TileEntityFuelConverter.getConversionByItem(is) != null;
    }

    public static Conversions getConversionByItem(ItemStack is) {
        for (int i = 0; i < Conversions.list.length; ++i) {
            Conversions c = Conversions.list[i];
            if (!c.isValidItem(is)) continue;
            return c;
        }
        return null;
    }

    public double getLiquidModelOffset(boolean in) {
        return in ? 0.625 : 0.0625;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m.isStandardPipe();
    }

    public Fluid getInputFluidType() {
        return this.input.getActualFluid();
    }

    public Fluid getOutputFluidType() {
        return this.output.getActualFluid();
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return Conversions.conversionMap.get(f.getName()) != null;
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to.offsetY == 0;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from == ForgeDirection.UP;
    }

    @Override
    public int getCapacity() {
        return 5000;
    }

    @Override
    public boolean canIntakeFromPipe(MachineRegistry p) {
        return p.isStandardPipe();
    }

    @Override
    public boolean canOutputToPipe(MachineRegistry p) {
        return p == MachineRegistry.FUELLINE;
    }

    public static enum Conversions {
        BCFUEL("fuel", "rc jet fuel", 2, 4, (double)DifficultyEffects.CONSUMEFRAC.getChance() / 32.0 / 100.0 * 8.0, new ItemMatch(Items.field_151065_br), new ItemMatch(ItemStacks.netherrackdust), new ItemMatch(ItemStacks.tar), new ItemMatch(Items.field_151064_bs));

        public final Fluid input;
        public final Fluid output;
        public final int speedFactor;
        public final int fluidRatio;
        public final double itemConsumptionChance;
        private final ItemMatch[] ingredients;
        private static final HashMap<String, Conversions> conversionMap;
        private static final HashMap<String, Conversions> conversionOutputMap;
        public static Conversions[] list;

        private Conversions(String in, String out, int sp, int r, double f, ItemMatch ... items) {
            this.input = FluidRegistry.getFluid((String)in);
            this.output = FluidRegistry.getFluid((String)out);
            this.speedFactor = sp;
            this.fluidRatio = r;
            this.itemConsumptionChance = f;
            this.ingredients = items;
        }

        public boolean isValid() {
            return this.input != null && this.output != null;
        }

        public boolean isValidItem(ItemStack is) {
            for (int i = 0; i < this.ingredients.length; ++i) {
                if (!this.ingredients[i].match(is)) continue;
                return true;
            }
            return false;
        }

        public static void addRecipe(String name, String in, String out, int speed, int fluidRatio, double itemConsumeChance, ItemMatch ... items) {
            Conversions c = (Conversions)EnumHelper.addEnum(Conversions.class, (String)name.toUpperCase(), (Class[])new Class[]{String.class, String.class, Integer.TYPE, Integer.TYPE, Double.TYPE, ItemMatch[].class}, (Object[])new Object[]{in, out, speed, fluidRatio, itemConsumeChance, items});
            conversionMap.put(in, c);
            conversionOutputMap.put(out, c);
            list = Conversions.values();
        }

        public static Collection<Conversions> getByInput(ItemStack is) {
            ArrayList<Conversions> li = new ArrayList<Conversions>();
            for (Conversions c : conversionMap.values()) {
                if (!c.isValidItem(is)) continue;
                li.add(c);
            }
            return li;
        }

        public static Collection<Conversions> getByInput(Fluid f) {
            ArrayList<Conversions> li = new ArrayList<Conversions>();
            for (Conversions c : conversionMap.values()) {
                if (c.input != f) continue;
                li.add(c);
            }
            return li;
        }

        public static Collection<Conversions> getByOutput(Fluid f) {
            ArrayList<Conversions> li = new ArrayList<Conversions>();
            for (Conversions c : conversionMap.values()) {
                if (c.output != f) continue;
                li.add(c);
            }
            return li;
        }

        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getIngredientsForDisplay() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (ItemMatch m : this.ingredients) {
                c.add(m.getCycledItem());
            }
            return c;
        }

        static {
            conversionMap = new HashMap();
            conversionOutputMap = new HashMap();
            list = Conversions.values();
            for (int i = 0; i < list.length; ++i) {
                Conversions c = list[i];
                if (c.input == null || c.output == null) continue;
                conversionMap.put(c.input.getName(), c);
                conversionOutputMap.put(c.output.getName(), c);
            }
        }
    }
}

