/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCrystallizer;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCrystallizer
extends InventoriedPowerLiquidReceiver
implements TemperatureTE,
MultiOperational,
ConditionalOperation {
    private StepTimer timer = new StepTimer(400);
    private StepTimer tempTimer = new StepTimer(20);
    private StepTimer sound = new StepTimer(45);
    private int temperature;
    public int freezeTick;

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        this.timer.setCap(this.getOperationTime());
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (!this.field_145850_b.field_72995_K) {
            int n = this.getNumberConsecutiveOperations();
            for (int i = 0; i < n; ++i) {
                this.doOperation(n > 1);
            }
            this.freezeTick = this.timer.getTick();
        }
        this.sound.update();
        if (this.omega > 0 && this.sound.checkCap()) {
            SoundRegistry.FAN.playSoundAtBlock(world, x, y, z, RotaryAux.isMuffled((TileEntity)this) ? 0.1f : 0.4f, 0.6f);
        }
    }

    private void doOperation(boolean multiple) {
        if (!this.tank.isEmpty()) {
            ItemStack toMake = RecipesCrystallizer.getRecipes().getFreezingResult(this.tank.getFluid());
            if (this.canOperate(toMake)) {
                this.timer.update();
                if (multiple || this.timer.checkCap()) {
                    this.make(toMake);
                }
            } else {
                this.timer.reset();
            }
        } else {
            this.timer.reset();
        }
    }

    private void make(ItemStack toMake) {
        ReikaInventoryHelper.addOrSetStack((ItemStack)toMake, (ItemStack[])this.inv, (int)0);
        int amt = RecipesCrystallizer.getRecipes().getRecipeConsumption(toMake);
        this.tank.removeLiquid(amt);
    }

    private boolean canOperate(ItemStack toMake) {
        if (toMake == null) {
            return false;
        }
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            return false;
        }
        if (this.temperature > this.getFreezingPoint()) {
            return false;
        }
        if (this.inv[0] == null) {
            return true;
        }
        return ReikaItemHelper.areStacksCombinable((ItemStack)toMake, (ItemStack)this.inv[0], (int)this.func_70297_j_());
    }

    public int getFreezingPoint() {
        return !this.tank.isEmpty() ? TileEntityCrystallizer.getFreezingPoint(this.tank.getFluid()) : 0;
    }

    public static int getFreezingPoint(FluidStack fs) {
        return -273 + (int)(0.9 * (double)fs.getFluid().getTemperature(fs));
    }

    public int getProgressScaled(int s) {
        return s * this.freezeTick / this.timer.getCap();
    }

    public int getLiquidScaled(int s) {
        return s * this.tank.getLevel() / this.tank.getCapacity();
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 1 && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ItemStacks.dryice);
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return RecipesCrystallizer.getRecipes().isValidFluid(f);
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 8000;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.CRYSTALLIZER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE) != null) {
            Tamb -= 5;
        }
        if (RotaryAux.isNextToWater(world, x, y, z)) {
            Tamb -= 15;
        }
        if (RotaryAux.isNextToIce(world, x, y, z)) {
            Tamb -= 30;
        }
        ItemStack cryo = GameRegistry.findItemStack((String)ModList.THERMALFOUNDATION.modLabel, (String)"dustCryotheum", (int)1);
        if ((ReikaItemHelper.matchStacks((ItemStack)ItemStacks.dryice, (ItemStack)this.inv[1]) || cryo != null && ReikaItemHelper.matchStacks((ItemStack)cryo, (ItemStack)this.inv[1])) && (this.temperature > (Tamb -= 40) + 4 || rand.nextInt(20) == 0)) {
            ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
        }
        int dT = Tamb - this.temperature;
        this.temperature = (int)((float)this.temperature + (Math.abs(dT) < 4 ? Math.signum(dT) : (float)(dT / 4)));
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.CRYSTALLIZER.getOperationTime(Math.max(0, this.omega - this.MINSPEED));
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.CRYSTALLIZER.getNumberOperations(Math.max(0, this.omega - this.MINSPEED));
    }

    @Override
    public boolean areConditionsMet() {
        return !this.tank.isEmpty();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Liquid";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowExternalHeating() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }
}

