/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Piping;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PumpablePipe;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityPipe
extends TileEntityPiping
implements TemperatureTE,
PumpablePipe {
    private Fluid liquid;
    private int liquidLevel = 0;
    private int temperature;
    public static final int HORIZLOSS = 0;
    public static final int UPLOSS = 0;
    public static final int DOWNLOSS = 0;

    @Override
    public final void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.contains(FluidRegistry.getFluid((String)"uranium hexafluoride")) || this.contains(FluidRegistry.getFluid((String)"hydrofluoric acid"))) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
                if (!m.isStandardPipe()) continue;
                TileEntityPipe p = (TileEntityPipe)world.func_147438_o(dx, dy, dz);
                p.setFluid(this.liquid);
                p.addFluid(5);
            }
            world.func_147468_f(x, y, z);
            ReikaParticleHelper.SMOKE.spawnAroundBlock(world, x, y, z, 8);
        }
        if (rand.nextInt(60) == 0) {
            ReikaWorldHelper.temperatureEnvironment((World)world, (int)x, (int)y, (int)z, (int)this.getTemperature());
        }
        if (this.liquid != null) {
            int temp = this.liquid.getTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int n = this.temperature = temp > 750 ? temp - 425 : temp - 273;
            if (this.temperature > this.getMaxTemperature()) {
                this.overheat(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.temperature = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        }
    }

    @Override
    public int getMaxTemperature() {
        return 2500;
    }

    @Override
    protected void onIntake(TileEntity te) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PIPE;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.BEDPIPE || m.isStandardPipe() || m == MachineRegistry.VALVE || m == MachineRegistry.SPILLER || m == MachineRegistry.SEPARATION || m == MachineRegistry.BYPASS || m == MachineRegistry.SUCTION;
    }

    @Override
    public IIcon getBlockIcon() {
        return BlockRegistry.DECO.getBlockInstance().func_149691_a(0, 0);
    }

    @Override
    public boolean hasLiquid() {
        return this.liquid != null && this.liquidLevel > 0;
    }

    @Override
    public Fluid getFluidType() {
        return this.liquid;
    }

    public boolean contains(Fluid f) {
        return f != null && f.equals(this.liquid);
    }

    @Override
    public void setFluid(Fluid f) {
        this.liquid = f;
    }

    @Override
    public int getFluidLevel() {
        return this.liquidLevel;
    }

    @Override
    protected void setLevel(int amt) {
        this.liquidLevel = amt;
    }

    @Override
    protected boolean interactsWithMachines() {
        return true;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc lubricant"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"bioethanol"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"fuel"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rocket fuel"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc co2"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc hot co2"))) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"chlorine"))) {
            return false;
        }
        return !f.equals(FluidRegistry.getFluid((String)"rc oxygen"));
    }

    @Override
    public boolean canReceiveFromPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean canEmitToPipeOn(ForgeDirection side) {
        return true;
    }

    @Override
    public Block getPipeBlockType() {
        return BlockRegistry.DECO.getBlockInstance();
    }

    @Override
    public boolean canIntakeFromIFluidHandler(ForgeDirection side) {
        return side.offsetY != 0;
    }

    @Override
    public boolean canOutputToIFluidHandler(ForgeDirection side) {
        return side.offsetY == 0;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return this.getTemperature() >= 100 ? this.getTemperature() / 400 : 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        MachineRegistry m = this.getMachine();
        blocks.recursiveAddWithMetadata((IBlockAccess)world, x, y, z, m.getBlock(), m.getBlockMetadata());
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (String)"random.fizz", (float)0.4f, (float)1.0f);
            ReikaParticleHelper.LAVA.spawnAroundBlock(world, c.xCoord, c.yCoord, c.zCoord, 36);
            c.setBlock(world, (Block)Blocks.field_150356_k);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public final void setTemperature(int temp) {
        this.temperature = temp;
    }
}

