/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.ChromatiCraft.API.TreeGetter;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.TreeReader;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.Auxiliary.Interfaces.Cleanable;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DamagingContact;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class TileEntityWoodcutter
extends InventoriedPowerReceiver
implements EnchantableMachine,
InertIInv,
DiscreteFunction,
ConditionalOperation,
DamagingContact,
Cleanable,
MultiOperational {
    private HashMap<Enchantment, Integer> enchantments = new HashMap();
    public int editx;
    public int edity;
    public int editz;
    public double dropx;
    public double dropz;
    public boolean varyx;
    public boolean varyz;
    public int stepx;
    public int stepz;
    private TreeReader tree = new TreeReader();
    private TreeReader treeCopy = new TreeReader();
    private boolean cuttingTree;
    private Comparator<Coordinate> leafPriority;
    private static final int MAX_JAM = 20;
    private int jam = 0;
    private int jamColor = -1;

    public int getJamColor() {
        return this.jamColor;
    }

    @Override
    public void clean() {
        --this.jam;
        if (this.jam <= 0) {
            this.jam = 0;
            this.jamColor = -1;
        }
    }

    public boolean isJammed() {
        return this.jam > 20;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.leafPriority = new LeafPrioritizer(world);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        Block b;
        int i;
        super.updateTileEntity();
        ++this.tickcount;
        this.tree.setWorld(world);
        this.treeCopy.setWorld(world);
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if (this.isJammed()) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (this.tree.isEmpty() && this.hasWood()) {
            this.tree.reset();
            ReikaTreeHelper type = ReikaTreeHelper.getTree((Block)world.func_147439_a(this.editx, this.edity, this.editz), (int)world.func_72805_g(this.editx, this.edity, this.editz));
            if (type == null) {
                type = ModWoodList.getModWood((Block)world.func_147439_a(this.editx, this.edity, this.editz), (int)world.func_72805_g(this.editx, this.edity, this.editz));
            }
            if (type != null) {
                this.tree.setTree((TreeType)type);
                for (i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        this.tree.addTree(world, this.editx + i, this.edity, this.editz + j);
                    }
                }
            }
            if (!this.tree.isEmpty()) {
                this.cuttingTree = true;
            }
            this.checkAndMatchInventory();
            this.tree.sortBlocksByHeight(false);
            this.tree.reverseBlockOrder();
            this.tree.sortBlocksByDistance(new Coordinate((TileEntity)this));
            this.tree.sort(this.leafPriority);
            this.treeCopy = (TreeReader)this.tree.copy();
        }
        if ((b = world.func_147439_a(x, y + 1, z)) != Blocks.field_150350_a && (b.func_149688_o() == Material.field_151575_d || b.func_149688_o() == Material.field_151584_j)) {
            ReikaItemHelper.dropItems((World)world, (double)this.dropx, (double)((double)y - 0.25), (double)this.dropz, this.getDrops(world, x, y + 1, z, b, world.func_72805_g(x, y, z)));
            world.func_147468_f(x, y + 1, z);
        }
        if (this.tree.isEmpty()) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (!this.cuttingTree && !this.tree.isValidTree()) {
            this.tree.reset();
            this.tree.clear();
            return;
        }
        for (i = 0; i < this.getNumberConsecutiveOperations(); ++i) {
            Coordinate c = this.tree.getNextAndMoveOn();
            this.cutCoord(world, x, y, z, c);
            if (this.tree.isEmpty()) break;
        }
    }

    private void cutCoord(World world, int x, int y, int z, Coordinate c) {
        Block drop = c.getBlock(world);
        int dropmeta = c.getBlockMetadata(world);
        if (drop != Blocks.field_150350_a) {
            Material mat = ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord);
            if (ConfigRegistry.INSTACUT.getState()) {
                this.cutBlock(world, x, y, z, c, mat);
                if (c.yCoord == this.edity && drop == this.tree.getTreeType().getLogID()) {
                    ItemStack plant;
                    Block idbelow = world.func_147439_a(c.xCoord, c.yCoord - 1, c.zCoord);
                    Block root = TwilightForestHandler.BlockEntry.ROOT.getBlock();
                    if (ReikaPlantHelper.SAPLING.canPlantAt(world, c.xCoord, c.yCoord, c.zCoord)) {
                        ItemStack plant2 = this.getPlantedSapling();
                        if (plant2 != null) {
                            if (this.inv[0] != null && !this.hasEnchantment(Enchantment.field_77342_w)) {
                                ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                            }
                            ReikaWorldHelper.setBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (ItemStack)plant2);
                        }
                    } else if (this.tree.getTreeType() == ModWoodList.TIMEWOOD && (idbelow == root || idbelow == Blocks.field_150350_a) && (plant = this.getPlantedSapling()) != null) {
                        if (this.inv[0] != null && !this.hasEnchantment(Enchantment.field_77342_w)) {
                            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                        }
                        world.func_147449_b(c.xCoord, c.yCoord - 1, c.zCoord, Blocks.field_150346_d);
                        ReikaWorldHelper.setBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (ItemStack)plant);
                    }
                }
            } else {
                boolean fall = BlockSand.func_149831_e((World)world, (int)c.xCoord, (int)(c.yCoord - 1), (int)c.zCoord);
                if (fall) {
                    EntityFallingBlock e = new EntityFallingBlock(world, (double)c.xCoord + 0.5, (double)c.yCoord + 0.65, (double)c.zCoord + 0.5, drop, dropmeta);
                    e.field_145812_b = -5000;
                    if (!world.field_72995_K) {
                        world.func_72838_d((Entity)e);
                    }
                    c.setBlock(world, Blocks.field_150350_a);
                } else {
                    this.cutBlock(world, x, y, z, c, mat);
                    if (c.yCoord == this.edity) {
                        ItemStack plant;
                        Block idbelow = world.func_147439_a(c.xCoord, c.yCoord - 1, c.zCoord);
                        Block root = TwilightForestHandler.BlockEntry.ROOT.getBlock();
                        if (ReikaPlantHelper.SAPLING.canPlantAt(world, c.xCoord, c.yCoord, c.zCoord)) {
                            ItemStack plant3 = this.getPlantedSapling();
                            if (plant3 != null) {
                                if (this.inv[0] != null && !this.hasEnchantment(Enchantment.field_77342_w)) {
                                    ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                                }
                                ReikaWorldHelper.setBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (ItemStack)plant3);
                            }
                        } else if (this.tree.getTreeType() == ModWoodList.TIMEWOOD && (idbelow == root || idbelow == Blocks.field_150350_a) && (plant = this.getPlantedSapling()) != null) {
                            if (this.inv[0] != null && !this.hasEnchantment(Enchantment.field_77342_w)) {
                                ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                            }
                            world.func_147449_b(c.xCoord, c.yCoord - 1, c.zCoord, Blocks.field_150346_d);
                            ReikaWorldHelper.setBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (ItemStack)plant);
                        }
                    }
                }
            }
        }
    }

    private void cutBlock(World world, int x, int y, int z, Coordinate c, Material mat) {
        this.dropBlocks(world, c.xCoord, c.yCoord, c.zCoord);
        c.setBlock(world, Blocks.field_150350_a);
        if (mat == Material.field_151584_j) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "dig.grass", 0.5f + rand.nextFloat() * 0.5f, 1.0f);
        } else {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "dig.wood", 0.5f + rand.nextFloat() * 0.5f, 1.0f);
        }
        if (this.tree.getTreeType() == ModWoodList.SLIME && c.getBlock(world) == this.tree.getTreeType().getLogID()) {
            ++this.jam;
            this.jamColor = 0xFF000000 | ReikaColorAPI.mixColors((int)ModWoodList.SLIME.logColor, (int)0xFFFFFF, (float)((float)this.jam / 20.0f));
        }
    }

    private Collection<ItemStack> getDrops(World world, int x, int y, int z, Block b, int meta) {
        float f = this.getYield(b, meta);
        if (ReikaRandomHelper.doWithChance((double)f)) {
            int fortune = this.getEnchantment(Enchantment.field_77346_s);
            ArrayList ret = b.getDrops(world, x, y, z, meta, fortune);
            MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.HarvestDropsEvent(x, y, z, world, b, meta, fortune, 1.0f, ret, this.getPlacer(), false));
            if (this.tree.getTreeType() == ModWoodList.SLIME) {
                Block log = this.tree.getTreeType().getLogID();
                if (b == log) {
                    ret.clear();
                    ret.add(new ItemStack(Items.field_151123_aH));
                }
            } else if (this.tree.getTreeType() == ReikaTreeHelper.OAK || this.tree.isDyeTree()) {
                int n = 0;
                if (fortune >= 5) {
                    n = 4;
                } else if (fortune >= 3) {
                    n = 6;
                } else if (fortune >= 2) {
                    n = 10;
                } else if (fortune >= 1) {
                    n = 20;
                }
                if (n > 0 && rand.nextInt(n) == 0) {
                    ret.add(new ItemStack(Items.field_151034_e));
                }
            }
            return ret;
        }
        return new ArrayList<ItemStack>();
    }

    private float getYield(Block b, int meta) {
        Block log;
        if (this.tree.getTreeType() == ModWoodList.SLIME && b == (log = this.tree.getTreeType().getLogID())) {
            return 0.6f;
        }
        return 1.0f;
    }

    private void checkAndMatchInventory() {
        ItemStack sapling = null;
        if (this.tree.isDyeTree()) {
            sapling = new ItemStack(TreeGetter.getSaplingID(), 1, this.tree.getDyeTreeMeta());
        } else if (this.tree.getTreeType() != null) {
            sapling = this.tree.getSapling();
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)sapling)) {
            this.dumpInventory();
        }
    }

    private void dropBlocks(World world, int x, int y, int z) {
        Block drop = world.func_147439_a(x, y, z);
        if (drop == Blocks.field_150350_a) {
            return;
        }
        int dropmeta = world.func_72805_g(x, y, z);
        ItemStack sapling = this.tree.getSapling();
        Block logID = this.tree.getTreeType().getLogID();
        Collection<ItemStack> drops = this.getDrops(world, x, y, z, drop, dropmeta);
        if (drop == logID && logID != null && this.tree.getTreeType() != ModWoodList.SLIME && rand.nextInt(3) == 0) {
            drops.add(ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.sawdust.func_77946_l(), (int)(1 + rand.nextInt(4))));
        }
        for (ItemStack todrop : drops) {
            if (ReikaItemHelper.matchStacks((ItemStack)todrop, (ItemStack)sapling)) {
                if (this.inv[0] != null && this.inv[0].field_77994_a >= this.inv[0].func_77976_d()) {
                    if (this.chestCheck(todrop)) continue;
                    ReikaItemHelper.dropItem((World)world, (double)this.dropx, (double)((double)this.field_145848_d - 0.25), (double)this.dropz, (ItemStack)todrop);
                    continue;
                }
                ReikaInventoryHelper.addOrSetStack((ItemStack)todrop, (ItemStack[])this.inv, (int)0);
                continue;
            }
            if (this.chestCheck(todrop)) continue;
            ReikaItemHelper.dropItem((World)world, (double)this.dropx, (double)((double)this.field_145848_d - 0.25), (double)this.dropz, (ItemStack)todrop);
        }
    }

    private boolean chestCheck(ItemStack is) {
        IInventory ii;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return te instanceof IInventory && ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)(ii = (IInventory)te));
    }

    private void dumpInventory() {
        if (this.inv[0] == null) {
            return;
        }
        ItemStack is = this.inv[0].func_77946_l();
        this.inv[0] = null;
        this.chestCheck(is);
    }

    public ItemStack getPlantedSapling() {
        if (!this.shouldPlantSapling()) {
            return null;
        }
        if (this.treeCopy.isDyeTree()) {
            return new ItemStack(TreeGetter.getSaplingID(), 1, this.treeCopy.getDyeTreeMeta());
        }
        if (this.treeCopy.isRainbowTree()) {
            return new ItemStack(TreeGetter.getRainbowSaplingID());
        }
        if (this.treeCopy.getTreeType() != null) {
            return this.treeCopy.getSapling();
        }
        return null;
    }

    private boolean shouldPlantSapling() {
        if (this.hasEnchantment(Enchantment.field_77342_w)) {
            return true;
        }
        if (this.treeCopy.isDyeTree()) {
            return this.inv[0] != null && this.inv[0].field_77994_a > 0 && Block.func_149634_a((Item)this.inv[0].func_77973_b()) == TreeGetter.getSaplingID();
        }
        if (this.treeCopy.getTreeType() != null) {
            return this.inv[0] != null && this.inv[0].field_77994_a > 0 && ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)this.treeCopy.getSapling());
        }
        return false;
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 0: {
                this.read = ForgeDirection.EAST;
                this.editx = x - 1;
                this.edity = y;
                this.editz = z;
                this.dropx = (double)(x + 1) + 0.125;
                this.dropz = (double)z + 0.5;
                this.stepx = 1;
                this.stepz = 0;
                this.varyx = false;
                this.varyz = true;
                break;
            }
            case 1: {
                this.read = ForgeDirection.WEST;
                this.editx = x + 1;
                this.edity = y;
                this.editz = z;
                this.dropx = (double)x - 0.125;
                this.dropz = (double)z + 0.5;
                this.stepx = -1;
                this.stepz = 0;
                this.varyx = false;
                this.varyz = true;
                break;
            }
            case 2: {
                this.read = ForgeDirection.SOUTH;
                this.editx = x;
                this.edity = y;
                this.editz = z - 1;
                this.dropx = (double)x + 0.5;
                this.dropz = (double)(z + 1) + 0.125;
                this.stepx = 0;
                this.stepz = 1;
                this.varyx = true;
                this.varyz = false;
                break;
            }
            case 3: {
                this.read = ForgeDirection.NORTH;
                this.editx = x;
                this.edity = y;
                this.editz = z + 1;
                this.dropx = (double)x + 0.5;
                this.dropz = (double)z - 0.125;
                this.stepx = 0;
                this.stepz = -1;
                this.varyx = true;
                this.varyz = false;
            }
        }
        this.dropx = (double)x + 0.5;
        this.dropz = (double)z + 0.5;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE || this.isJammed()) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.WOODCUTTER;
    }

    public int getRedstoneOverride() {
        if (!this.hasWood()) {
            return 15;
        }
        return 0;
    }

    private boolean hasWood() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Block id = this.field_145850_b.func_147439_a(this.editx + i, this.edity, this.editz + j);
                int meta = this.field_145850_b.func_72805_g(this.editx + i, this.edity, this.editz + j);
                if (id == Blocks.field_150364_r || id == Blocks.field_150363_s) {
                    return true;
                }
                ModWoodList wood = ModWoodList.getModWood((Block)id, (int)meta);
                if (wood == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean applyEnchants(ItemStack is) {
        boolean accepted = false;
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77346_s, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77346_s, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77342_w, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77342_w, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77342_w, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77349_p, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77349_p, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77349_p, (ItemStack)is));
            accepted = true;
        }
        return accepted;
    }

    @Override
    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77346_s);
        li.add(Enchantment.field_77342_w);
        li.add(Enchantment.field_77349_p);
        return li;
    }

    @Override
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantments().containsKey(e);
    }

    @Override
    public boolean hasEnchantments() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null || this.getEnchantment(Enchantment.field_77331_b[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantment(Enchantment e) {
        if (!this.hasEnchantment(e)) {
            return 0;
        }
        return this.getEnchantments().get(e);
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("jam", this.jam);
        NBT.func_74768_a("jamc", this.jamColor);
        NBT.func_74757_a("cutting", this.cuttingTree);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.jam = NBT.func_74762_e("jam");
        this.jamColor = NBT.func_74762_e("jamc");
        this.cuttingTree = NBT.func_74767_n("cutting");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            int lvl;
            if (Enchantment.field_77331_b[i] == null || (lvl = this.getEnchantment(Enchantment.field_77331_b[i])) <= 0) continue;
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.enchantments = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a());
            this.enchantments.put(Enchantment.field_77331_b[i], lvl);
        }
    }

    @Override
    public void onEMP() {
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    @Override
    public int getOperationTime() {
        if (ConfigRegistry.INSTACUT.getState()) {
            int base = DurationRegistry.WOODCUTTER.getOperationTime(this.omega);
            float ench = ReikaEnchantmentHelper.getEfficiencyMultiplier((int)this.getEnchantment(Enchantment.field_77349_p));
            return (int)((float)base / ench);
        }
        return 0;
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.WOODCUTTER.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return this.hasWood();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Tree";
    }

    @Override
    public int getContactDamage() {
        return 4;
    }

    @Override
    public boolean canDealDamage() {
        return this.power >= this.MINPOWER && this.torque >= this.MINTORQUE;
    }

    @Override
    public DamageSource getDamageType() {
        return RotaryCraft.grind;
    }

    private static class LeafPrioritizer
    extends BlockArray.BlockTypePrioritizer {
        private LeafPrioritizer(World world) {
            super(world);
        }

        protected int compare(BlockKey b1, BlockKey b2) {
            boolean l1 = this.isLeaf(b1);
            boolean l2 = this.isLeaf(b2);
            if (l1 && l2) {
                return 0;
            }
            if (l1) {
                return -1;
            }
            if (l2) {
                return 1;
            }
            return 0;
        }

        private boolean isLeaf(BlockKey bk) {
            if (bk.blockID.func_149688_o() == Material.field_151584_j) {
                return true;
            }
            if (bk.blockID == Blocks.field_150362_t || bk.blockID == Blocks.field_150361_u) {
                return true;
            }
            return ModWoodList.isModLeaf((Block)bk.blockID, (int)bk.metadata);
        }
    }
}

