/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.RotaryCraft.Auxiliary.Interfaces.Cleanable;
import Reika.RotaryCraft.Base.TileEntity.SprinklerBlock;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLawnSprinkler
extends SprinklerBlock {
    private static int[] GROWTH_PATTERN = new int[]{8, 5, 3, 1, 1};
    private static WeightedRandom<Integer> radiusRandom = new WeightedRandom();
    private int speed;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void doAnimations() {
        if (this.field_145850_b.field_72995_K) {
            if (this.canPerformEffects()) {
                if (this.speed < 24) {
                    ++this.speed;
                }
            } else if (this.speed > 0) {
                --this.speed;
            }
        }
        this.phi += (float)this.speed;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.LAWNSPRINKLER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void performEffects(World world, int x, int y, int z) {
        RotaryAchievements.SPRINKLER.triggerAchievement(this.getPlacer());
        if (!world.field_72995_K) {
            for (int k = 0; k < 3; ++k) {
                this.accelerateGrowth(world, x, y, z);
                this.extinguishFire(world, x, y, z);
            }
            if (this.getPressure() > 3000) {
                this.washMachines(world, x, y, z);
            }
            if (ModList.REACTORCRAFT.isLoaded() && rand.nextInt(2400) == 0) {
                this.clearRadiation(world, x, y, z);
            }
            if (this.getPressure() > 300000) {
                this.damageMobs(world, x, y, z);
            }
        }
        this.spreadWater(world, x, y, z);
    }

    @DependentMethodStripper.ModDependent(value=ModList.REACTORCRAFT)
    private void clearRadiation(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d(0.0, 2.0, 0.0).func_72314_b((double)r, 2.0, (double)r);
        List li = world.func_72872_a(EntityRadiation.class, box);
        for (EntityRadiation e : li) {
            e.clean();
            if (!rand.nextBoolean()) continue;
            break;
        }
    }

    private void washMachines(World world, int x, int y, int z) {
        int r = this.getRange();
        int n = 3;
        for (int c = 0; c < n; ++c) {
            int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
            int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
            for (int i = y; i > y - 4; --i) {
                int meta;
                Block id = world.func_147439_a(rx, i, rz);
                MachineRegistry m = MachineRegistry.getMachineFromIDandMetadata(id, meta = world.func_72805_g(rx, i, rz));
                if (m != null) {
                    TileEntity te = world.func_147438_o(rx, i, rz);
                    if (!(te instanceof Cleanable)) continue;
                    ((Cleanable)te).clean();
                    continue;
                }
                if (id == Blocks.field_150350_a || !id.func_149662_c()) continue;
                i = -999;
            }
        }
    }

    private void extinguishFire(World world, int x, int y, int z) {
        int r = this.getRange();
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
        int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
        for (int i = y; i > y - 4; --i) {
            Block id = world.func_147439_a(rx, i, rz);
            if (id == Blocks.field_150480_ab) {
                Block id2 = world.func_147439_a(rx, i - 1, rz);
                if (id2 == Blocks.field_150424_aL) continue;
                world.func_147468_f(rx, i, rz);
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)rx, (int)i, (int)rz, (String)"random.fizz");
                continue;
            }
            if (id == Blocks.field_150350_a || !id.func_149662_c()) continue;
            i = -999;
        }
    }

    private void accelerateGrowth(World world, int x, int y, int z) {
        int r = this.calcRange();
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
        int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
        for (int i = y; i > y - 4; --i) {
            Block id = world.func_147439_a(rx, i, rz);
            int meta = world.func_72805_g(rx, i, rz);
            if (id == Blocks.field_150458_ak) {
                ReikaWorldHelper.hydrateFarmland((World)world, (int)rx, (int)i, (int)rz, (boolean)false);
                i = -999;
                continue;
            }
            if (id != Blocks.field_150350_a && id.func_149662_c()) {
                i = -999;
                continue;
            }
            if (rand.nextInt(8) != 0) continue;
            ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)id);
            ModCropList modcrop = ModCropList.getModCrop((Block)id, (int)meta);
            if (crop != null && !crop.isRipe(meta)) {
                world.func_72921_c(rx, i, rz, meta + 1, 3);
                continue;
            }
            if (modcrop != null && !modcrop.isRipe(world, rx, i, rz)) {
                id.func_149674_a(world, rx, i, rz, rand);
                BlockTickEvent.fire((World)world, (int)rx, (int)i, (int)rz, (Block)id, (int)BlockTickEvent.UpdateFlags.FORCED.flag);
                world.func_147471_g(rx, i, rz);
                continue;
            }
            if (!this.shouldTick(world, x, y, z, id)) continue;
            id.func_149674_a(world, rx, i, rz, rand);
        }
    }

    private boolean shouldTick(World world, int x, int y, int z, Block id) {
        ReikaPlantHelper p = ReikaPlantHelper.getPlant((Block)id);
        return p != null && p.grows();
    }

    private int calcRange() {
        int r = (Integer)radiusRandom.getRandomEntry();
        if (r == -1) {
            r = this.getMaxRange();
        }
        return r;
    }

    private void damageMobs(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d(0.0, 1.0, 0.0).func_72314_b((double)r, 1.0, (double)r);
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            e.func_70097_a(DamageSource.field_76377_j, 0.5f);
        }
    }

    private void spreadWater(World world, int x, int y, int z) {
        int i;
        int d = Math.max(0, ConfigRegistry.SPRINKLER.getValue());
        double ypos = (double)y + 0.125;
        double r = (double)this.getRange() / 10.0;
        double py = (double)y - 0.1875 + 0.5;
        for (i = 0; i < rand.nextInt(1 + d); ++i) {
            double px = (float)(x - 1) + 2.0f * rand.nextFloat();
            double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
            world.func_72869_a("splash", px + 0.5, py, pz + 0.5, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 3; ++i) {
            this.createWaterStream(world, x, y, z, i * 120 + 60);
        }
    }

    private void createWaterStream(World world, int x, int y, int z, float offset) {
        int d = Math.max(0, ConfigRegistry.SPRINKLER.getValue());
        int r = this.getRange();
        double dx = 0.6 * Math.sin(Math.toRadians(this.phi + offset));
        double dz = 0.6 * Math.cos(Math.toRadians(this.phi + offset));
        for (int i = 0; i < 6 * d; ++i) {
            double v = (double)rand.nextInt((1 + r) * 10) / 72.0;
            world.func_72869_a("splash", (double)x + 0.5 + dx, (double)y + 0.75, (double)z + 0.5 + dz, dx * v - 0.025 + 0.05 * rand.nextDouble(), 0.0, dz * v - 0.025 + 0.05 * rand.nextDouble());
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    @Override
    public int getCapacity() {
        return 5;
    }

    @Override
    public int getWaterConsumption() {
        return 1;
    }

    @Override
    public ForgeDirection getPipeDirection() {
        return ForgeDirection.DOWN;
    }

    static {
        for (int i = 0; i < GROWTH_PATTERN.length - 1; ++i) {
            radiusRandom.addEntry((Object)(i + 1), (double)GROWTH_PATTERN[i]);
        }
        radiusRandom.addEntry((Object)-1, (double)GROWTH_PATTERN[GROWTH_PATTERN.length - 1]);
    }
}

