/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWindEngine
extends TileEntityEngine {
    private WindClearanceCheck clearance;

    private void dealBladeDamage(World world, int x, int y, int z, int meta) {
        int c = 0;
        int d = 0;
        boolean a = false;
        boolean b = false;
        if (meta < 2) {
            b = true;
        } else {
            a = true;
        }
        switch (meta) {
            case 0: {
                c = 1;
                break;
            }
            case 1: {
                c = -1;
                break;
            }
            case 2: {
                d = 1;
                break;
            }
            case 3: {
                d = -1;
            }
        }
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x + c), (double)y, (double)(z + d), (double)(x + 1 + c), (double)(y + 1), (double)(z + 1 + d)).func_72314_b((double)a, 1.0, (double)b);
        List in = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : in) {
            ent.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    @Override
    protected void consumeFuel() {
    }

    @Override
    protected void internalizeFuel() {
    }

    private float getWindFactor(World world, int x, int y, int z, int meta) {
        if (this.clearance == null) {
            this.clearance = new WindClearanceCheck(this, 32, 3);
        }
        this.clearance.tick(world);
        float f = 1.0f - this.clearance.getPenalty();
        if (InterfaceCache.IGALACTICWORLD.instanceOf((Object)world.field_73011_w)) {
            IGalacticraftWorldProvider ig = (IGalacticraftWorldProvider)world.field_73011_w;
            f *= ig.getWindLevel();
        }
        return Math.min(1.0f, f);
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        int c = 0;
        int d = 0;
        int a = 0;
        int b = 0;
        if (meta < 2) {
            b = 1;
        } else {
            a = 1;
        }
        switch (meta) {
            case 0: {
                c = 1;
                break;
            }
            case 1: {
                c = -1;
                break;
            }
            case 2: {
                d = 1;
                break;
            }
            case 3: {
                d = -1;
            }
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(x + a * i + c), (int)(y + j), (int)(z + b * i + d))) continue;
                this.omega = 0;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.WIND.playSoundAtBlock(world, x, y, z, 1.1f * volume, 1.0f * pitchMultiplier);
    }

    @Override
    public int getFuelLevel() {
        return 0;
    }

    @Override
    protected int getMaxSpeed(World world, int x, int y, int z, int meta) {
        return (int)((float)EngineType.WIND.getSpeed() * this.getWindFactor(world, x, y, z, meta));
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
        this.dealBladeDamage(world, x, y, z, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(1.0, 1.0, 1.0);
    }

    @Override
    public void onRotate() {
        this.clearance = null;
    }

    private static class WindClearanceCheck {
        private final Coordinate engine;
        private final ForgeDirection direction;
        private final int stepRatio;
        private final int searchDistance;
        private int step = 1;
        private final double[] blockFraction;
        private boolean dirty;
        private float penalty;

        private WindClearanceCheck(TileEntityWindEngine te, int search, int step) {
            this.engine = new Coordinate((TileEntity)te);
            this.direction = te.getWriteDirection().getOpposite();
            this.searchDistance = search;
            this.stepRatio = step;
            this.blockFraction = new double[this.searchDistance];
            for (int i = 1; i <= this.searchDistance; ++i) {
                this.scanRow(te.field_145850_b, i);
            }
        }

        private void tick(World world) {
            this.scanRow(world, this.step);
            ++this.step;
            if (this.step > this.searchDistance) {
                this.step = 1;
            }
        }

        private void scanRow(World world, int step) {
            int r = 1 + (step - 1) / this.stepRatio;
            ForgeDirection dir = ReikaDirectionHelper.getRightBy90((ForgeDirection)this.direction);
            int blocked = 0;
            for (int i = -r; i <= r; ++i) {
                int dx = this.engine.xCoord + this.direction.offsetX * step + dir.offsetX * i;
                int dy = this.engine.yCoord;
                int dz = this.engine.zCoord + this.direction.offsetZ * step + dir.offsetZ * i;
                if (ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
                ++blocked;
            }
            double frac = (double)blocked / ((double)r * 2.0 + 1.0);
            if (this.blockFraction[step - 1] != frac) {
                this.blockFraction[step - 1] = frac;
                this.dirty = true;
            }
        }

        private void calculatePenalty() {
            this.penalty = 0.0f;
            double max = 0.0;
            for (int i = 0; i < this.blockFraction.length; ++i) {
                double pow = 1.2 - (double)i / (double)this.searchDistance;
                double rowValue = Math.pow(pow, 12.0);
                this.penalty = (float)((double)this.penalty + rowValue * this.blockFraction[i]);
                max += rowValue;
            }
            this.penalty = (float)((double)this.penalty / Math.sqrt(max));
            this.penalty = (float)Math.sqrt(this.penalty);
        }

        public float getPenalty() {
            if (this.dirty) {
                this.calculatePenalty();
                this.dirty = false;
            }
            return this.penalty;
        }
    }
}

