/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders;

import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Models.Animated.ShaftOnly.ModelCross;
import Reika.RotaryCraft.Models.Animated.ShaftOnly.ModelShaft;
import Reika.RotaryCraft.Models.Animated.ShaftOnly.ModelShaftV;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderShaft
extends RotaryTERenderer {
    protected ModelShaft ShaftModel = new ModelShaft();
    protected ModelShaftV VShaftModel = new ModelShaftV();
    private ModelCross crossModel = new ModelCross();
    private int itemMetadata;

    public void renderTileEntityShaftAt(TileEntityShaft tile, double par2, double par4, double par6, float par8) {
        int meta;
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelShaft var14 = this.ShaftModel;
        ModelShaftV var15 = this.VShaftModel;
        ModelCross var16 = this.crossModel;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttex.png");
        if (!tile.isInWorld()) {
            switch (this.itemMetadata) {
                case 1: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexw.png");
                    break;
                }
                case 2: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexs.png");
                    break;
                }
                case 3: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttex.png");
                    break;
                }
                case 4: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexd.png");
                    break;
                }
                case 5: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexb.png");
                }
            }
        } else {
            if (tile.getShaftType() == null) {
                return;
            }
            switch (tile.getShaftType()) {
                case WOOD: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexw.png");
                    break;
                }
                case STONE: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexs.png");
                    break;
                }
                case STEEL: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttex.png");
                    break;
                }
                case DIAMOND: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexd.png");
                    break;
                }
                case BEDROCK: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/shafttexb.png");
                }
            }
        }
        this.setupGL(tile, par2, par4, par6);
        int var11 = 0;
        boolean failed = false;
        if (tile.isInWorld()) {
            failed = tile.failed();
            meta = tile.func_145832_p();
            switch (meta) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
            GL11.glRotatef((float)var11, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            meta = this.itemMetadata != -1 ? 0 : 6;
        }
        int dir = 1;
        if (meta == 5) {
            dir = -1;
        }
        if (meta <= 3) {
            var14.renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object)failed), -tile.phi, 0.0f);
        } else if (meta <= 5) {
            this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/" + this.getImageFileName(tile));
            var15.renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object)failed), -tile.phi * (float)dir, 0.0f);
        } else {
            this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/crosstex.png");
            switch (tile.func_145832_p()) {
                case 0: {
                    var16.renderAll((TileEntity)tile, null, -tile.crossphi2, tile.crossphi1);
                    break;
                }
                case 6: {
                    var16.renderAll((TileEntity)tile, null, -tile.crossphi2, tile.crossphi1);
                    break;
                }
                case 7: {
                    var16.renderAll((TileEntity)tile, null, tile.crossphi2, tile.crossphi1);
                    break;
                }
                case 8: {
                    var16.renderAll((TileEntity)tile, null, tile.crossphi2, tile.crossphi1);
                    break;
                }
                case 9: {
                    var16.renderAll((TileEntity)tile, null, -tile.crossphi2, tile.crossphi1);
                }
            }
        }
        this.closeGL(tile);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (par8 == -10000.0f) {
            this.itemMetadata = -1;
            par8 = 0.0f;
        } else {
            this.itemMetadata = (int)(-par8) / 1000;
            par8 = 0.0f;
        }
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntityShaftAt((TileEntityShaft)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
        }
    }

    public String getImageFileName(RenderFetcher te) {
        String name;
        if (te == null) {
            return null;
        }
        TileEntityShaft tile = (TileEntityShaft)te;
        if (!tile.isInWorld()) {
            switch (this.itemMetadata) {
                case 1: {
                    name = "shafttexw.png";
                    break;
                }
                case 2: {
                    name = "shafttexs.png";
                    break;
                }
                case 3: {
                    name = "shafttex.png";
                    break;
                }
                case 4: {
                    name = "shafttexd.png";
                    break;
                }
                case 5: {
                    name = "shafttexb.png";
                    break;
                }
                default: {
                    name = "crosstex.png";
                    break;
                }
            }
        } else {
            if (tile.func_145832_p() > 5) {
                return "crosstex.png";
            }
            String p = tile.func_145832_p() > 3 ? "v" : "";
            switch (tile.getShaftType()) {
                case WOOD: {
                    name = p + "shafttexw.png";
                    break;
                }
                case STONE: {
                    name = p + "shafttexs.png";
                    break;
                }
                case STEEL: {
                    name = p + "shafttex.png";
                    break;
                }
                case DIAMOND: {
                    name = p + "shafttexd.png";
                    break;
                }
                case BEDROCK: {
                    name = p + "shafttexb.png";
                    break;
                }
                default: {
                    name = p + "crosstex.png";
                }
            }
        }
        return name;
    }
}

