/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders;

import Reika.DragonAPI.Instantiable.Effects.Glow;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Models.Engine.ModelAC;
import Reika.RotaryCraft.Models.Engine.ModelCombustion;
import Reika.RotaryCraft.Models.Engine.ModelDC;
import Reika.RotaryCraft.Models.Engine.ModelHydro;
import Reika.RotaryCraft.Models.Engine.ModelJet;
import Reika.RotaryCraft.Models.Engine.ModelMicroTurbine;
import Reika.RotaryCraft.Models.Engine.ModelPerformance;
import Reika.RotaryCraft.Models.Engine.ModelSteam;
import Reika.RotaryCraft.Models.Engine.ModelWind;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityHydroEngine;
import Reika.RotaryCraft.TileEntities.Engine.TileEntityJetEngine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderSEngine
extends RotaryTERenderer {
    private ModelDC DCModel = new ModelDC();
    private ModelSteam SteamModel = new ModelSteam();
    private ModelCombustion CombModel = new ModelCombustion();
    private ModelAC ACModel = new ModelAC();
    private ModelPerformance PerfModel = new ModelPerformance();
    private ModelMicroTurbine MicroModel = new ModelMicroTurbine();
    private ModelJet JetModel = new ModelJet();
    private ModelHydro HydroModel = new ModelHydro();
    private ModelWind WindModel = new ModelWind();
    private static final Glow jetGlow = new Glow(255, 150, 20, 192).setScale(0.4);

    public void renderTileEntityEngineAt(TileEntityEngine tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelDC var14 = this.DCModel;
        ModelSteam var15 = this.SteamModel;
        ModelCombustion var16 = this.CombModel;
        ModelAC var17 = this.ACModel;
        ModelPerformance var18 = this.PerfModel;
        ModelMicroTurbine var19 = this.MicroModel;
        ModelJet var20 = this.JetModel;
        ModelHydro var21 = this.HydroModel;
        ModelWind var22 = this.WindModel;
        switch (tile.getEngineType()) {
            case DC: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/dc.png");
                break;
            }
            case WIND: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/windtex.png");
                break;
            }
            case STEAM: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/steamtex.png");
                break;
            }
            case GAS: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/combtex.png");
                break;
            }
            case AC: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/actex.png");
                break;
            }
            case SPORT: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/perftex.png");
                break;
            }
            case HYDRO: {
                TileEntityHydroEngine eng = (TileEntityHydroEngine)tile;
                String sg = "/Reika/RotaryCraft/Textures/TileEntityTex/" + (eng.isBedrock() ? "bedhydrotex.png" : "hydrotex.png");
                this.bindTextureByName(sg);
                break;
            }
            case MICRO: {
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/microtex.png");
                break;
            }
            case JET: {
                String s = ((TileEntityJetEngine)tile).canAfterBurn() ? "_b" : "";
                this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/jettex" + s + ".png");
            }
        }
        this.setupGL(tile, par2, par4, par6);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
            if (tile.getEngineType().isJetFueled()) {
                var11 += 90;
            }
        } else {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            switch (tile.getEngineType()) {
                case DC: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/dc.png");
                    var14.renderAll((TileEntity)tile, null);
                    break;
                }
                case WIND: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    double s = 0.7;
                    double d = 0.375;
                    GL11.glScaled((double)s, (double)s, (double)s);
                    double d2 = 0.2;
                    GL11.glTranslated((double)0.0, (double)d, (double)0.0);
                    GL11.glTranslated((double)d2, (double)0.0, (double)0.0);
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/windtex.png");
                    var22.renderAll((TileEntity)tile, null);
                    GL11.glTranslated((double)0.0, (double)(-d), (double)0.0);
                    GL11.glTranslated((double)(-d2), (double)0.0, (double)0.0);
                    GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case STEAM: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/steamtex.png");
                    var15.renderAll((TileEntity)tile, null);
                    break;
                }
                case GAS: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/combtex.png");
                    var16.renderAll((TileEntity)tile, null);
                    break;
                }
                case AC: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/actex.png");
                    var17.renderAll((TileEntity)tile, null);
                    break;
                }
                case SPORT: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/perftex.png");
                    var18.renderAll((TileEntity)tile, null, Float.MIN_NORMAL, 0.0f);
                    break;
                }
                case HYDRO: {
                    TileEntityHydroEngine eng = (TileEntityHydroEngine)tile;
                    String sg = "/Reika/RotaryCraft/Textures/TileEntityTex/" + (eng.isBedrock() ? "bedhydrotex.png" : "hydrotex.png");
                    this.bindTextureByName(sg);
                    double s = 0.7;
                    double d = 0.375;
                    GL11.glTranslated((double)0.0, (double)d, (double)0.0);
                    GL11.glScaled((double)s, (double)s, (double)s);
                    var21.renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object[])new Boolean[]{eng.failed, eng.isBedrock()}), 0.0f, 0.0f);
                    GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
                    GL11.glTranslated((double)0.0, (double)(-d), (double)0.0);
                    break;
                }
                case MICRO: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/microtex.png");
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    var19.renderAll((TileEntity)tile, null);
                    break;
                }
                case JET: {
                    this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/jettex.png");
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    var20.renderAll((TileEntity)tile, null);
                }
            }
            this.closeGL(tile);
            return;
        }
        GL11.glRotatef((float)var11, (float)0.0f, (float)1.0f, (float)0.0f);
        switch (tile.getEngineType()) {
            case DC: {
                var14.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case WIND: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                var22.renderAll((TileEntity)tile, null, -tile.phi);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case STEAM: {
                var15.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case GAS: {
                var16.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case AC: {
                var17.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case SPORT: {
                var18.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case HYDRO: {
                TileEntityHydroEngine eng = (TileEntityHydroEngine)tile;
                var21.renderAll((TileEntity)tile, ReikaJavaLibrary.makeListFrom((Object[])new Boolean[]{eng.failed, eng.isBedrock()}), -tile.phi, 0.0f);
                break;
            }
            case MICRO: {
                var19.renderAll((TileEntity)tile, null, -tile.phi);
                break;
            }
            case JET: {
                var20.renderAll((TileEntity)tile, null, -tile.phi);
            }
        }
        this.closeGL(tile);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntityEngineAt((TileEntityEngine)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
            TileEntityEngine eng = (TileEntityEngine)tile;
            eng.power = 1L;
        }
    }

    private void renderGlow(TileEntity tile, double par2, double par4, double par6) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        int meta = tile.func_145832_p();
        double x = 0.0;
        double z = 0.0;
        boolean side = meta < 2;
        int r = 255;
        int g = 200;
        int b = 20;
        int a = 32;
        x = 0.125;
        z = 0.125;
        double s = 0.125;
        ReikaRenderHelper.prepareGeoDraw((a < 255 ? 1 : 0) != 0);
        double d = -0.5 * s * 2.0;
        ReikaGLHelper.BlendMode.PREALPHA.apply();
        for (float i = 0.0f; i < 360.0f; i += 22.5f) {
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.0);
            GL11.glRotated((double)i, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)0.0, (double)d, (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)s);
            v5.func_78382_b();
            v5.func_78370_a(r, g, b, a);
            if (side) {
                v5.func_78377_a(x, 0.0, 0.0);
                v5.func_78377_a(x, 0.0, 1.0);
                v5.func_78377_a(x, 1.0, 1.0);
                v5.func_78377_a(x, 1.0, 0.0);
            } else {
                v5.func_78377_a(0.0, 0.0, z);
                v5.func_78377_a(1.0, 0.0, z);
                v5.func_78377_a(1.0, 1.0, z);
                v5.func_78377_a(0.0, 1.0, z);
            }
            v5.func_78381_a();
            GL11.glScaled((double)(1.0 / s), (double)(1.0 / s), (double)(1.0 / s));
            GL11.glTranslated((double)0.0, (double)(-d), (double)0.0);
            GL11.glRotated((double)(-i), (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.01);
        }
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        ReikaRenderHelper.exitGeoDraw();
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
    }

    public String getImageFileName(RenderFetcher te) {
        if (te == null) {
            return null;
        }
        TileEntityEngine tile = (TileEntityEngine)te;
        switch (tile.getEngineType()) {
            case DC: {
                return "dc.png";
            }
            case WIND: {
                return "windtex.png";
            }
            case STEAM: {
                return "steamtex.png";
            }
            case GAS: {
                return "combtex.png";
            }
            case AC: {
                return "actex.png";
            }
            case SPORT: {
                return "perftex.png";
            }
            case HYDRO: {
                return "hydrotex.png";
            }
            case MICRO: {
                return "microtex.png";
            }
            case JET: {
                return "jettex.png";
            }
        }
        return null;
    }
}

