/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders;

import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RenderableDuct;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.ClientProxy;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class PipeRenderer
extends RotaryTERenderer {
    protected void renderLiquid(RenderableDuct tile, double par2, double par4, double par6, ForgeDirection dir) {
        Fluid f = tile.getFluidType();
        if (f == null) {
            return;
        }
        float size = 0.375f;
        float window = 0.25f;
        float dl = size - window;
        float dd = 0.5f - size;
        double in = 0.5 + (double)size - 0.01;
        double in2 = 0.5 - (double)size + 0.01;
        double dd2 = in - in2;
        IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)tile.getFluidType());
        ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
        if (f.getLuminosity() > 0) {
            ReikaRenderHelper.disableLighting();
        }
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float u2 = ico.func_94212_f();
        float v2 = ico.func_94210_h();
        double du = dd2 * (double)(u2 - u) / 4.0;
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)32826);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78375_b((float)dir.offsetX, (float)dir.offsetY, (float)dir.offsetZ);
        if (!tile.isConnectionValidForSide(dir)) {
            switch (dir) {
                case UP: {
                    v5.func_78374_a(in2, in, in, (double)u, (double)v2);
                    v5.func_78374_a(in, in, in, (double)u2, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u, (double)v);
                    break;
                }
                case DOWN: {
                    v5.func_78374_a(in2, in2, in2, (double)u, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u, (double)v2);
                    break;
                }
                case SOUTH: {
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u2, (double)v);
                    v5.func_78374_a(in2, in2, in, (double)u2, (double)v2);
                    v5.func_78374_a(in, in2, in, (double)u, (double)v2);
                    break;
                }
                case NORTH: {
                    v5.func_78374_a(in, in2, in2, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in, in2, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78374_a(in, in2, in, (double)u, (double)v2);
                    v5.func_78374_a(in, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    break;
                }
                case WEST: {
                    v5.func_78374_a(in2, in, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u, (double)v2);
                }
            }
        } else {
            switch (dir) {
                case DOWN: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, in2, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, 0.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, 0.0, in, (double)u, (double)v + du);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, 0.0, in, (double)u, (double)v + du);
                    v5.func_78374_a(in, 0.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(in, 0.0, in2, (double)u, (double)v + du);
                    v5.func_78374_a(in2, 0.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, in2, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(in, in2, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in2, in, (double)u2, (double)v);
                    v5.func_78374_a(in2, 0.0, in, (double)u2, (double)v + du);
                    v5.func_78374_a(in, 0.0, in, (double)u, (double)v + du);
                    break;
                }
                case UP: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, 1.0, in, (double)u, (double)v + du);
                    v5.func_78374_a(in2, 1.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u, (double)v);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    v5.func_78374_a(in, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, 1.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in, 1.0, in, (double)u, (double)v + du);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(in, in, in2, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, 1.0, in2, (double)u2, (double)v + du);
                    v5.func_78374_a(in, 1.0, in2, (double)u, (double)v + du);
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(in, 1.0, in, (double)u, (double)v + du);
                    v5.func_78374_a(in2, 1.0, in, (double)u2, (double)v + du);
                    v5.func_78374_a(in2, in, in, (double)u2, (double)v);
                    v5.func_78374_a(in, in, in, (double)u, (double)v);
                    break;
                }
                case NORTH: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, in2, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in, 0.0, (double)u, (double)v);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, in, 0.0, (double)u, (double)v);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in2, 0.0, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(in2, in, 0.0, (double)u, (double)v2);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in, in, 0.0, (double)u, (double)v);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(in, in2, 0.0, (double)u, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in2, 0.0, (double)u, (double)v2);
                    break;
                }
                case SOUTH: {
                    v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in2, in, 1.0, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in2, 1.0, (double)u, (double)v2);
                    v5.func_78375_b(1.0f, 0.0f, 0.0f);
                    v5.func_78374_a(in, in2, 1.0, (double)u, (double)v2);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in, 1.0, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(in, in, 1.0, (double)u, (double)v);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in, 1.0, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(in2, in2, 1.0, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, 1.0, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(1.0, in, in, (double)u, (double)v);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(1.0, in2, in, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(1.0, in2, in2, (double)u, (double)v2);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(1.0, in, in2, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(1.0, in, in2, (double)u, (double)v2);
                    v5.func_78374_a(in, in, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(1.0, in, in, (double)u, (double)v);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(1.0, in2, in, (double)u, (double)v);
                    v5.func_78374_a(in, in2, in, (double)u + du, (double)v);
                    v5.func_78374_a(in, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(1.0, in2, in2, (double)u, (double)v2);
                    break;
                }
                case WEST: {
                    v5.func_78375_b(0.0f, 0.0f, 1.0f);
                    v5.func_78374_a(0.0, in2, in, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(0.0, in, in, (double)u, (double)v);
                    v5.func_78375_b(0.0f, 0.0f, -1.0f);
                    v5.func_78374_a(0.0, in, in2, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(0.0, in2, in2, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, 1.0f, 0.0f);
                    v5.func_78374_a(0.0, in, in, (double)u, (double)v);
                    v5.func_78374_a(in2, in, in, (double)u + du, (double)v);
                    v5.func_78374_a(in2, in, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(0.0, in, in2, (double)u, (double)v2);
                    v5.func_78375_b(0.0f, -1.0f, 0.0f);
                    v5.func_78374_a(0.0, in2, in2, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, in2, (double)u + du, (double)v2);
                    v5.func_78374_a(in2, in2, in, (double)u + du, (double)v);
                    v5.func_78374_a(0.0, in2, in, (double)u, (double)v);
                    break;
                }
            }
        }
        if (tile.isConnectedToNonSelf(dir)) {
            v5.func_78375_b((float)dir.offsetX, (float)dir.offsetY, (float)dir.offsetZ);
            switch (dir) {
                case UP: {
                    v5.func_78374_a(in2, 0.99, in, (double)u, (double)v2);
                    v5.func_78374_a(in, 0.99, in, (double)u2, (double)v2);
                    v5.func_78374_a(in, 0.99, in2, (double)u2, (double)v);
                    v5.func_78374_a(in2, 0.99, in2, (double)u, (double)v);
                    break;
                }
                case DOWN: {
                    v5.func_78374_a(in2, 0.01, in2, (double)u, (double)v);
                    v5.func_78374_a(in, 0.01, in2, (double)u2, (double)v);
                    v5.func_78374_a(in, 0.01, in, (double)u2, (double)v2);
                    v5.func_78374_a(in2, 0.01, in, (double)u, (double)v2);
                    break;
                }
                case SOUTH: {
                    v5.func_78374_a(in, in, 0.99, (double)u, (double)v);
                    v5.func_78374_a(in2, in, 0.99, (double)u2, (double)v);
                    v5.func_78374_a(in2, in2, 0.99, (double)u2, (double)v2);
                    v5.func_78374_a(in, in2, 0.99, (double)u, (double)v2);
                    break;
                }
                case NORTH: {
                    v5.func_78374_a(in, in2, 0.01, (double)u, (double)v2);
                    v5.func_78374_a(in2, in2, 0.01, (double)u2, (double)v2);
                    v5.func_78374_a(in2, in, 0.01, (double)u2, (double)v);
                    v5.func_78374_a(in, in, 0.01, (double)u, (double)v);
                    break;
                }
                case EAST: {
                    v5.func_78374_a(0.99, in2, in, (double)u, (double)v2);
                    v5.func_78374_a(0.99, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(0.99, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(0.99, in, in, (double)u, (double)v);
                    break;
                }
                case WEST: {
                    v5.func_78374_a(0.01, in, in, (double)u, (double)v);
                    v5.func_78374_a(0.01, in, in2, (double)u2, (double)v);
                    v5.func_78374_a(0.01, in2, in2, (double)u2, (double)v2);
                    v5.func_78374_a(0.01, in2, in, (double)u, (double)v2);
                }
            }
        }
        v5.func_78381_a();
        GL11.glDisable((int)32826);
        ReikaRenderHelper.enableLighting();
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
        GL11.glDisable((int)3042);
    }

    public String getImageFileName(RenderFetcher te) {
        return "";
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        RenderableDuct te = (RenderableDuct)tile;
        if (!tile.func_145830_o()) {
            ReikaTextureHelper.bindTerrainTexture();
            double s = 1.0;
            double sy = 1.05;
            GL11.glScaled((double)s, (double)sy, (double)s);
            ClientProxy.pipe.renderBlockInInventory(te, par2, par4, par6);
            GL11.glScaled((double)(1.0 / s), (double)(1.0 / sy), (double)(1.0 / s));
        }
    }

    private void renderBlock(RenderableDuct te, double par2, double par4, double par6) {
        IIcon ico = te.getBlockIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        Tessellator v5 = Tessellator.field_78398_a;
        float f = 0.6f;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(0.0, 0.0, 1.0, (double)u, (double)v);
        v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)dv);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)dv);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)dv);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        f = 0.4f;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)u, (double)dv);
        v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(0.0, 0.0, 1.0, (double)du, (double)v);
        v5.func_78374_a(0.0, 1.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)dv);
        v5.func_78381_a();
        f = 1.0f;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)dv);
        v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
        v5.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)v);
        v5.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)dv);
        v5.func_78374_a(0.0, 0.0, 1.0, (double)u, (double)dv);
        v5.func_78381_a();
        double g = 0.35;
        double g1 = g / 2.0;
        double g2 = 1.0 - g / 2.0;
        ico = Blocks.field_150325_L.func_149691_a(0, ReikaDyeHelper.BLACK.getWoolMeta());
        u = ico.func_94209_e();
        v = ico.func_94206_g();
        du = ico.func_94212_f();
        dv = ico.func_94210_h();
        float uu = du - u;
        float vv = dv - v;
        u = (float)((double)u + g1 * (double)uu);
        du = (float)((double)du - g1 * (double)uu);
        v = (float)((double)v + g1 * (double)vv);
        dv = (float)((double)dv - g1 * (double)vv);
        f = 0.6f;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(g1, g1, 1.001, (double)u, (double)v);
        v5.func_78374_a(g2, g1, 1.001, (double)du, (double)v);
        v5.func_78374_a(g2, g2, 1.001, (double)du, (double)dv);
        v5.func_78374_a(g1, g2, 1.001, (double)u, (double)dv);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(g1, g2, -0.001, (double)u, (double)dv);
        v5.func_78374_a(g2, g2, -0.001, (double)du, (double)dv);
        v5.func_78374_a(g2, g1, -0.001, (double)du, (double)v);
        v5.func_78374_a(g1, g1, -0.001, (double)u, (double)v);
        v5.func_78381_a();
        f = 0.4f;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(1.001, g2, g1, (double)u, (double)dv);
        v5.func_78374_a(1.001, g2, g2, (double)du, (double)dv);
        v5.func_78374_a(1.001, g1, g2, (double)du, (double)v);
        v5.func_78374_a(1.001, g1, g1, (double)u, (double)v);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(-0.001, g1, g1, (double)u, (double)v);
        v5.func_78374_a(-0.001, g1, g2, (double)du, (double)v);
        v5.func_78374_a(-0.001, g2, g2, (double)du, (double)dv);
        v5.func_78374_a(-0.001, g2, g1, (double)u, (double)dv);
        v5.func_78381_a();
        f = 1.0f;
        GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(g1, 1.001, g2, (double)u, (double)dv);
        v5.func_78374_a(g2, 1.001, g2, (double)du, (double)dv);
        v5.func_78374_a(g2, 1.001, g1, (double)du, (double)v);
        v5.func_78374_a(g1, 1.001, g1, (double)u, (double)v);
        v5.func_78381_a();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a(g1, -0.001, g1, (double)u, (double)v);
        v5.func_78374_a(g2, -0.001, g1, (double)du, (double)v);
        v5.func_78374_a(g2, -0.001, g2, (double)du, (double)dv);
        v5.func_78374_a(g1, -0.001, g2, (double)u, (double)dv);
        v5.func_78381_a();
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
    }

    private void renderFace(RenderableDuct tile, double x, double y, double z, ForgeDirection dir) {
        float size = 0.375f;
        float window = 0.25f;
        float dl = size - window;
        float dd = 0.5f - size;
        IIcon ico = tile.getBlockIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float u2 = ico.func_94212_f();
        float v2 = ico.func_94210_h();
        float ddu = u2 - u;
        float ddv = v2 - v;
        float uo = u;
        float vo = v;
        float u2o = u2;
        float v2o = v2;
        u += ddu * (1.0f - size) / 5.0f;
        v += ddv * (1.0f - size) / 5.0f;
        u2 -= ddu * (1.0f - size) / 5.0f;
        v2 -= ddv * (1.0f - size) / 5.0f;
        float du = ddu * dd;
        float dv = ddv * dd;
        float lx = dd + dl;
        float ly = dd + dl;
        float mx = 1.0f - dd - dl;
        float my = 1.0f - dd - dl;
        IIcon gico = Blocks.field_150359_w.func_149691_a(0, 0);
        float gu = gico.func_94209_e();
        float gv = gico.func_94206_g();
        float gu2 = gico.func_94212_f();
        float gv2 = gico.func_94210_h();
        float dgu = gu2 - gu;
        float dgv = gv2 - gv;
        float guu = gu + dgu * dl;
        float gvv = gv + dgv * dl;
        gu += dgu / 8.0f;
        gv += dgv / 8.0f;
        gu2 -= dgu / 8.0f;
        gv2 -= dgv / 8.0f;
        Tessellator v5 = Tessellator.field_78398_a;
        this.faceBrightness(dir, v5);
        switch (dir) {
            case DOWN: {
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u + du), (double)v);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)dd, (double)(u + du), (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)dd, (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(dd + dl), (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(dd + dl), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)ly, (double)gu2, (double)gv);
                v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)ly, (double)gu, (double)gv);
                v5.func_78374_a((double)lx, (double)(1.0f - dd), (double)my, (double)gu, (double)gv2);
                v5.func_78374_a((double)mx, (double)(1.0f - dd), (double)my, (double)gu2, (double)gv2);
                break;
            }
            case NORTH: {
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)(1.0f - dd), (double)(u + du), (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u + du), (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)(1.0f - dd), (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)(1.0f - dd), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)(1.0f - dd), (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)mx, (double)my, (double)(1.0f - dd), (double)gu2, (double)gv2);
                v5.func_78374_a((double)lx, (double)my, (double)(1.0f - dd), (double)gu, (double)gv2);
                v5.func_78374_a((double)lx, (double)ly, (double)(1.0f - dd), (double)gu, (double)gv);
                v5.func_78374_a((double)mx, (double)ly, (double)(1.0f - dd), (double)gu2, (double)gv);
                break;
            }
            case EAST: {
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)mx, (double)gu2, (double)gv);
                v5.func_78374_a((double)(1.0f - dd), (double)ly, (double)lx, (double)gu, (double)gv);
                v5.func_78374_a((double)(1.0f - dd), (double)my, (double)lx, (double)gu, (double)gv2);
                v5.func_78374_a((double)(1.0f - dd), (double)my, (double)mx, (double)gu2, (double)gv2);
                break;
            }
            case WEST: {
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)(dd + dl), (double)(u + du), (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(dd + dl), (double)(u + du), (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd - dl), (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd - dl), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)(1.0f - dd), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)(1.0f - dd), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)dd, (double)my, (double)mx, (double)gu2, (double)gv2);
                v5.func_78374_a((double)dd, (double)my, (double)lx, (double)gu, (double)gv2);
                v5.func_78374_a((double)dd, (double)ly, (double)lx, (double)gu, (double)gv);
                v5.func_78374_a((double)dd, (double)ly, (double)mx, (double)gu2, (double)gv);
                break;
            }
            case UP: {
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)dd, (double)(u + du), (double)v2);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)(1.0f - dd), (double)(u + du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)dd, (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)(1.0f - dd), (double)(u2 - du), (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(dd + dl), (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)dd, (double)(dd + dl), (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd - dl), (double)u, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd - dl), (double)u2, (double)(v + dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)(1.0f - dd), (double)u2, (double)v);
                v5.func_78374_a((double)dd, (double)dd, (double)(1.0f - dd), (double)u, (double)v);
                v5.func_78374_a((double)mx, (double)dd, (double)my, (double)gu2, (double)gv2);
                v5.func_78374_a((double)lx, (double)dd, (double)my, (double)gu, (double)gv2);
                v5.func_78374_a((double)lx, (double)dd, (double)ly, (double)gu, (double)gv);
                v5.func_78374_a((double)mx, (double)dd, (double)ly, (double)gu2, (double)gv);
                break;
            }
            case SOUTH: {
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(dd + dl), (double)(1.0f - dd), (double)dd, (double)(u + du), (double)v);
                v5.func_78374_a((double)(dd + dl), (double)dd, (double)dd, (double)(u + du), (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)(1.0f - dd), (double)dd, (double)(u2 - du), (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)(1.0f - dd - dl), (double)dd, (double)dd, (double)(u2 - du), (double)v2);
                v5.func_78374_a((double)dd, (double)(dd + dl), (double)dd, (double)u, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)(dd + dl), (double)dd, (double)u2, (double)(v2 - dv));
                v5.func_78374_a((double)(1.0f - dd), (double)dd, (double)dd, (double)u2, (double)v2);
                v5.func_78374_a((double)dd, (double)dd, (double)dd, (double)u, (double)v2);
                v5.func_78374_a((double)dd, (double)(1.0f - dd), (double)dd, (double)u, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd), (double)dd, (double)u2, (double)v);
                v5.func_78374_a((double)(1.0f - dd), (double)(1.0f - dd - dl), (double)dd, (double)u2, (double)(v + dv));
                v5.func_78374_a((double)dd, (double)(1.0f - dd - dl), (double)dd, (double)u, (double)(v + dv));
                v5.func_78374_a((double)mx, (double)ly, (double)dd, (double)gu2, (double)gv);
                v5.func_78374_a((double)lx, (double)ly, (double)dd, (double)gu, (double)gv);
                v5.func_78374_a((double)lx, (double)my, (double)dd, (double)gu, (double)gv2);
                v5.func_78374_a((double)mx, (double)my, (double)dd, (double)gu2, (double)gv2);
                break;
            }
        }
    }

    private void faceBrightness(ForgeDirection dir, Tessellator v5) {
        float f = 1.0f;
        switch (dir.getOpposite()) {
            case DOWN: {
                f = 0.4f;
                break;
            }
            case EAST: {
                f = 0.5f;
                break;
            }
            case NORTH: {
                f = 0.65f;
                break;
            }
            case SOUTH: {
                f = 0.65f;
                break;
            }
            case UP: {
                f = 1.0f;
                break;
            }
            case WEST: {
                f = 0.5f;
                break;
            }
        }
        v5.func_78386_a(f, f, f);
    }
}

