/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders.M;

import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Models.ModelReservoir;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityGroundHydrator;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class RenderHydrator
extends RotaryTERenderer {
    private ModelReservoir ReservoirModel = new ModelReservoir();

    public void renderTileEntityGroundHydratorAt(TileEntityGroundHydrator tile, double par2, double par4, double par6, float par8) {
        int var9 = !tile.isInWorld() ? 0 : tile.func_145832_p();
        ModelReservoir var14 = this.ReservoirModel;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/hydratortex.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var11 = 0;
                    break;
                }
                case 1: {
                    var11 = 180;
                    break;
                }
                case 2: {
                    var11 = 270;
                    break;
                }
                case 3: {
                    var11 = 90;
                }
            }
            if (tile.func_145832_p() <= 3) {
                GL11.glRotatef((float)((float)var11 + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)var11, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-1.0f, (float)1.0f);
                if (tile.func_145832_p() == 5) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2.0f);
                }
            }
        }
        if (tile.isInWorld()) {
            for (int i = 2; i < 6; ++i) {
                var14.renderSide((TileEntity)tile, this.dirs[i]);
            }
            var14.renderSide((TileEntity)tile, ForgeDirection.DOWN);
        } else {
            var14.renderAll((TileEntity)tile, null);
        }
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        GL11.glPushAttrib((int)1048575);
        TileEntityGroundHydrator tr = (TileEntityGroundHydrator)tile;
        if (this.doRenderModel(tr)) {
            this.renderTileEntityGroundHydratorAt(tr, par2, par4, par6, par8);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            this.renderCover(tr, par2, par4, par6);
        }
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        if (MinecraftForgeClient.getRenderPass() == 1) {
            this.renderLiquid(tr, par2, par4, par6);
            if (tr.getLevel() > 0) {
                this.renderOverlay(tr, par2, par4, par6);
            }
        }
        GL11.glPopAttrib();
    }

    private void renderOverlay(TileEntityGroundHydrator te, double par2, double par4, double par6) {
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        int r = te.getRange();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = RotaryCraft.hydratorOverlay;
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                Block b = te.field_145850_b.func_147439_a(te.field_145851_c + i, te.field_145848_d, te.field_145849_e + k);
                int meta = te.field_145850_b.func_72805_g(te.field_145851_c + i, te.field_145848_d, te.field_145849_e + k);
                if (!TileEntityGroundHydrator.affectsBlock(b, meta)) continue;
                int a = 192 - 16 * (Math.abs(i) + Math.abs(k));
                v5.func_78384_a(0xFFFFFF, a);
                double h = b.func_149669_A() + 0.005;
                v5.func_78374_a((double)(i + 0), h, (double)(k + 1), (double)u, (double)dv);
                v5.func_78374_a((double)(i + 1), h, (double)(k + 1), (double)du, (double)dv);
                v5.func_78374_a((double)(i + 1), h, (double)(k + 0), (double)du, (double)v);
                v5.func_78374_a((double)(i + 0), h, (double)(k + 0), (double)u, (double)v);
            }
        }
        v5.func_78381_a();
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
    }

    private void renderCover(TileEntityGroundHydrator tr, double par2, double par4, double par6) {
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = RotaryCraft.woodLattice;
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        float h = 0.99f;
        float dd = 0.0f;
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78374_a((double)dd, (double)h, (double)(1.0f - dd), (double)u, (double)dv);
        v5.func_78374_a((double)(1.0f - dd), (double)h, (double)(1.0f - dd), (double)du, (double)dv);
        v5.func_78374_a((double)(1.0f - dd), (double)h, (double)dd, (double)du, (double)v);
        v5.func_78374_a((double)dd, (double)h, (double)dd, (double)u, (double)v);
        v5.func_78381_a();
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
    }

    private void renderLiquid(TileEntityGroundHydrator tr, double par2, double par4, double par6) {
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        Fluid f = tr.getFluid();
        if (f != null) {
            ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            double h = this.getFillAmount(tr);
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            v5.func_78375_b(0.0f, 1.0f, 0.0f);
            v5.func_78374_a(0.0, h, 1.0, (double)u, (double)dv);
            v5.func_78374_a(1.0, h, 1.0, (double)du, (double)dv);
            v5.func_78374_a(1.0, h, 0.0, (double)du, (double)v);
            v5.func_78374_a(0.0, h, 0.0, (double)u, (double)v);
            v5.func_78381_a();
            ReikaRenderHelper.enableLighting();
        }
        GL11.glTranslated((double)(-par2), (double)(-par4), (double)(-par6));
    }

    private double getFillAmount(TileEntityGroundHydrator tr) {
        return 0.0625 + 0.875 * (double)tr.getLevel() / 1000.0;
    }

    public String getImageFileName(RenderFetcher te) {
        return "hydratortex.png";
    }
}

