/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders.M;

import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.RotaryCraft.Auxiliary.IORenderer;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Models.ModelCave;
import Reika.RotaryCraft.TileEntities.Surveying.TileEntityCaveFinder;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderCaveFinder
extends RotaryTERenderer {
    private static final double[][] depthColors = new double[256][3];
    private static final HashMap<TileEntityCaveFinder, Integer> lists = new HashMap();
    private ModelCave caveModel = new ModelCave();

    public String getImageFileName(RenderFetcher te) {
        return "cavetex.png";
    }

    public void renderTileEntityCaveFinderAt(TileEntityCaveFinder tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelCave var14 = this.caveModel;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/cavetex.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        boolean var11 = false;
        var14.renderAll((TileEntity)tile, null);
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntityCaveFinderAt((TileEntityCaveFinder)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            IORenderer.renderIO(tile, par2, par4, par6);
        }
        this.renderPoints((TileEntityCaveFinder)tile, par2, par4, par6);
    }

    public void rebuildList(TileEntityCaveFinder te, double p2, double p4, double p6) {
        int id = GL11.glGenLists((int)1);
        GL11.glNewList((int)id, (int)4865);
        this.drawPoints(te);
        GL11.glEndList();
        lists.put(te, id);
    }

    private void renderPoints(TileEntityCaveFinder te, double p2, double p4, double p6) {
        if (te == null) {
            return;
        }
        if (!te.isInWorld()) {
            return;
        }
        if (!te.on) {
            return;
        }
        GL11.glTranslated((double)(p2 - (double)te.field_145851_c), (double)(p4 - (double)te.field_145848_d), (double)(p6 - (double)te.field_145849_e));
        if (lists.containsKey(te)) {
            GL11.glCallList((int)lists.get(te));
        } else {
            this.rebuildList(te, p2, p4, p6);
        }
        GL11.glTranslated((double)(-p2 + (double)te.field_145851_c), (double)(-p4 + (double)te.field_145848_d), (double)(-p6 + (double)te.field_145849_e));
    }

    private void drawPoints(TileEntityCaveFinder te) {
        GL11.glPushAttrib((int)1048575);
        ReikaRenderHelper.disableLighting();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2929);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glPointSize((float)2.0f);
        int cx = te.getSourceX();
        int cy = te.getSourceY();
        int cz = te.getSourceZ();
        int dx = te.getSourceX() - te.field_145851_c;
        int dy = te.getSourceY() - te.field_145848_d;
        int dz = te.getSourceZ() - te.field_145849_e;
        GL11.glBegin((int)0);
        int range = te.getRange();
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    int y;
                    if (!te.hasPointAt(i + range, j + range, k + range) || (y = te.field_145848_d + j + dy) < 0 || y >= 256) continue;
                    double[] color = this.getColorForDepth(te.field_145848_d + j + dy);
                    GL11.glColor3d((double)color[0], (double)color[1], (double)color[2]);
                    GL11.glVertex3d((double)(te.field_145851_c + i + dx), (double)(te.field_145848_d + j + dy), (double)(te.field_145849_e + k + dz));
                }
            }
        }
        GL11.glEnd();
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(cx - range), (double)(cy - range), (double)(cz - range));
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy - range), (double)(cz - range));
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy - range), (double)(cz + 1 + range));
        GL11.glVertex3d((double)(cx - range), (double)(cy - range), (double)(cz + 1 + range));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(cx - range), (double)(cy + 1 + range), (double)(cz - range));
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy + 1 + range), (double)(cz - range));
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy + 1 + range), (double)(cz + 1 + range));
        GL11.glVertex3d((double)(cx - range), (double)(cy + 1 + range), (double)(cz + 1 + range));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(cx - range), (double)(cy - range), (double)(cz - range));
        GL11.glVertex3d((double)(cx - range), (double)(cy + 1 + range), (double)(cz - range));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy - range), (double)(cz - range));
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy + 1 + range), (double)(cz - range));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy - range), (double)(cz + 1 + range));
        GL11.glVertex3d((double)(cx + 1 + range), (double)(cy + 1 + range), (double)(cz + 1 + range));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glVertex3d((double)(cx - range), (double)(cy - range), (double)(cz + 1 + range));
        GL11.glVertex3d((double)(cx - range), (double)(cy + 1 + range), (double)(cz + 1 + range));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        ReikaRenderHelper.enableLighting();
        GL11.glPopAttrib();
    }

    private double[] getColorForDepth(int y) {
        if (depthColors[y][0] != 0.0 || depthColors[y][1] != 0.0 || depthColors[y][2] != 0.0) {
            return depthColors[y];
        }
        double[] color = new double[3];
        int sc = 32;
        int vsc = 64;
        int hexcolor = Color.HSBtoRGB((float)((Math.abs(y) - 12) % vsc) / (float)vsc, 1.0f, 1.0f);
        color[0] = ReikaColorAPI.HextoColorMultiplier((int)hexcolor, (int)0);
        color[1] = ReikaColorAPI.HextoColorMultiplier((int)hexcolor, (int)1);
        color[2] = ReikaColorAPI.HextoColorMultiplier((int)hexcolor, (int)2);
        RenderCaveFinder.depthColors[y] = color;
        return color;
    }

    public void removeListFor(TileEntityCaveFinder te) {
        lists.remove(te);
    }
}

