/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Renders.DM;

import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.RotaryCraft.Base.RotaryTERenderer;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Models.ModelSpillway;
import Reika.RotaryCraft.TileEntities.Production.TileEntitySpillway;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class RenderSpillway
extends RotaryTERenderer {
    private ModelSpillway SpillwayModel = new ModelSpillway();

    public void renderTileEntitySpillwayAt(TileEntitySpillway tile, double par2, double par4, double par6, float par8) {
        if (!tile.isInWorld()) {
            boolean var9 = false;
        } else {
            int var9 = tile.func_145832_p();
        }
        ModelSpillway var14 = this.SpillwayModel;
        this.bindTextureByName("/Reika/RotaryCraft/Textures/TileEntityTex/spillwaytex.png");
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4 + 2.0f), (float)((float)par6 + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int var11 = 0;
        if (tile.isInWorld()) {
            switch (tile.func_145832_p()) {
                case 0: {
                    var11 = 180;
                    break;
                }
                case 1: {
                    var11 = 0;
                    break;
                }
                case 2: {
                    var11 = 90;
                    break;
                }
                case 3: {
                    var11 = 270;
                }
            }
            GL11.glRotatef((float)var11, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        var14.renderAll((TileEntity)tile, null);
        if (tile.isInWorld()) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (this.doRenderModel((RotaryCraftTileEntity)tile)) {
            this.renderTileEntitySpillwayAt((TileEntitySpillway)tile, par2, par4, par6, par8);
        }
        if (((RotaryCraftTileEntity)tile).isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)par2, (double)par4, (double)par6);
            this.renderLiquid((TileEntitySpillway)tile, par8);
            if (((TileEntitySpillway)tile).isActive()) {
                this.renderParticles((TileEntitySpillway)tile, par8);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderParticles(TileEntitySpillway te, float par8) {
        if (!Minecraft.func_71410_x().func_147113_T() && te.getRandom().nextInt(2) == 0) {
            ForgeDirection dir = te.getDrainSide();
            double v = 0.03125;
            double px = (double)te.field_145851_c + 0.5 + (double)dir.offsetX * 0.5;
            double pz = (double)te.field_145849_e + 0.5 + (double)dir.offsetZ * 0.5;
            if (dir.offsetX != 0) {
                pz = ReikaRandomHelper.getRandomPlusMinus((double)pz, (double)0.4);
            }
            if (dir.offsetZ != 0) {
                px = ReikaRandomHelper.getRandomPlusMinus((double)px, (double)0.4);
            }
            EntityFluidFX fx = new EntityFluidFX(te.field_145850_b, px, (double)(te.field_145848_d + 1), pz, -v * (double)dir.offsetX, 0.0, -v * (double)dir.offsetZ, FluidRegistry.WATER);
            fx.setGravity(0.0625f).setScale(0.5f).setLife(30 - te.getLevel() * 15 / 8000);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        boolean flip = false;
        GL11.glPushMatrix();
        int r = 0;
        switch (te.func_145832_p()) {
            case 0: {
                r = 180;
                GL11.glTranslated((double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case 1: {
                r = 0;
                GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 2: {
                r = 90;
                GL11.glTranslated((double)1.0, (double)0.0, (double)1.0);
                flip = true;
                break;
            }
            case 3: {
                r = 270;
                flip = true;
            }
        }
        GL11.glRotatef((float)(r + 90), (float)0.0f, (float)1.0f, (float)0.0f);
        ReikaTextureHelper.bindTerrainTexture();
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78378_d(0xFFFFFF);
        IIcon ico = FluidRegistry.WATER.getFlowingIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        double z0 = 0.125;
        double z1 = 0.3875;
        float v0 = ico.func_94207_b(z0 * 16.0);
        float v1 = ico.func_94207_b(z1 * 16.0);
        float dv = ico.func_94210_h();
        double h0 = 0.97375;
        double h1 = 0.785;
        double h2 = 0.0675;
        if (flip) {
            v5.func_78374_a(0.0, h0, 1.0 - z0, (double)u, (double)v0);
            v5.func_78374_a(1.0, h0, 1.0 - z0, (double)du, (double)v0);
            v5.func_78374_a(1.0, h0, 1.0, (double)du, (double)v);
            v5.func_78374_a(0.0, h0, 1.0, (double)u, (double)v);
            v5.func_78374_a(0.0, h1, 1.0 - z1, (double)u, (double)v1);
            v5.func_78374_a(1.0, h1, 1.0 - z1, (double)du, (double)v1);
            v5.func_78374_a(1.0, h0, 1.0 - z0, (double)du, (double)v0);
            v5.func_78374_a(0.0, h0, 1.0 - z0, (double)u, (double)v0);
            v5.func_78374_a(0.0, h1, 1.0 - z1, (double)u, (double)v1);
            v5.func_78374_a(1.0, h1, 1.0 - z1, (double)du, (double)v1);
            v5.func_78374_a(1.0, h2, 1.0 - z1, (double)du, (double)dv);
            v5.func_78374_a(0.0, h2, 1.0 - z1, (double)u, (double)dv);
        } else {
            v5.func_78374_a(0.0, h0, z0, (double)u, (double)v0);
            v5.func_78374_a(1.0, h0, z0, (double)du, (double)v0);
            v5.func_78374_a(1.0, h0, 0.0, (double)du, (double)v);
            v5.func_78374_a(0.0, h0, 0.0, (double)u, (double)v);
            v5.func_78374_a(0.0, h1, z1, (double)u, (double)v1);
            v5.func_78374_a(1.0, h1, z1, (double)du, (double)v1);
            v5.func_78374_a(1.0, h0, z0, (double)du, (double)v0);
            v5.func_78374_a(0.0, h0, z0, (double)u, (double)v0);
            v5.func_78374_a(0.0, h1, z1, (double)u, (double)v1);
            v5.func_78374_a(1.0, h1, z1, (double)du, (double)v1);
            v5.func_78374_a(1.0, h2, z1, (double)du, (double)dv);
            v5.func_78374_a(0.0, h2, z1, (double)u, (double)dv);
        }
        v5.func_78381_a();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderLiquid(TileEntitySpillway te, float par8) {
        int amt = te.getLevel();
        if (amt <= 0) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        double h = 0.03125 + 0.71875 * (double)amt / 8000.0;
        Fluid f = FluidRegistry.WATER;
        ReikaLiquidRenderer.bindFluidTexture((Fluid)f);
        IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        v5.func_78378_d(0xFFFFFF);
        v5.func_78374_a(0.0, h, 1.0, (double)u, (double)dv);
        v5.func_78374_a(1.0, h, 1.0, (double)du, (double)dv);
        v5.func_78374_a(1.0, h, 0.0, (double)du, (double)v);
        v5.func_78374_a(0.0, h, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    public String getImageFileName(RenderFetcher te) {
        return "spillwaytex.png";
    }
}

