/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Collections.ItemCollection;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mrtjp.projectred.api.IBundledTile", "appeng.api.networking.IActionHost"})
public class TileEntityBundledBus
extends TileEntityPowerReceiver
implements IBundledTile,
IActionHost,
MESystemReader.ChangeCallback {
    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;
    private int AEPowerCost = 1;
    private final ItemCollection output = new ItemCollection();
    private StepTimer checkTimer = new StepTimer(10);
    private StepTimer cacheTimer = new StepTimer(40);
    public static final int NSLOTS = ReikaDyeHelper.dyes.length;
    private ItemStack[] filter = new ItemStack[NSLOTS];
    private boolean hasWork = true;

    public TileEntityBundledBus() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getMachine().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    private int[] getBundledInput(World world, int x, int y, int z) {
        int[] ret = new int[16];
        for (int i = 0; i < 6; ++i) {
            byte[] data = ProjectRedAPI.transmissionAPI.getBundledInput(world, x, y, z, i);
            if (data == null) continue;
            for (int k = 0; k < 16; ++k) {
                ret[k] = Math.max(ret[k], data[k] & 0xFF);
            }
        }
        return ret;
    }

    private int getBundledInput(World world, int x, int y, int z, ForgeDirection dir, ReikaDyeHelper color) {
        byte[] data = ProjectRedAPI.transmissionAPI.getBundledInput(world, x, y, z, dir.ordinal());
        return data != null ? data[color.ordinal()] & 0xFF : 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        if (!world.field_72995_K) {
            this.cacheTimer.update();
            if (this.cacheTimer.checkCap()) {
                this.buildCache();
            }
            if (this.aeGridBlock != null && !world.field_72995_K) {
                ((BasicAEInterface)this.aeGridBlock).setPowerCost((double)this.AEPowerCost);
            }
            if (this.AEPowerCost > 1) {
                this.AEPowerCost -= Math.max(1, this.AEPowerCost / 40);
            }
            if (this.network != null && this.power >= this.MINPOWER) {
                this.checkTimer.update();
                if (this.hasWork && this.checkTimer.checkCap()) {
                    this.checkTimer.setCap(Math.min(40, this.checkTimer.getCap() + 2));
                    this.output.clear();
                    TileEntity te = this.getAdjacentTileEntity(this.getFacing());
                    if (te instanceof IInventory) {
                        this.output.addInventory((IInventory)te);
                    }
                    int[] input = this.getBundledInput(world, x, y, z);
                    for (int i = 0; i < Math.min(this.getActiveChannels(), NSLOTS); ++i) {
                        int fit;
                        ItemStack f1 = this.filter[i];
                        if (f1 == null || input[i] <= 0 || (fit = f1.func_77976_d() - this.output.addItemsToUnderlyingInventories(ReikaItemHelper.getSizedItemStack((ItemStack)f1, (int)f1.func_77976_d()), true)) <= 0) continue;
                        this.hasWork = false;
                        this.transferItem(ReikaItemHelper.getSizedItemStack((ItemStack)f1, (int)Math.min(fit, f1.func_77976_d())), (IInventory)te);
                    }
                }
            }
        }
    }

    private int getActiveChannels() {
        return (int)Math.min(16L, this.power / this.MINPOWER);
    }

    private void buildCache() {
        if (ModList.APPENG.isLoaded()) {
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                Object object = this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            if (this.aeGridNode != null) {
                ((IGridNode)this.aeGridNode).updateState();
            }
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
                this.buildCallbacks();
            }
        }
    }

    private void buildCallbacks() {
        if (this.network != null) {
            this.network.clearCallbacks();
            for (int i = 0; i < this.filter.length; ++i) {
                ItemStack pattern = this.filter[i];
                if (pattern == null) continue;
                this.network.addCallback(pattern, (MESystemReader.ChangeCallback)this);
            }
        }
        this.hasWork = true;
    }

    private void transferItem(ItemStack is, IInventory ii) {
        long rem = this.network.removeItem(is, true, true);
        if (rem > 0L) {
            is.field_77994_a = (int)Math.min((long)is.field_77994_a, rem);
            if (ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)ii)) {
                this.network.removeItem(is, false, true);
            }
            this.AEPowerCost = Math.min(500, this.AEPowerCost + Math.max(1, is.field_77994_a / 4));
            this.checkTimer.setCap(Math.max(4, this.checkTimer.getCap() - 4));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagCompound fil = new NBTTagCompound();
        for (int i = 0; i < this.filter.length; ++i) {
            ItemStack is = this.filter[i];
            if (is == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            is.func_77955_b(tag);
            fil.func_74782_a("filter_" + i, (NBTBase)tag);
        }
        NBT.func_74782_a("filter", (NBTBase)fil);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.filter = new ItemStack[this.filter.length];
        NBTTagCompound fil = NBT.func_74775_l("filter");
        for (int i = 0; i < this.filter.length; ++i) {
            ItemStack is;
            String name = "filter_" + i;
            if (!fil.func_74764_b(name)) continue;
            NBTTagCompound tag = fil.func_74775_l(name);
            this.filter[i] = is = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void setMapping(int slot, ItemStack is) {
        this.filter[slot] = is;
        if (ModList.APPENG.isLoaded()) {
            this.buildCallbacks();
        }
        this.syncAllData(true);
    }

    public ItemStack getMapping(int slot) {
        return this.filter[slot] != null ? this.filter[slot].func_77946_l() : null;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    private ForgeDirection getFacing() {
        return this.read != null ? this.read.getOpposite() : ForgeDirection.UP;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public void securityBreak() {
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    public void onItemChange(IAEItemStack iae) {
        this.hasWork = true;
    }

    public byte[] getBundledSignal(int dir) {
        return null;
    }

    public boolean canConnectBundled(int side) {
        return true;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BUNDLEDBUS;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

