/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.CustomExtractLoader;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesExtractor;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiExtractor;
import Reika.RotaryCraft.ModInterface.ItemCustomModOre;
import Reika.RotaryCraft.Registry.ExtractorBonus;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ExtractorHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Extractor";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/extractorgui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 0, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(20, 20, 126, 22), "rcextract", new Object[0]));
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcextract")) {
            ReikaOreHelper ore;
            int i;
            for (i = 0; i < ReikaOreHelper.oreList.length; ++i) {
                ore = ReikaOreHelper.oreList[i];
                if (!ore.existsInGame()) continue;
                this.arecipes.add(new ExtractorRecipe((OreType)ore));
            }
            for (i = 0; i < ModOreList.oreList.length; ++i) {
                ore = ModOreList.oreList[i];
                if (!ore.existsInGame()) continue;
                this.arecipes.add(new ExtractorRecipe((OreType)ore));
            }
            List<CustomExtractLoader.CustomExtractEntry> li = CustomExtractLoader.instance.getEntries();
            for (CustomExtractLoader.CustomExtractEntry e : li) {
                if (!e.existsInGame()) continue;
                this.arecipes.add(new ExtractorRecipe(e));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcextract")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (ItemRegistry.EXTRACTS.matchItem(result)) {
            this.arecipes.add(new ExtractorRecipe((OreType)RecipesExtractor.getOreFromExtract(result)));
        } else if (ItemRegistry.MODEXTRACTS.matchItem(result)) {
            ModOreList mod = ModOreList.oreList[result.func_77960_j() / 4];
            if (mod.existsInGame()) {
                this.arecipes.add(new ExtractorRecipe((OreType)mod));
            }
        } else if (ItemRegistry.CUSTOMEXTRACT.matchItem(result)) {
            this.arecipes.add(new ExtractorRecipe(ItemCustomModOre.getExtractType(result)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        int dmg = ingredient.func_77960_j();
        Object type = ReikaOreHelper.getEntryByOreDict((ItemStack)ingredient);
        if (type == null) {
            type = ModOreList.getModOreFromOre((ItemStack)ingredient);
        }
        if (type == null) {
            type = CustomExtractLoader.instance.getEntryFromOreBlock(ingredient);
        }
        if (type != null) {
            this.arecipes.add(new ExtractorRecipe((OreType)type));
        } else if (ItemRegistry.EXTRACTS.matchItem(ingredient) && dmg < ReikaOreHelper.oreList.length * 3) {
            this.arecipes.add(new ExtractorRecipe((OreType)RecipesExtractor.getOreFromExtract(ingredient)));
        } else if (ItemRegistry.MODEXTRACTS.matchItem(ingredient) && dmg % 4 != 3) {
            ModOreList mod = ModOreList.oreList[dmg / 4];
            if (mod.existsInGame()) {
                this.arecipes.add(new ExtractorRecipe((OreType)mod));
            }
        } else if (ItemRegistry.CUSTOMEXTRACT.matchItem(ingredient) && dmg % 4 != 3) {
            this.arecipes.add(new ExtractorRecipe(ItemCustomModOre.getExtractType(ingredient)));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiExtractor.class;
    }

    public void drawExtras(int recipe) {
        ExtractorBonus bonus;
        int chance = this.getDupeChance(recipe);
        Minecraft.func_71410_x().field_71466_p.func_85187_a(String.format("%d%s duplication chance per stage", chance, "%"), -2, 65, 0x333333, false);
        Minecraft.func_71410_x().field_71466_p.func_85187_a(String.format("(Average %.2f units per ore)", Math.pow(1.0 + 0.01 * (double)this.getDupeChance(recipe), 4.0)), 9, 76, 0x333333, false);
        ItemStack is = ((ExtractorRecipe)((Object)this.arecipes.get(recipe))).getSolution();
        ExtractorBonus bon = ExtractorBonus.getBonusForIngredient(is);
        if (bon != null && (bonus = ExtractorBonus.getBonusForIngredient(is)) != null) {
            String s = String.format("%.2f%s", Float.valueOf(bon.getBonusPercent()), "%");
            ReikaGuiAPI.instance.drawCenteredStringNoShadow(Minecraft.func_71410_x().field_71466_p, s, 157, 34, 0);
        }
    }

    public int getDupeChance(int recipe) {
        ExtractorRecipe ir = (ExtractorRecipe)((Object)this.arecipes.get(recipe));
        if (ir != null) {
            OreType.OreRarity r = ir.type.getRarity();
            if (r == OreType.OreRarity.RARE) {
                return 90;
            }
            if (ir.type instanceof ModOreList && ((ModOreList)ir.type).isNetherOres()) {
                return 80;
            }
        }
        return 50;
    }

    public class ExtractorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final ArrayList<ItemStack> oreBlock;
        public final OreType type;

        public ExtractorRecipe(OreType ore) {
            super((TemplateRecipeHandler)ExtractorHandler.this);
            this.type = ore;
            this.oreBlock = new ArrayList(ore.getAllOreBlocks());
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.getFlakes(), 129, 44);
        }

        private ItemStack getDust() {
            if (this.type instanceof ReikaOreHelper) {
                return ItemRegistry.EXTRACTS.getStackOfMetadata(this.type.ordinal());
            }
            if (this.type instanceof ModOreList) {
                return ExtractorModOres.getDustProduct((ModOreList)this.type);
            }
            if (this.type instanceof CustomExtractLoader.CustomExtractEntry) {
                return ItemCustomModOre.getItem(this.type.ordinal(), ExtractorModOres.ExtractorStage.DUST);
            }
            return null;
        }

        private ItemStack getSlurry() {
            if (this.type instanceof ReikaOreHelper) {
                return ItemRegistry.EXTRACTS.getStackOfMetadata(this.type.ordinal() + 8);
            }
            if (this.type instanceof ModOreList) {
                return ExtractorModOres.getSlurryProduct((ModOreList)this.type);
            }
            if (this.type instanceof CustomExtractLoader.CustomExtractEntry) {
                return ItemCustomModOre.getItem(this.type.ordinal(), ExtractorModOres.ExtractorStage.SLURRY);
            }
            return null;
        }

        private ItemStack getSolution() {
            if (this.type instanceof ReikaOreHelper) {
                return ItemRegistry.EXTRACTS.getStackOfMetadata(this.type.ordinal() + 16);
            }
            if (this.type instanceof ModOreList) {
                return ExtractorModOres.getSolutionProduct((ModOreList)this.type);
            }
            if (this.type instanceof CustomExtractLoader.CustomExtractEntry) {
                return ItemCustomModOre.getItem(this.type.ordinal(), ExtractorModOres.ExtractorStage.SOLUTION);
            }
            return null;
        }

        private ItemStack getFlakes() {
            if (this.type instanceof ReikaOreHelper) {
                return ItemRegistry.EXTRACTS.getStackOfMetadata(this.type.ordinal() + 24);
            }
            if (this.type instanceof ModOreList) {
                return ExtractorModOres.getFlakeProduct((ModOreList)this.type);
            }
            if (this.type instanceof CustomExtractLoader.CustomExtractEntry) {
                return ItemCustomModOre.getItem(this.type.ordinal(), ExtractorModOres.ExtractorStage.FLAKES);
            }
            return null;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            int dx = 21;
            int dy = 2;
            int vx = 36;
            int vy = 42;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 4; ++j) {
                    PositionedStack pos = new PositionedStack(this.getItem(j, i), dx + vx * j, dy + vy * i);
                    if (i == 1 && j == 3) continue;
                    stacks.add(pos);
                }
            }
            ExtractorBonus bonus = ExtractorBonus.getBonusForIngredient(this.getSolution());
            if (bonus != null) {
                stacks.add(new PositionedStack((Object)bonus.getBonusItem(), 147, 44));
            }
            return stacks;
        }

        private int getTick() {
            return (int)(System.currentTimeMillis() / 1000000L % (long)this.oreBlock.size());
        }

        private Object getItem(int x, int y) {
            switch (x + y * 4) {
                case 0: {
                    return this.oreBlock.get(this.getTick());
                }
                case 1: 
                case 4: {
                    return this.getDust();
                }
                case 2: 
                case 5: {
                    return this.getSlurry();
                }
                case 3: 
                case 6: {
                    return this.getSolution();
                }
            }
            return new ItemStack((Block)Blocks.field_150480_ab);
        }

        private int getSizeAt(int x, int y) {
            return 1;
        }
    }
}

