/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCompactor;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiCompactor;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class CompactorHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Compactor";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/compactorgui2.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        int dy = 4;
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, dy, 5, dy, 166, 75, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(40, 13, 33, 60), "rccompactor", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rccompactor")) {
            Collection<ItemStack> li = RecipesCompactor.getRecipes().getAllCompactables();
            for (ItemStack is : li) {
                this.arecipes.add(new CompactorRecipe(is));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rccompactor")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ItemStack is = RecipesCompactor.getRecipes().getSource(result);
        if (is != null) {
            this.arecipes.add(new CompactorRecipe(is));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (RecipesCompactor.getRecipes().isCompactable(ingredient)) {
            this.arecipes.add(new CompactorRecipe(ingredient));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCompactor.class;
    }

    public void drawExtras(int recipe) {
        ReikaGuiAPI.instance.func_73729_b(142, 26, 176, 37, 4, 44);
        ReikaGuiAPI.instance.func_73729_b(112, 25, 181, 41, 11, 46);
        int pressure = this.getPressure(recipe);
        int temperature = this.getTemperature(recipe);
        Minecraft.func_71410_x().field_71466_p.func_85187_a(String.format("Required Pressure: %d kPa", pressure), 0, 85, 0x333333, false);
        Minecraft.func_71410_x().field_71466_p.func_85187_a(String.format("Required Temperature: %dC", temperature), 0, 95, 0x333333, false);
    }

    private int getPressure(int recipe) {
        CompactorRecipe comp = (CompactorRecipe)((Object)this.arecipes.get(recipe));
        return RecipesCompactor.getRecipes().getReqPressure(comp.input);
    }

    private int getTemperature(int recipe) {
        CompactorRecipe comp = (CompactorRecipe)((Object)this.arecipes.get(recipe));
        return RecipesCompactor.getRecipes().getReqTemperature(comp.input);
    }

    public class CompactorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ItemStack input;
        private ItemStack output;

        private CompactorRecipe(ItemStack in) {
            super((TemplateRecipeHandler)CompactorHandler.this);
            this.input = in;
            this.output = RecipesCompactor.getRecipes().getCompactingResult(in);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.output, 75, 35);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)ReikaItemHelper.getSizedItemStack((ItemStack)this.input, (int)1), 71, 24);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getIngredient();
            if (stack != null) {
                for (int i = 0; i < 4; ++i) {
                    stacks.add(new PositionedStack((Object)stack.item, 21, 8 + 18 * i));
                }
            }
            return stacks;
        }
    }
}

