/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.ModInteract.PositionedStackWithTooltip;
import Reika.DragonAPI.Libraries.IO.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.IO.ReikaLiquidRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCentrifuge;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiCentrifuge;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CentrifugeHandler
extends TemplateRecipeHandler {
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack != null) {
            for (PositionedStack is : ((CentrifugeNEIRecipe)((Object)this.arecipes.get(recipe))).getOtherStacks()) {
                if (!(is instanceof PositionedStackWithTooltip) || !gui.isMouseOver(is, recipe)) continue;
                currenttip.add(((PositionedStackWithTooltip)is).tooltip);
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public String getRecipeName() {
        return "Centrifuge";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/centrifugegui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 1, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(39, 16, 40, 40), "rccentri", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rccentri")) {
            Collection<ItemStack> li = RecipesCentrifuge.getRecipes().getAllCentrifugables();
            for (ItemStack is : li) {
                this.arecipes.add(new CentrifugeNEIRecipe(RecipesCentrifuge.getRecipes().getRecipeResult(is)));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rccentri")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<ItemStack> li;
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
        if (fs != null) {
            li = RecipesCentrifuge.getRecipes().getSources(fs.getFluid());
            for (ItemStack is : li) {
                this.arecipes.add(new CentrifugeNEIRecipe(RecipesCentrifuge.getRecipes().getRecipeResult(is)));
            }
        }
        li = RecipesCentrifuge.getRecipes().getSources(result);
        for (ItemStack is : li) {
            this.arecipes.add(new CentrifugeNEIRecipe(RecipesCentrifuge.getRecipes().getRecipeResult(is)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (RecipesCentrifuge.getRecipes().isCentrifugable(ingredient)) {
            this.arecipes.add(new CentrifugeNEIRecipe(RecipesCentrifuge.getRecipes().getRecipeResult(ingredient)));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCentrifuge.class;
    }

    public void drawExtras(int recipe) {
        this.drawFluids(recipe);
    }

    private void drawFluids(int recipe) {
        CentrifugeNEIRecipe r = (CentrifugeNEIRecipe)((Object)this.arecipes.get(recipe));
        FluidStack fs = r.recipe.getFluid();
        if (fs != null) {
            Fluid f = fs.getFluid();
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            ReikaTextureHelper.bindTerrainTexture();
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            int x = 147;
            for (int i = 0; i < 4; ++i) {
                int y = 1 + i * 16;
                v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
                v5.func_78374_a((double)x, (double)(y + 16), 0.0, (double)u, (double)dv);
                v5.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, (double)du, (double)dv);
                v5.func_78374_a((double)(x + 16), (double)y, 0.0, (double)du, (double)v);
            }
            v5.func_78374_a((double)x, 65.0, 0.0, (double)u, (double)v);
            v5.func_78374_a((double)x, 68.0, 0.0, (double)u, (double)dv);
            v5.func_78374_a((double)(x + 16), 68.0, 0.0, (double)du, (double)dv);
            v5.func_78374_a((double)(x + 16), 65.0, 0.0, (double)du, (double)v);
            v5.func_78381_a();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String s = f.getLocalizedName() + " (" + fs.amount + " mB) (" + r.recipe.getFluidChance() + "%)";
            int l = fr.func_78256_a(s);
            fr.func_78276_b(s, 166 - l, 70, 0);
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class CentrifugeNEIRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private RecipesCentrifuge.CentrifugeRecipe recipe;

        private CentrifugeNEIRecipe(RecipesCentrifuge.CentrifugeRecipe in) {
            super((TemplateRecipeHandler)CentrifugeHandler.this);
            this.recipe = in;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> pos = new ArrayList<PositionedStack>();
            int num = 1 + (int)(System.currentTimeMillis() / 1000L % (long)this.recipe.maxStack);
            int dx = 80;
            int dy = 10;
            int i = 0;
            for (ChancedOutputList.ItemWithChance is : this.recipe.getItems()) {
                int x = dx + i % 3 * 18;
                int y = dy + i / 3 * 18;
                String tip = String.format("%.2f%s chance", Float.valueOf(is.getChance()), "%");
                pos.add((PositionedStack)new PositionedStackWithTooltip((Object)ReikaItemHelper.getSizedItemStack((ItemStack)is.getItem(), (int)num), x, y, tip));
                ++i;
            }
            return pos;
        }

        public PositionedStack getIngredient() {
            int num = 1 + (int)(System.currentTimeMillis() / 1000L % (long)this.recipe.maxStack);
            return new PositionedStack((Object)ReikaItemHelper.getSizedItemStack((ItemStack)this.recipe.getInput(), (int)num), 21, 28);
        }
    }
}

